%define xorgver 7.6
%define xf86 XFree86

%def_disable pdf
%def_disable txt
%def_disable html
%def_disable ps

Name: xorg-docs
Version: 1.7
Release: alt1
Serial: 1
Summary: Documentation on various X11 programming interfaces
License: MIT/X11
Group: System/X11

Url: http://xorg.freedesktop.org
Source: %name-%version.tar.bz2

Provides: %xf86-doc = 4.4 xorg-x11-doc = %xorgver
Obsoletes: %xf86-doc xorg-x11-doc

BuildArch: noarch

BuildRequires: docbook-utils docbook-utils-print xorg-sgml-doctools xorg-util-macros

%description
xorg-x11-doc provides a great deal of extensive PostScript documentation
on the various X APIs, libraries, and other interfaces.  If you need
low level X documentation, you will find it here.  Topics include the
X protocol, the ICCCM window manager standard, ICE session management,
the font server API, etc.

%prep
%setup

%build
%autoreconf
%configure \
	--build=%_arch-alt-linux \
	--host=%_arch-alt-linux \
	--enable-man \
	%{subst_enable pdf} \
	%{subst_enable txt} \
	%{subst_enable html} \
	%{subst_enable ps} \
	--with-x11docdir=%_docdir/%name-%version
%make

%install
%make DESTDIR=%buildroot install

%files
%doc %_docdir/%name
%_man7dir/*

%changelog
