%define urwdir /usr/share/fonts/type1/urw
%define srcurl ftp://ftp.foolabs.com/pub/xpdf
%def_without protections

Name: xpdf
Version: 3.03
Release: alt1

Summary: Portable Document Format (PDF) suite
License: GPLv2 or GPLv3
Group: Office

URL: http://www.foolabs.com/xpdf/
Source0: %srcurl/xpdf-%version.tar.gz

Source2: %srcurl/xpdf-cyrillic-2003-jun-28.tar.gz
Source3: %srcurl/xpdf-greek-2003-jun-28.tar.gz
Source4: %srcurl/xpdf-hebrew-2003-feb-16.tar.gz
Source5: %srcurl/xpdf-latin2-2002-oct-22.tar.gz
Source6: %srcurl/xpdf-turkish-2002-apr-10.tar.gz
Source7: %srcurl/xpdf-chinese-simplified-2004-jan-16.tar.gz
Source8: %srcurl/xpdf-chinese-traditional-2004-jan-16.tar.gz
Source9: %srcurl/xpdf-japanese-2004-jul-27.tar.gz
Source10: %srcurl/xpdf-korean-2005-jul-07.tar.gz
Source11: %srcurl/xpdf-thai-2002-jan-16.tar.gz
Source100: xpdf-16x16.png
Source101: xpdf-32x32.png
Source102: xpdf-48x48.png
Source103: xpdf.desktop

Patch2: xpdf-3.03-xpdfrc.patch

Patch5: xpdf-2.02-ext.patch
Patch6: xpdf-3.00-core.patch

Patch15: xpdf-3.00-papersize.patch
Patch16: xpdf-3.03-crash.patch
Patch17: xpdf-3.00-64bit.patch

Patch22: xpdf-3.02-additionalzoom.patch

Patch24: xpdf-3.02-fontlist.patch

# Debian patches:
Patch30: xpdf-3.03-permissions.patch
Patch31: xpdf-3.02-debian-add_accelerators.patch
# Proper stream encoding on 64bit platforms
Patch34: xpdf-debian-fix-444648.patch

Requires: fonts-type1-urw
Requires: urlview

# Finally: we choose openmotif
#BuildPreReq: openmotif-devel

# xpdf moans when xpdfrc points to thai files that does not installed.
# instead of editing xpdfrc when (un)installing xpdf-thai, we eliminate
# this package and move thai files to main xpdf package
Obsoletes: xpdf-thai

# Automatically added by buildreq on Fri Oct 01 2010
BuildRequires: gcc4.3-c++ imake libXp-devel libXpm-devel libfreetype-devel libopenmotif-devel xorg-cf-files

# xpdf now - virtual fileless package that depends on both splitted
# subpackages for compatability with previous versions
Requires: xpdf-reader = %version-%release
###Requires: xpdf-utils = %version-%release
#!!! As of xpdf-3.02-alt6 xpdf-utils nuked (obsoleted by poppler)
#!!! So now 'xpdf' package no more needed but we will not touch it

%description
Xpdf is a suite of tools for Portable Document Format (PDF) files.
PDF files are sometimes called Acrobat files, after Adobe Acrobat
(Adobe's PDF viewer).

This package is intended for compatibility with previous versions of this
package only. You can safely remove it from your system.

%package common
Summary: Portable Document Format (PDF) suite -- common files
Group: Office
BuildArch: noarch

%description common
Xpdf is an X Window System based viewer for Portable Document Format (PDF)
files. PDF files are sometimes called Acrobat files, after Adobe Acrobat
(Adobe's PDF viewer).

This package contains common files needed by the other xpdf packages.

%package reader
Summary: Portable Document Format (PDF) suite -- viewer for X11
Group: Office
Requires: %name-common = %version-%release

%description reader
Xpdf is an X Window System based viewer for Portable Document Format (PDF)
files. PDF files are sometimes called Acrobat files, after Adobe Acrobat
(Adobe's PDF viewer).

This package contains xpdf itself, a PDF viewer for X11. xpdf is designed to
be small and efficient. xpdf supports encrypted PDF files. Standard X fonts,
Truetype fonts and Type 1 fonts are supported.

This package also contains pdftoppm, a utility for converting PDF files to
Portable Pixmap formats (PBM, PGM, PPM).

See also the xpdf-utils package for conversion utilities and the other xpdf-*
packages for additional language support.

%package chinese-simplified
Summary: ISO-2022-CN, EUC-CN and GBK encoding support for xpdf
Group: Office
Requires: %name-common = %version-%release
BuildArch: noarch

%description chinese-simplified
The Xpdf language support packages include CMap files, text encodings,
and various other configuration information necessary or useful for
specific character sets. (They do not include any fonts.) 
This package provides support files needed to use the Xpdf tools with
Chinese-simplified PDF files.

%package chinese-traditional
Summary: Big5 and Big5ascii encoding support for xpdf
Group: Office
Requires: %name-common = %version-%release
BuildArch: noarch

%description chinese-traditional
The Xpdf language support packages include CMap files, text encodings,
and various other configuration information necessary or useful for
specific character sets. (They do not include any fonts.) 
This package provides support files needed to use the Xpdf tools with
Chinese-traditional PDF files.

%package japanese
Summary: ISO-2022-JP, EUC-JP and Shift-JIS encoding support for xpdf
Group: Office
Requires: %name-common = %version-%release
BuildArch: noarch

%description japanese
The Xpdf language support packages include CMap files, text encodings,
and various other configuration information necessary or useful for
specific character sets. (They do not include any fonts.) 
This package provides support files needed to use the Xpdf tools with
Japanese PDF files.

%package korean
Summary: ISO-2022-KR (KSX1001) encoding support for xpdf
Group: Office
Requires: %name-common = %version-%release
BuildArch: noarch

%description korean
The Xpdf language support packages include CMap files, text encodings,
and various other configuration information necessary or useful for
specific character sets. (They do not include any fonts.) 
This package provides support files needed to use the Xpdf tools with
Korean PDF files.

%prep
%setup -q -a2 -a3 -a4 -a5 -a6 -a7 -a8 -a9 -a10 -a11

%patch2 -p1

%patch5 -p1
%patch6 -p1

%patch15 -p1
%patch16 -p1
%patch17 -p1

%patch22 -p1

%patch24 -p1

%patch30 -p1
%patch31 -p1

%patch34 -p1

%build
# Not sure about --enable-multithreaded and --enable-wordlist options
# Now they are enabled (as in PLD), but this is subject to reevaluation.
# --enable-a4-paper removed. Why? See xpdf-3.00-papersize.patch.

export CXXFLAGS="%optflags %optflags_nocpp"
export CXX="g++-4.3"
%configure \
	--without-t1-library \
	--enable-opi \
		--enable-multithreaded \
		--enable-wordlist \
	--enable-freetype2 \
	--with-freetype2-includes=%_includedir/freetype2

make urwdir=%urwdir

subst 's@/usr/local/etc/@%_sysconfdir/@' doc/*.1 doc/*.5
subst 's@/usr/local/share/ghostscript/fonts@%urwdir@' doc/sample-xpdfrc doc/*.1 doc/*.5
subst 's@^#displayFontT1@displayFontT1@' doc/sample-xpdfrc

for i in cyrillic greek hebrew latin2 turkish \
         chinese-simplified chinese-traditional japanese korean thai; do
	subst 's@/usr/local/share/xpdf@%_datadir/xpdf@' \
		xpdf-$i/add-to-xpdfrc \
		xpdf-$i/README
	echo >> doc/sample-xpdfrc
	cat xpdf-$i/add-to-xpdfrc >> doc/sample-xpdfrc
	rm xpdf-$i/add-to-xpdfrc
done

# xpdf no longer supports X fonts
subst 's/^displayCIDFontX/#displayCIDFontX/g' doc/sample-xpdfrc

%install
%makeinstall_std
for i in cyrillic greek hebrew latin2 turkish \
         chinese-simplified chinese-traditional japanese korean thai; do
	mkdir -p %buildroot%_datadir/xpdf/$i
	cp -a xpdf-$i/* %buildroot%_datadir/xpdf/$i/
done


install -pD -m644 %_sourcedir/xpdf.desktop %buildroot%_desktopdir/xpdf.desktop
# mdk icons
install -pD -m644 %_sourcedir/xpdf-16x16.png %buildroot%_miconsdir/xpdf.png
install -pD -m644 %_sourcedir/xpdf-32x32.png %buildroot%_niconsdir/xpdf.png
install -pD -m644 %_sourcedir/xpdf-48x48.png %buildroot%_liconsdir/xpdf.png

%files

%files common
%doc CHANGES README
%config(noreplace) %_sysconfdir/xpdfrc
%_man5dir/*
%dir %_datadir/xpdf
%_datadir/xpdf/cyrillic
%_datadir/xpdf/greek
%_datadir/xpdf/hebrew
%_datadir/xpdf/latin2
%_datadir/xpdf/thai
%_datadir/xpdf/turkish

%files reader
%_bindir/xpdf
%exclude %_bindir/pdf*
%_desktopdir/*
%_man1dir/xpdf*
%exclude %_man1dir/pdf*
%_miconsdir/*.png
%_niconsdir/*.png
%_liconsdir/*.png

%files chinese-simplified
%_datadir/xpdf/chinese-simplified

%files chinese-traditional
%_datadir/xpdf/chinese-traditional

%files japanese
%_datadir/xpdf/japanese

%files korean
%_datadir/xpdf/korean

%changelog
