%define sitedocroot %_var/www/%name
%define apache_user apache
%define apache2_user apache2

Name: xsp
Version: 2.10.2
Release: alt1

Summary: standalone web server written in C# that can be used to run your ASP.NET applications
License: LGPL
Group: System/Servers

Url: http://www.mono-project.com
Packager: Mono Maintainers Team <mono@packages.altlinux.org>

#http://go-mono.com/sources/xsp/%name-%version.tar.gz
Source0: %name-%version.tar
Source1: %name.init
Source2: %name.sysconfig
Patch: %name-%version-alt-lib-path.patch

Requires: mono mono-web mono-data mono-mcs

BuildPreReq: /proc
BuildRequires: mono-devel >= 2.8
BuildRequires: mono-data mono-data-sqlite mono-data-oracle mono-mcs monodoc-devel
BuildRequires: mono-nunit-devel mono-web-devel rpm-build-mono

%package devel
Summary: Development files %name
Group: Development/Other
Requires: %name = %version-%release

%description devel
This package includes development files for the %name.

%package doc
Summary: Documentation for xsp
Group: Documentation
BuildArch: noarch
Requires: monodoc >= 2.2

%description doc
This package contains the documentation for the Mono Web Server Library (XSP)


%package samples
Summary: ASP.NET Samples for XSP server
Group: System/Servers
Requires: %name = %version-%release

%description
This package contains XSP, a standalone web server written in C#
that can be used to run ASP.NET applications as well as a set of
pages, controls and web services that you can use to experience
ASP.NET.

%description samples
ASP.NET Samples for XSP server

%prep
%setup -q
%patch -p1

%build
./autogen.sh
%configure
%make

%install
%make install DESTDIR=%buildroot
mkdir -p %buildroot%_sysconfdir/mono/mod-mono-applications
mkdir -p %buildroot%sitedocroot/
mv %buildroot%_libdir/%name/test/* %buildroot%sitedocroot/

mkdir -p %buildroot%_var/run/%name

install -m0755 %SOURCE1 -D %buildroot%_initdir/%name
install -m0644 %SOURCE2 -D %buildroot%_sysconfdir/sysconfig/%name

%pre
%_sbindir/groupadd -r -f webmaster &>/dev/null ||:
%_sbindir/groupadd -r -f %name &>/dev/null ||:
%_sbindir/useradd -r -g %name -G webmaster,%name -d %_var/www/%name -s /dev/null \
        -c "XSP Web Server" -M -n %name &>/dev/null ||:

# Add apache pseudousers to xsp group
%_sbindir/usermod -G %name$(groups %apache_user | \
	cut -d ':' -f 2 | sed 's/ /,/g') %apache_user &>/dev/null ||:
%_sbindir/usermod -G %name$(groups %apache2_user | \
	cut -d ':' -f 2 | sed 's/ /,/g') %apache2_user &>/dev/null ||:

%post
%post_service %name

%preun
%preun_service %name

%files
%_bindir/*
%_libdir/%name
%_monodir/?.0/*
%_monogacdir/Mono.WebServer*
%_monogacdir/mod-mono-server*
%_monogacdir/fastcgi-mono-server*
%_monogacdir/%{name}*
%_man1dir/*
%_sysconfdir/mono/mod-mono-applications
%config(noreplace) %_sysconfdir/sysconfig/%name
%_initdir/%name
%attr(2775,root,webmaster) %dir %sitedocroot
%attr(0730,root,%name) %dir %_var/run/%name

%files devel
%_pkgconfigdir/*

%files doc
%_monodocdir/*

%files samples
%sitedocroot/*

%changelog
