# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
%define svndate 20120106
%define svnrev 2999

Name:           xu4
Version:        1.1
Release:        alt2_0.19.%{svndate}svn%{svnrev}
Summary:        Ultima IV recreated
Group:          Games/Other
License:        GPLv2+
URL:            http://xu4.sourceforge.net/
# This was generated by running the xu4-svn-checkout.sh script
Source0:        xu4-%{svndate}svn.tar.xz
Source1:        xu4.sh
Source2:        xu4.autodlrc
Source3:        u4download.txt
Patch0:         xu4-1.0beta3-desktop.patch
Patch1:         xu4-1.1-unbundle.patch
BuildRequires:  libSDL_mixer-devel libxml2-devel libminizip-devel
BuildRequires:  libpng-devel desktop-file-utils
Requires:       icon-theme-hicolor autodownloader
Source44: import.info

%description
XU4 is a remake of the computer game Ultima IV. This game requires the
original Ultima IV datafiles, which can be freely downloaded from the internet
but may not be (re)distributed. When you start xu4 for the first time it will
offer to download the datafiles for you.

XU4 isn't a new game based on the Ultima IV story -- it is a faithful
recreation of the old game, right up to the crappy graphics.  If you
are looking for a game with modern gameplay and graphics, this is not
it -- yet.  New features that improve the gameplay and keep with the
spirit of the original game will be added.


%prep
%setup -q -n u4
%patch0 -p1 -z .desktop
%patch1 -p1 -z .unbundle
if [ "%{_lib}" = "lib64" ]; then
  sed -i 's|/usr/lib|%{_libdir}|g' src/u4file.cpp
fi
cp %{SOURCE3} .


%build
pushd src
make DEBUGCXXFLAGS="%{optflags}" EXTRALIBS=-lminizip\
  bindir=%{_bindir} datadir=%{_datadir} libdir=%{_libdir} %{?_smp_mflags}
popd


%install
pushd src
# Note: make install DESTDIR=%%{buildroot}, doesn't work
%{makeinstall}
find %{buildroot}/%{_libdir}/u4 -name '*.xml' -o -name '*.dtd'|xargs chmod -x
popd
cp -p mid/*.it %{buildroot}/%{_libdir}/u4/music

# mv u4 to u4.bin and install our autodl wrapper script
mv %{buildroot}/%{_bindir}/u4 %{buildroot}/%{_bindir}/u4.bin
install -p -m 755 %{SOURCE1} %{buildroot}/%{_bindir}/u4
install -p -m 644 %{SOURCE2} %{buildroot}/%{_libdir}/u4

# below is the desktop file and icon stuff.
desktop-file-install         \
  --dir %{buildroot}/%{_datadir}/applications \
  --delete-original                             \
  %{buildroot}/%{_datadir}/applications/u4.desktop

mkdir -p %{buildroot}/%{_datadir}/icons/hicolor/64x64/apps
mv %{buildroot}/%{_datadir}/pixmaps/u4.png \
  %{buildroot}/%{_datadir}/icons/hicolor/64x64/apps


%files
%doc AUTHORS COPYING README doc/Algorithms.* doc/*FileFormats.txt
%doc doc/U4Notes.txt doc/tools.txt u4download.txt
%{_bindir}/u4*
%{_libdir}/u4
%{_datadir}/pixmaps/u4.bmp
%{_datadir}/applications/u4.desktop
%{_datadir}/icons/hicolor/64x64/apps/u4.png


%changelog
