#set_verify_elf_method relaxed
%define _unpackaged_files_terminate_build 1

%def_without	debug
%def_without	mozldap

%define xulr_name                   xulrunner
%define xulr_prefix                 %_libdir/%xulr_name
%define xulr_datadir                %_datadir/%xulr_name
%define xulr_idldir                 %_datadir/idl/%xulr_name
%define xulr_includedir             %_includedir/%xulr_name
%define xulr_develdir               %xulr_prefix-devel

Summary:	XUL Runner
Name:		xulrunner
Version:	31.0
Release:	alt0.M70P.1

License:	MPL/GPL/LGPL
Group:		Networking/Other
Url:		http://wiki.mozilla.org/XUL:Xul_Runner
Packager:	Alexey Gladkov <legion@altlinux.ru>

Source0:	xulrunner-source.tar
Source1:	rpm-build.tar
Source2:	update-sdk.sh
Source3:	xulrunner-mozconfig
Source4:	xpi-mimeinfo.xml

Patch0:		xulrunner-no-version.patch
Patch1:		mozilla-js-makefile.patch
Patch10:	rhbz-966424.patch
Patch100:	mozilla-192-path.patch

Requires:	%name-libs = %version-%release

Requires:	hunspell-en
Requires:	libnspr       >= 4.10.1
Requires:	libnss        >= 3.15.2

Obsoletes:	xulrunner-192
Obsoletes:	xulrunner-2.0
Obsoletes:	xulrunner-5.0

Provides:	xulrunner-gnome-support = %version-%release
Obsoletes:	xulrunner-gnome-support
Obsoletes:	xulrunner-192-gnome-support
Obsoletes:	xulrunner-2.0-gnome-support

BuildRequires: doxygen gcc-c++ imake libIDL-devel makedepend
BuildRequires: libXt-devel libX11-devel libXext-devel libXft-devel libXScrnSaver-devel
BuildRequires: libcurl-devel libgtk+2-devel libhunspell-devel libjpeg-devel
BuildRequires: xorg-cf-files chrpath alternatives yasm
BuildRequires: zip unzip
BuildRequires: bzlib-devel zlib-devel
BuildRequires: libcairo-devel libpixman-devel
BuildRequires: libGL-devel
BuildRequires: libwireless-devel
BuildRequires: libalsa-devel
BuildRequires: libnotify-devel
BuildRequires: libevent-devel
BuildRequires: libproxy-devel
BuildRequires: libshell
BuildRequires: libvpx-devel
BuildRequires: libgio-devel
BuildRequires: libfreetype-devel fontconfig-devel
BuildRequires: libstartup-notification-devel
BuildRequires: libffi-devel
BuildRequires: gstreamer-devel gst-plugins-devel
BuildRequires: libopus-devel
BuildRequires: libpulseaudio-devel

# Python requires
BuildRequires: python-module-distribute
BuildRequires: python-modules-compiler
BuildRequires: python-modules-logging
BuildRequires: python-modules-sqlite3
BuildRequires: python-modules-json

# Mozilla requires
BuildRequires: libnspr-devel >= 4.10.1
BuildRequires: libnss-devel  >= 3.15.2

BuildRequires: libnss-devel-static

BuildRequires: autoconf_2.13
%set_autoconf_version 2.13

%description
XULRunner is a single "gecko runtime" installable package
that can be used to bootstrap multiple XUL+XPCOM applications


%package libs
Summary:	XULRunner libraries.
Group:		System/Libraries

Obsoletes:	xulrunner-192-libs
Obsoletes:	xulrunner-2.0-libs
Obsoletes:	xulrunner-5.0-libs

%description libs
XULRunner  libraries.


%package devel
Summary:	XULRunner development kit.
Group:		Development/C++

Requires:	python-base
AutoReq:	yes, nopython

Requires:	%name = %version-%release
Conflicts:	seamonkey-devel

Obsoletes:	xulrunner-192-devel
Obsoletes:	xulrunner-2.0-devel
Obsoletes:	xulrunner-5.0-devel

%description devel
XULRunner development kit.


%package -n rpm-build-mozilla.org
Summary:	RPM helpers to build Mozilla.org packages
Group:		Development/Other
BuildArch:	noarch
Requires:	raptor rpm-utils

%description -n rpm-build-mozilla.org
These helpers provide possibility to build Mozilla.org packages
by some Alt Linux Team Policy compatible way.


%prep
%setup -q -c -n %name-%version
cd %_builddir/%name-%version/mozilla

tar -xf %SOURCE1

%patch0 -p1
%patch1 -p1 -b .fix
#patch2 -p1

%patch10 -p1

%patch100 -p2
#patch101 -p1
#patch104 -p1

#echo 5.0.1 > config/milestone.txt

cp -f %SOURCE3 .mozconfig

%ifnarch %{ix86} x86_64 armh
echo "ac_add_options --disable-methodjit" >> .mozconfig
echo "ac_add_options --disable-monoic" >> .mozconfig
echo "ac_add_options --disable-polyic" >> .mozconfig
echo "ac_add_options --disable-tracejit" >> .mozconfig
%endif

%build
%add_optflags %optflags_shared
cd %_builddir/%name-%version/mozilla

export MOZ_BUILD_APP=xulrunner

export PREFIX='%_prefix'
export LIBDIR='%_libdir'
export INCLUDEDIR='%_includedir'
export LIBIDL_CONFIG='/usr/bin/libIDL-config-2'
export srcdir="$PWD"
export SHELL=/bin/sh

sed -i \
	-e 's,^MOZ_APP_NAME[[:space:]]*=.*,MOZ_APP_NAME = %xulr_name,' \
	config/autoconf.mk.in

cat >> xulrunner/confvars.sh <<EOF
MOZ_UPDATER=
MOZ_JAVAXPCOM=
MOZ_NATIVE_NSPR=1
MOZ_ENABLE_WARNINGS_AS_ERRORS=
MOZ_SERVICES_COMMON=1
MOZ_SERVICES_CRYPTO=1
MOZ_SERVICES_FXACCOUNTS=1
MOZ_SERVICES_HEALTHREPORT=1
MOZ_SERVICES_METRICS=1
MOZ_SERVICES_SYNC=1
EOF

%__autoconf

cd js/src
%__autoconf
cd -

MOZ_SMP_FLAGS=-j1
# On x86 architectures, Mozilla can build up to 4 jobs at once in parallel,
# however builds tend to fail on other arches when building in parallel.
%ifarch %ix86 x86_64 armh
[ "%__nprocs" -ge 2 ] && MOZ_SMP_FLAGS=-j2
[ "%__nprocs" -ge 4 ] && MOZ_SMP_FLAGS=-j4
%endif

make -f client.mk build \
	mozappdir=%xulr_prefix \
	STRIP="/bin/true" \
	MOZ_MAKE_FLAGS="$MOZ_SMP_FLAGS"


%install
cd %_builddir/%name-%version/mozilla
%__mkdir_p \
	%buildroot/%_datadir/mime/packages \
	#

%makeinstall -C objdir \
	idldir=%buildroot/%xulr_idldir \
	includedir=%buildroot/%xulr_includedir \
	mozappdir=%buildroot/%xulr_prefix \
	#

if [ ! -d "%buildroot/%xulr_prefix-devel/sdk/bin" ]; then
	mkdir -p -- "%buildroot/%xulr_prefix-devel/sdk/bin"
	find dist/sdk/bin/ '!' -type d \
		-exec install -t "%buildroot/%xulr_prefix-devel/sdk/bin" '{}' '+'
fi

%SOURCE2 \
	--develdir="%buildroot/%xulr_prefix-devel" \
	--bindir="%buildroot/%_bindir" \
	--libdir="%buildroot/%xulr_prefix" \
	--idldir="%buildroot/%xulr_idldir" \
	--includedir="%buildroot/%xulr_includedir" \
        --rpath="" \
        --verbose \
        #

# Install rpm-build-mozilla.org
mkdir -p -- %buildroot/%_datadir/%xulr_name %buildroot/%_rpmlibdir

for f in rpm-build/installrdf.sh rpm-build/applicationini.sh; do
	fn="${f##*/}"
	sed \
		-e 's,@require_gre_name@,%xulr_name,g' \
		-e 's,@rpmdatadir@,%_datadir/rpm-build-mozilla,g' \
		< "$f" > %buildroot/%_bindir/$fn
	chmod 755 -- %buildroot/%_bindir/$fn
done

install -D -m644 \
	rpm-build/mozilla-sh-functions \
	%buildroot/%_datadir/rpm-build-mozilla/mozilla-sh-functions

#install -D -m755 \
#	rpm-build/xulrunner.req* \
#	%buildroot/%_rpmlibdir/

mkdir -p -- %buildroot/%_rpmmacrosdir
sed \
	-e 's,@xulr_name@,%xulr_name,g' \
	-e 's,@xulr_version@,%version,g' \
	-e 's,@xulr_release@,%release,g' \
	rpm-build/rpm.macros.standalone > %buildroot/%_rpmmacrosdir/%xulr_name

install -D -m644 \
	%SOURCE4 \
	%buildroot/%_datadir/mime/packages/%xulr_name-mimeinfo.xml

cd %buildroot
rm -f -- \
	./%xulr_prefix/run-mozilla.sh \
	./%xulr_prefix/LICENSE \
	./%xulr_prefix/README.txt \
	./%xulr_prefix/README.xulrunner \
	./%xulr_prefix/js-gdb.py \
	./%xulr_prefix/dictionaries/* \
	./%_libdir/pkgconfig/gtkmozembed*.pc \
	#

ln -sf -- $(relative "%xulr_prefix/xulrunner" "%_bindir/%xulr_name") \
	./%_bindir/%xulr_name

# Fix *.pc
sed -i -e 's,%{buildroot},,g' ./%_libdir/pkgconfig/*.pc

# Fix SDK
ln -sf $(relative "%xulr_prefix/libmozalloc.so" "%xulr_develdir/sdk/lib/libmozalloc.so") \
	./%xulr_develdir/sdk/lib/libmozalloc.so

(set +x
	for l in libmozalloc.so libmozjs.so libxpcom.so libxul.so libmozsqlite3.so; do
		[ -f .%xulr_prefix/$l ] ||
			continue
		mv -f -- .%xulr_prefix/$l .%_libdir/$l
		ln -vs -- "$(relative %_libdir/$l %xulr_prefix/$l)" .%xulr_prefix/$l
	done
)

(set +x
	for suf in aff dic; do
		t="$(relative %_datadir/myspell/en_US.$suf %xulr_prefix/dictionaries/)"
		ln -vs "$t" ./%xulr_prefix/dictionaries/en-US.$suf
	done
)

(set +x
	find -type l -printf '%%p %%l\n' |
		egrep '(\.\./){4,}' |
		cut -d\  -f1 |
	while read f; do
		t="$(readlink -ev "$f")";
		l="$(relative "${f#.}" "$t")";
		ln -vnsf "$l" "$f";
	done
)

%pre
[ ! -L '%xulr_prefix/defaults' ] || rm -f '%xulr_prefix/defaults'

%files
%_bindir/%xulr_name
%xulr_prefix
%_datadir/mime/packages/*.xml

%files libs
%_libdir/*.so*

%files devel
%_libdir/pkgconfig/*
%xulr_includedir
%xulr_develdir
%xulr_idldir

%files -n rpm-build-mozilla.org
%_bindir/installrdf.sh
%_bindir/applicationini.sh
%_rpmmacrosdir/xulrunner
#_rpmlibdir/xulrunner.req*
%_datadir/rpm-build-mozilla/mozilla-sh-functions

%changelog
