%define zabbix_user	zabbix
%define zabbix_group	zabbix
%define zabbix_home	/dev/null
%define svnrev 65976

%def_with pgsql

%ifndef _unitdir
%define _unitdir %systemd_unitdir
%endif

Name: zabbix
Version: 3.0.8
Release: alt0.M70P.1

Packager: Alexei Takaseev <taf@altlinux.ru>

Serial: 1

Summary: A network monitor
License: GPLv2
Group: Monitoring

Url: http://www.zabbix.com

# http://heanet.dl.sourceforge.net/sourceforge/%name/%name-%version.tar.gz
Source0: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildPreReq: /proc
BuildPreReq: libelf-devel
BuildRequires(pre): rpm-build-webserver-common

# Automatically added by buildreq on Sat Feb 27 2016 (-bi)
# optimized out: elfutils libcom_err-devel libkrb5-devel libnet-snmp30 libpq-devel libssl-devel net-snmp-config pkg-config python-base
BuildRequires: libcurl-devel libelf-devel libiksemel-devel libldap-devel libmysqlclient-devel
BuildRequires: libnet-snmp-devel libopenipmi-devel libsqlite3-devel libxml2-devel perl-Switch

%if_with pgsql
BuildRequires: postgresql-devel
%endif

%package common
Summary: %name network monitor (common stuff)
Group: Monitoring
Provides: %_sysconfdir/%name
Provides: %_logdir/%name
BuildArch: noarch

%package server-common
Summary: %name network monitor (server common stuff)
Group: Monitoring
Requires: %name-common >= 1:2.0.4-alt1

%package server-mysql
Summary: %name network monitor (server, compiled with MySQL support)
Group: Monitoring
Requires: %name-server-common >= 1:2.0.4-alt1
Requires: %_sbindir/fping
Obsoletes: %name-mysql < 1:1.1.7-alt1

%if_with pgsql
%package server-pgsql
Summary: %name network monitor (server, compiled with PostgreSQL support)
Group: Monitoring
Requires: %name-server-common >= 1:2.0.4-alt1
Requires: %_sbindir/fping
Obsoletes: %name-pgsql < 1:1.1.7-alt1
%endif

%package agent
Summary: %name agent
Group: Monitoring
Requires: %name-common >= 1:2.0.4-alt1

%package agent-sudo
Summary: sudo entry for %name agent
Group: Monitoring
BuildArch: noarch
Requires: %name-agent

%package proxy
Summary: %name proxy
Group: Monitoring
Requires: %name-common >= 1:2.0.4-alt1
Requires: %_sbindir/fping

%package phpfrontend-engine
Summary: zabbix web frontend (php)
Group: Monitoring
Requires: php-engine
Obsoletes: %name-phpfrontend < 1:1.1.7-alt1
BuildArch: noarch

%package phpfrontend-php5
Summary: zabbix web frontend, edition for php5
Group: Monitoring
Requires: php5-gd2 php5-mysqli php5-pgsql php5-sockets php5-mbstring php5-dom
BuildArch: noarch

%package phpfrontend-apache
Summary: %name-phpfrontend's apache config files
Group: Monitoring
Requires: %name-phpfrontend-engine = %serial:%version-%release, apache-base
BuildArch: noarch

%package phpfrontend-apache2
Summary: %name-phpfrontend's apache2 config files
Group: Monitoring
Requires: %name-phpfrontend-engine = %serial:%version-%release, apache2-base
BuildArch: noarch

%package phpfrontend-apache2-mod_php5
Summary: Requirements for the use of apache2-mod_php5
Group: Monitoring
Requires: %name-phpfrontend-apache2
Requires: apache2-httpd-prefork-like
Requires: apache2-mod_php5
BuildArch: noarch

%package doc
Summary: %name network monitor documentation (README, ChangeLog, Manual)
Group: Monitoring
BuildArch: noarch

%package contrib
Summary: %name network monitor (additional scripts)
Group: Monitoring
BuildArch: noarch

%description
ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%description common
Common files and docs for zabbix network monitor

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%description server-common
common stuff for zabbix server

%description server-mysql
zabbix server, compiled with MySQL support

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%if_with pgsql
%description server-pgsql
zabbix server, compiled with PostgreSQL support
%endif

%description proxy
zabbix network monitor proxy daemon.

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%description agent
zabbix network monitor agent.

ZABBIX is software for monitoring of your applications, network and servers.
ZABBIX supports both polling and trapping techniques to collect data from
monitored hosts. A flexible notification mechanism allows easy and quickly
configure different types of notifications for pre-defined events.

%description agent-sudo
Sudo entry for zabbix agent.

%description phpfrontend-apache
zabbix's apache config files

%description phpfrontend-apache2
zabbix's apache2 config files

%description phpfrontend-apache2-mod_php5
Contains requirements for the use of apache2-mod_php5
in to zabbix phpfrontend

%description phpfrontend-engine
a php frontend for zabbix - core

%description phpfrontend-php5
zabbix web frontend, edition for php5

%description doc
%name network monitor (README, ChangeLog)

%description contrib
%name network monitor (additional scripts)

%prep
%setup
%patch0 -p1

%build
# fix ZABBIX_REVISION
sed -i -e "s,{ZABBIX_REVISION},%svnrev," include/version.h

%autoreconf

# we must call this for produce dbsync.h
#pushd create/schema
#./gen.pl c >../../include/dbsync.h
#popd

%configure --with-mysql \
	--with-net-snmp \
	--enable-server \
	--enable-ipv6 \
	--with-ldap \
	--with-libcurl \
	--with-libxml2 \
	--with-jabber \
	--with-openipmi \
	--with-openssl \
	--sysconfdir=/etc/zabbix
%make dbschema
%make

mv src/%{name}_server/%{name}_server src/%{name}_server/%{name}_mysql
%make clean

%if_with pgsql
%configure --with-postgresql \
	--with-net-snmp \
	--enable-server \
	--enable-ipv6 \
	--with-ldap \
	--with-libcurl \
	--with-libxml2 \
	--with-jabber \
	--with-openipmi \
	--with-openssl \
	--sysconfdir=/etc/zabbix
%make dbschema
%make

mv src/%{name}_server/%{name}_server src/%{name}_server/%{name}_pgsql
%make clean
%endif

%configure --with-sqlite3 \
	--enable-proxy \
	--enable-ipv6 \
	--with-libcurl \
	--with-libxml2 \
	--with-net-snmp \
	--with-ldap \
	--enable-agent \
	--with-jabber \
	--with-openipmi \
	--with-openssl \
	--sysconfdir=/etc/zabbix
%make

# create database upgrades
pushd upgrades
mkdir dbpatches-final
%make dist-hook distdir=dbpatches-final
popd

# adjust in several files /home/zabbix
find conf -type f -print0 | xargs -0 sed -i \
	-e "s,/home/zabbix/bin,/usr/sbin,g" \
	-e "s,PidFile=/tmp,PidFile=%_var/run/zabbix,g" \
	-e "s,LogFile=/tmp,LogFile=%_logdir/zabbix,g" \
	-e "s,/home/zabbix/lock,%_var/lock/subsys/zabbix,g" \
	-e "s,/tmp/mysql.sock,%_localstatedir/mysql/mysql.sock,g" \
	-e "s,Include=/usr/local/etc/zabbix_agentd.conf.d/,Include=%_sysconfdir/%name/zabbix_agentd.conf.d/,g" --

%install

# Generate *.mo files
for pofile in `find frontends/php/locale -type f ! -wholename '*/.svn*' -name '*.po'`
do
    msgfmt --use-fuzzy -c -o ${pofile%%po}mo $pofile
done

%makeinstall

# create directory structure
install -dm1775 %buildroot%_logdir/%name
install -dm0755 %buildroot%_sbindir
install -dm0750 %buildroot%_sysconfdir/%name
install -dm0750 %buildroot%_sysconfdir/%name/zabbix_agentd.conf.d
install -dm0755 %buildroot%webserver_webappsdir/%name
install -dm0755 %buildroot%_unitdir

# binaries
install -m0755 src/%{name}_*/%{name}_{mysql,agentd} %buildroot%_sbindir
%if_with pgsql
install -m0755 src/%{name}_server/%{name}_pgsql %buildroot%_sbindir
%endif

# conf files
install -m0640 conf/%{name}_{server,agentd,proxy}.conf %buildroot%_sysconfdir/%name
#install -m0640 misc/conf/%{name}_agentd/userparameter_{examples,mysql}.conf %buildroot%_sysconfdir/%name
install -Dpm 644 sources/%name-tmpfiles.conf %buildroot/lib/tmpfiles.d/%name.conf

# frontends
mv frontends/php/locale/*.sh .
cp -r frontends %buildroot%webserver_webappsdir/%name/

# apache config
install -pDm0644 sources/%name.conf %buildroot%_sysconfdir/httpd/conf/addon-modules.d/%name.conf

# apache2 config
install -pDm0644 sources/%name.conf %buildroot%_sysconfdir/httpd2/conf/addon.d/A.%name.conf

# start scripts
install -pDm0755 sources/%{name}_agentd.init %buildroot%_initdir/%{name}_agentd
install -pDm0644 sources/%{name}_agentd.service %buildroot%_unitdir/%{name}_agentd.service
install -pDm0644 sources/zabbix_server %buildroot%_sysconfdir/sysconfig/zabbix_server
%if_with pgsql
install -pDm0755 sources/%{name}_pgsql.init %buildroot%_initdir/%{name}_pgsql
install -pDm0644 sources/%{name}_pgsql.service %buildroot%_unitdir/%{name}_pgsql.service
%endif
install -pDm0755 sources/%{name}_mysql.init %buildroot%_initdir/%{name}_mysql
install -pDm0644 sources/%{name}_mysql.service %buildroot%_unitdir/%{name}_mysql.service
install -pDm0755 sources/%{name}_proxy.init %buildroot%_initdir/%{name}_proxy
install -pDm0644 sources/%{name}_proxy.service %buildroot%_unitdir/%{name}_proxy.service

# sudo entry
install -pDm0400 sources/%name.sudo %buildroot%_sysconfdir/sudoers.d/%name

# database upgrades
mkdir -p upgrades-{mysql,postgresql}
mv upgrades/dbpatches-final/dbpatches/1.6/mysql upgrades-mysql/1.6
mv upgrades/dbpatches-final/dbpatches/1.8/mysql upgrades-mysql/1.8
mv upgrades/dbpatches-final/dbpatches/2.0/mysql upgrades-mysql/2.0
mv upgrades/dbpatches-final/dbpatches/1.6/postgresql upgrades-postgresql/1.6
mv upgrades/dbpatches-final/dbpatches/1.8/postgresql upgrades-postgresql/1.8
mv upgrades/dbpatches-final/dbpatches/2.0/postgresql upgrades-postgresql/2.0

# ChangeLog
bzip2 ChangeLog

%pre common
/usr/sbin/groupadd -r -f %zabbix_group ||:
/usr/sbin/useradd -g %zabbix_group -G proc -c 'Zabbix' \
	-d %zabbix_home -s /dev/null -r %zabbix_user >/dev/null 2>&1 ||:

%post server-mysql
%post_service zabbix_mysql

%preun server-mysql
%preun_service zabbix_mysql
%if_with pgsql
%post server-pgsql
%post_service zabbix_pgsql

%preun server-pgsql
%preun_service zabbix_pgsql
%endif

%post proxy
%post_service zabbix_proxy

%preun proxy
%preun_service zabbix_proxy
%post agent
%post_service zabbix_agentd
if [ $1 -eq 1 ]; then
	sed -i -e "s,Hostname=Zabbix server,Hostname=$HOSTNAME,g" \
	%_sysconfdir/%name/%{name}_agentd.conf
fi

%post agent-sudo
if [ $1 -eq 1 ]; then
	gpasswd -a %zabbix_user wheel
fi

%preun agent
%preun_service zabbix_agentd
%post phpfrontend-apache
%_initdir/httpd reload >/dev/null 2>&1 ||:

%postun phpfrontend-apache
%_initdir/httpd reload >/dev/null 2>&1 ||:

%files common
%dir %attr(1775,root,%zabbix_group) %_logdir/%name
%dir %_sysconfdir/%name
/lib/tmpfiles.d/*

%files server-common
%_bindir/%{name}_get
%config(noreplace) %_sysconfdir/sysconfig/zabbix_server
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%name/%{name}_server.conf
%_man1dir/%{name}_get.*

%files server-mysql
%_sbindir/%{name}_mysql
%_initdir/%{name}_mysql
%_unitdir/*mysql*
%doc database/mysql/schema.sql database/mysql/data.sql database/mysql/images.sql
%doc upgrades-mysql

%if_with pgsql
%files server-pgsql
%_sbindir/%{name}_pgsql
%_initdir/%{name}_pgsql
%_unitdir/*pgsql*
%doc database/postgresql/schema.sql database/postgresql/data.sql database/postgresql/images.sql
%doc upgrades-postgresql
%endif

%files proxy
%_sbindir/%{name}_proxy
%_initdir/%{name}_proxy
%_unitdir/*proxy*
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%name/%{name}_proxy.conf
%_man8dir/%{name}_proxy.*

%files agent
%config(noreplace) %attr(0640,root,%zabbix_group) %_sysconfdir/%name/%{name}_agentd.conf
%dir %attr(0750,root,%zabbix_group) %_sysconfdir/%name/zabbix_agentd.conf.d
%_initdir/%{name}_agentd
%_unitdir/*agent*
%_sbindir/%{name}_agentd
%_bindir/%{name}_sender
%_man8dir/%{name}_agentd.*
%_man1dir/%{name}_sender.*

%files agent-sudo
%config(noreplace) %attr(0400,root,root) %_sysconfdir/sudoers.d/%name

%files phpfrontend-engine
%webserver_webappsdir/%name
%doc add_new_language.sh make_mo.sh update_po.sh

%files phpfrontend-php5
%files phpfrontend-apache
%config(noreplace) %_sysconfdir/httpd/conf/addon-modules.d/%name.conf

%files phpfrontend-apache2
%config(noreplace) %_sysconfdir/httpd2/conf/addon.d/A.%name.conf

%files phpfrontend-apache2-mod_php5
%files doc
%doc AUTHORS NEWS README INSTALL ChangeLog.bz2

%files contrib
%doc misc/snmptrap/*

%changelog
