%define ver_major 3.8
%def_enable libnotify
%def_enable webkitgtk

Name: zenity
Version: %ver_major.0
Release: alt1

Summary: The GNOME port of dialog(1)
License: LGPLv2+
Group: Graphical desktop/GNOME

URL: http://ftp.gnome.org/pub/gnome/sources/%name/
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

# from configure.in
%define intltool_ver 0.40.0
%define gtk_ver 3.0.0

BuildPreReq: gnome-common docbook-dtds yelp-tools
BuildPreReq: intltool >= %intltool_ver
BuildPreReq: glib2-devel
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: perl-XML-Parser xsltproc
%{?_enable_libnotify:BuildPreReq: libnotify-devel >= 0.7.0}
%{?_enable_webkitgtk:BuildRequires: libwebkitgtk3-devel}

%description
Zenity is a tool that allows you to display Gtk+ dialog boxes from
the command line and through shell scripts.  It is similar to gdialog,
but is intended to be saner.  It comes from the same family as dialog,
Xdialog, and cdialog, but it surpasses those projects by having
a cooler name.

%prep
%setup -q

%build
%configure \
	%{subst_enable libnotify} \
	%{subst_enable webkitgtk}

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_bindir/gdialog
%_datadir/%name
%_man1dir/*
%doc AUTHORS NEWS README THANKS TODO

%changelog
