%def_enable shared
%def_enable static
# FIXME script require bash 4
%def_disable sysvinit
%def_disable systemd
%def_with selinux

Name: zfs
%define lname lib%name
Version: 0.6.3
Release: alt2
Summary: ZFS on Linux
License: GPLv2+
Group: System/Kernel and hardware
URL: http://zfsonlinux.org
Source: http://archive.zfsonlinux.org/downloads/zfsonlinux/%name/%name-%version.tar
Patch: %name-%version-%release.patch
Conflicts: fuse-zfs

BuildRequires: zlib-devel libuuid-devel %{?_with_selinux:libselinux-devel} rpm-build-kernel

%description
ZFS is an advanced file system and volume manager which was originally developed
for Solaris and is now maintained by the Illumos community.
ZFS on Linux, which is also known as ZoL, is currently feature complete.
It includes fully functional and stable SPA, DMU, ZVOL, and ZPL layers.


%if_enabled shared
%package -n %lname
Summary: ZFS shared libraries
Group: System/Libraries

%description -n %lname
ZFS is an advanced file system and volume manager which was originally developed
for Solaris and is now maintained by the Illumos community.
ZFS on Linux, which is also known as ZoL, is currently feature complete.
It includes fully functional and stable SPA, DMU, ZVOL, and ZPL layers.
This package contains ZFS shared libraries.
%endif


%package -n %lname-devel
Summary: ZFS development files
Group: Development/C
Requires: %lname%{?_disable_shared:-devel-static} = %version-%release

%description -n %lname-devel
ZFS is an advanced file system and volume manager which was originally developed
for Solaris and is now maintained by the Illumos community.
ZFS on Linux, which is also known as ZoL, is currently feature complete.
It includes fully functional and stable SPA, DMU, ZVOL, and ZPL layers.
This package contains ZFS evelopment files.


%if_enabled static
%package -n %lname-devel-static
Summary: ZFS static libraries
Group: Development/C
Requires: %lname-devel = %version-%release

%description -n %lname-devel-static
ZFS is an advanced file system and volume manager which was originally developed
for Solaris and is now maintained by the Illumos community.
ZFS on Linux, which is also known as ZoL, is currently feature complete.
It includes fully functional and stable SPA, DMU, ZVOL, and ZPL layers.
This package contains ZFS static libraries.
%endif


%package utils
Summary: Utilities for doing and managing mounts of the Linux ZFS filesystem
Group: System/Kernel and hardware
%{?_enable_shared:Requires: %lname = %version-%release}
# FIXME init script require bash >= 4
%{?_enable_sysvinit:BuildRequires: bash >= 4}

%description utils
ZFS is an advanced file system and volume manager which was originally developed
for Solaris and is now maintained by the Illumos community.
ZFS on Linux, which is also known as ZoL, is currently feature complete.
It includes fully functional and stable SPA, DMU, ZVOL, and ZPL layers.
This package contains utilities for doing and managing mounts of the Linux ZFS
filesystem.


%package -n kernel-source-%name
Summary: ZFS modules sources for Linux kernel
Group: Development/Kernel
BuildArch: noarch
Provides: kernel-src-%name = %version-%release
Requires: kernel-source-spl = %version
Requires: kernel-source-spl >= 0.6.2-alt4

%description -n kernel-source-%name
ZFS is an advanced file system and volume manager which was originally developed
for Solaris and is now maintained by the Illumos community.
ZFS on Linux, which is also known as ZoL, is currently feature complete.
It includes fully functional and stable SPA, DMU, ZVOL, and ZPL layers.
This package contains ZFS modules sources for Linux kernel.


%prep
%setup -q
%patch -p1
sed -i '/^AC_OUTPUT/itest "x$ZFS_CONFIG" != "xkernel" || ac_config_files="module/Makefile module/avl/Makefile module/nvpair/Makefile module/unicode/Makefile module/zcommon/Makefile module/zfs/Makefile module/zpios/Makefile"\n' configure.ac


%build
./autogen.sh

tar -C .. \
	--exclude .gitignore \
	--exclude 'include/*Makefile.*' \
	-cJf %name-%version.tar.xz \
	%name-%version/module \
	%name-%version/config/{{install-,ltmain.}sh,config.{awk,guess,sub},missing} \
	%name-%version/include \
	%name-%version/{AUTHORS,COPYRIGHT,DISCLAIMER,META,OPENSOLARIS.LICENSE,configure,%name{.release,_config.h}.in}

%configure \
	--with-config=user \
	%{subst_enable shared} \
	%{subst_enable static} \
	%{subst_enable sysvinit} \
	%{subst_enable systemd} \
	%{subst_with selinux} \
	--with-systemdunitdir=%_unitdir \
	--with-systemdpresetdir=%_unitdir-preset \
	--with-udevdir=/lib/udev \
	--with-dracutdir=/lib/dracut \
	--with-gnu-ld
%make_build


%install
install -pD -m 0644 {,%kernel_srcdir/}%name-%version.tar.xz
%makeinstall_std DEFAULT_INIT_DIR=%_initddir modulesloaddir=/lib/modules-load.d


%if_enabled shared
%files -n %lname
%_libdir/*.so.*
%endif


%files -n %lname-devel
%_includedir/*
%{?_enable_shared:%_libdir/*.so}


%if_enabled static
%files -n %lname-devel-static
%_libdir/*.a
%endif


%files utils
%doc AUTHORS COPYRIGHT DISCLAIMER META OPENSOLARIS.LICENSE README*
/sbin/*
%_bindir/*
%_sbindir/*
%_man1dir/*
%_man5dir/*
%_man8dir/*
%_sysconfdir/%name
%_datadir/%name
%_libexecdir/%name
/lib/udev/rules.d/*
/lib/udev/*_id
%{?_enable_sysvinit:%_initddir/*}
%if_enabled systemd
%_unitdir/*
%exclude %_unitdir-preset
%exclude /lib/modules-load.d
%endif
%exclude /lib/dracut
%exclude %_datadir/%name/zpios*
%exclude %_datadir/%name/smb.sh


%files -n kernel-source-%name
%_usrsrc/kernel


%changelog
