%define zmuid $(id -un)
%define zmgid $(id -gn)
%define zmuid_final apache
%define zmgid_final apache

Name: zoneminder
Version: 1.27.0
Release: alt1.M70P.1
Summary: A camera monitoring and analysis tool
Group: System/Servers 
License: GPL
Url: http://www.zoneminder.com
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
#Source1: cambozola-%version.tar.bz2
Source2: zoneminder.conf
Source3: redalert.wav
Source4: README.alt
Source5: README-nginx-ru.alt
Source6: nginx-zoneminder.conf.sample
Source7: zm-fcgi.inc

Conflicts: zm <= 1.22.3
Requires: libgnutls libgnutls-openssl zlib perl-Class-Date perl-DateTime perl-Date-Manip perl-libwww ffmpeg perl-X10 perl-Sys-Mmap perl-DBD-mysql perl-Storable MySQL-client php5-mysql su perl-Sys-Mmap webserver
AutoReq: noperl
BuildRequires: bzlib-devel ffmpeg gcc-c++ libavdevice-devel libavformat-devel libgcrypt-devel libgnutls-openssl-devel libjpeg-devel libmysqlclient-devel libpcre-devel libswscale-devel netpbm perl-Archive-Tar perl-Archive-Zip perl-DBD-mysql perl-Date-Manip perl-MIME-Lite perl-MIME-tools perl-Module-Load perl-Sys-Mmap perl-X10 perl-devel perl-libwww zlib-devel

%description
ZoneMinder is a set of applications which is intended to provide a complete
solution allowing you to capture, analyse, record and monitor any cameras you
have attached to a Linux based machine. It is designed to run on kernels which
support the Video For Linux (V4L) interface and has been tested with cameras
attached to BTTV cards, various USB cameras and IP network cameras. It is
designed to support as many cameras as you can attach to your computer without
too much degradation of performance. This package includes cambozola.jar.

%package apache
Summary: Zoneminder configuration file and requires for apache
Group: Networking/WWW
Requires: apache apache-mod_php5 apache-mod_perl
BuildArch: noarch
%description apache
Zoneminder configuration file and requires for apache

%package nginx
Summary: Zoneminder configuration file and requires for nginx
Group: Networking/WWW
Requires: php5-fpm-fcgi spawn-fcgi >= 1.6.3-alt3.M70P.1 fcgiwrap nginx
BuildArch: noarch
%description nginx
Zoneminder configuration file and requires for nginx

%prep
%setup
%patch0 -p1
cp %SOURCE4 README.alt
cp %SOURCE5 README-nginx-ru.alt

cat <<EOF >> db/zm_create.sql.in
update Config set Value = '/cgi-bin/zm/nph-zms' where Name = 'ZM_PATH_ZMS';
use mysql;
grant select,insert,update,delete on zm.* to 'zmuser'@localhost identified by 'zmpass';
EOF

%build
autoreconf -fisv
OPTS=""

%configure \
	--with-libarch=%_lib \
	--with-mysql=%prefix \
	--with-webdir=%_datadir/%name/www \
	--with-cgidir=%_libexecdir/%name/cgi-bin \
	--with-webuser=%zmuid \
	--with-webgroup=%zmgid \
	--disable-debug \
	--with-ffmpeg=%prefix \
	--enable-mmap CPPFLAGS="-D__STDC_CONSTANT_MACROS" \
	--disable-crashtrace \
	$OPTS
make %{?_smp_mflags}
perl -pi -e 's/(ZM_WEB_USER=).*$/${1}%{zmuid_final}/;' \
    -e 's/(ZM_WEB_GROUP=).*$/${1}%{zmgid_final}/;' zm.conf

%install
install -d %buildroot%_var/run
%make_install install DESTDIR=%buildroot \
	     INSTALLDIRS=vendor
rm -rf %buildroot%prefix/%_lib/perl5/vendor_perl/*.*/*-*
rm -rf %buildroot%prefix/%_lib/perl5/*.*/*-*

install -m 755 -d %buildroot%_var/log/zoneminder
for dir in events images temp
do
	install -m 755 -d %buildroot%_localstatedir/zoneminder/$dir
	rmdir %buildroot%_datadir/%name/www/$dir
	ln -sf ../../../..%_localstatedir/zoneminder/$dir %buildroot%_datadir/%name/www/$dir
done
install -D -m 755 scripts/zm %buildroot%_initdir/zoneminder
install -D -m 644 %SOURCE2 %buildroot%_sysconfdir/httpd/conf/addon-modules.d/zoneminder.conf
install -D -m 644 zm.conf %buildroot%_sysconfdir/zm.conf
install -D -m 755 %SOURCE3 %buildroot%_datadir/%name/www/sounds/redalert.wav
install -D -m 644 %SOURCE6 %buildroot%_sysconfdir/nginx/sites-enabled.d/nginx-zoneminder.conf.sample
install -D -m 644 %SOURCE7 %buildroot%_sysconfdir/nginx/sites-enabled.d/zm-fcgi.inc


rm -f %buildroot%perl_vendor_archlib/perllocal.pod
mkdir -p %buildroot%_datadir/%name/db
cp db/*.sql %buildroot%_datadir/%name/db


%post
/sbin/chkconfig --add zoneminder

%post apache
%post_service httpd

%preun apache
%preun_service httpd

%preun
if [ $1 -eq 0 ]; then
	/sbin/service zoneminder stop > /dev/null 2>&1 || :
	/sbin/chkconfig --del zoneminder
fi

%postun
if [ $1 -ge 1 ]; then
	/sbin/service zoneminder condrestart > /dev/null 2>&1 || :
fi

%files
%doc AUTHORS COPYING README.md README.alt
%config(noreplace) %_sysconfdir/zm.conf
%_initdir/zoneminder
%_bindir/*
%_datadir/%name
%perl_vendorlib/ZoneMinder*
%_libexecdir/%name
%dir %perl_vendor_autolib/ZoneMinder
%dir %attr(755,%zmuid_final,%zmgid_final) %_var/log/zoneminder
%dir %attr(755,%zmuid_final,%zmgid_final) %_localstatedir/zoneminder
%dir %attr(755,%zmuid_final,%zmgid_final) %_localstatedir/zoneminder/events
%dir %attr(755,%zmuid_final,%zmgid_final) %_localstatedir/zoneminder/images
%dir %attr(755,%zmuid_final,%zmgid_final) %_localstatedir/zoneminder/temp

%files apache
%config(noreplace) %_sysconfdir/httpd/conf/addon-modules.d/zoneminder.conf

%files nginx
%doc README-nginx-ru.alt
%config(noreplace) %_sysconfdir/nginx/sites-enabled.d/*

%changelog
