# This spec is backported to ALTLinux p7 automatically by rpmbph script. Do not edit it.
#
Name: zpaq
Version: 705
Release: alt1.M70P.2

Summary: A journaling archiver optimized for backup

Group: Archiving/Compression
License: Public domain
Url: http://mattmahoney.net/dc/zpaq.html

# Use $ rpmrb NEWVERSION for update the package
Source: http://mattmahoney.net/dc/%name%version.zip

# Automatically added by buildreq on Thu Mar 21 2013
# optimized out: libstdc++-devel
BuildRequires: gcc-c++ libgomp-devel unzip perl-podlators

%description
zpaq is a journaling archiver optimized for user-level incremental
backup of directory trees. It supports 10 multi-threaded compression
levels and file fragment level deduplication. It adds only files whose
date has changed, and keeps both old and new versions. You can roll
back the archive date to restore from old versions of the archive.
The default compression level is faster than zip usually with better
compression.

zpaq is (C) 2012, Dell Inc., written by Matt Mahoney.

%package -n lib%name
Group: System/Libraries
Summary: A journaling archiver optimized for backup library
%description -n lib%name
A journaling archiver optimized for backup library

%package -n lib%name-devel
Group: Development/C++
Summary: Development environment for lib%name
%description -n lib%name-devel
A journaling archiver optimized for backup library,
development environment.

%prep
%setup -c

%build
# XXX this is for funny libzpaq::error() callback
%set_verify_elf_method unresolved=relaxed

%add_optflags -Wall
g++ %optflags -Dunix -shared -fPIC libzpaq.cpp -Wl,-soname,%name.so.0 -o lib%name.so.0 -lm -lpthread
ln -s lib%name.so.0 lib%name.so
g++ %optflags -Dunix -DNDEBUG zpaq.cpp -L.  -o zpaq -l%name -lm -lpthread
#g++ %optflags -Dunix zpaqd.cpp -L. -l%name -o zpaqd -L. -lzpaq -lm
pod2man zpaq.pod > zpaq.1

%install
install -D zpaq %buildroot%_bindir/zpaq
install -D zpaq %buildroot%_bindir/
install -D lib%name.so.0 %buildroot%_libdir/lib%name.so.0
install -D libzpaq.h %buildroot%_includedir/libzpaq.h
ln -s lib%name.so.0 %buildroot%_libdir/lib%name.so
install -m0644 -D zpaq.1 %buildroot%_man1dir/zpaq.1

%files
%doc readme.txt
%_bindir/*
%_man1dir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*.h

%changelog
