Name: zsh
Version: 5.0.0
Release: alt1
Epoch: 1

Summary: A shell with lots of features
License: BSD-like
Group: Shells

Url: http://www.zsh.org
Source: %name-%version.tar
Patch: zsh-%version-%release.patch

Provides: zsh-doc = %epoch:%version
Obsoletes: zsh-doc < %epoch:%version

# Automatically added by buildreq on Sun Jun 21 2009
BuildRequires: libcap-devel libgdbm-devel libncursesw-devel libpcre-devel yodl

# For make check
BuildPreReq: /dev/pts

%description
Zsh is a UNIX command interpreter (shell) usable as an interactive
login shell and as a shell script command processor.  Of the standard
shells, zsh most closely resembles ksh but includes many enhancements.
Zsh has command-line editing, built-in spelling correction, programmable
command completion, shell functions (with autoloading), a history
mechanism, and a lots of other features.

%prep
%setup
%patch -p1
rm config.guess config.sub

%build
%autoreconf
cp -f %_datadir/automake/config.{guess,sub} .

# Disable libnsl/NIS support.
export ac_cv_search_yp_all=no zsh_cv_sys_nis=no zsh_cv_sys_nis_plus=no

# YODL is not required, pre-generated man pages are shipped.
export YODL=yodl PDFETEX=pdfetex TEXI2PDF=texi2pdf

# Avoid autoconf thinking it should strip when linking.
export LDFLAGS=

%configure \
	--enable-etcdir=%_sysconfdir \
	--enable-fndir=%_datadir/zsh \
	--enable-scriptdir=%_datadir/zsh/scripts \
	--enable-site-fndir=/usr/local/share/zsh \
	--enable-site-scriptdir=/usr/local/share/zsh/scripts \
	--enable-function-subdirs \
	--enable-maildir-support \
	--with-curses-terminfo \
	--with-tcsetpgrp \
	--enable-cap \
	--enable-pcre \
	--enable-multibyte \
	%{?_enable_debug: --enable-zsh-{,mem-,hash-}debug } \
	%{?_enable_debug: --enable-zsh-{mem-warning,secure-free} } \
	#

# We don't expect that something is broken.
grep '^#define.*BROKEN' config.h && exit 1

%make_build MODDIR=%_libdir all info
%make_build MODDIR=%_libdir -C Etc

%install
%makeinstall_std MODDIR=%_libdir install.info

# Relocate to /bin.
mkdir -p %buildroot/bin
mv %buildroot%_bindir/zsh %buildroot/bin/zsh
ln -s "$(relative /bin/zsh %_bindir/zsh)" %buildroot%_bindir/zsh

# Configuration files.
mkdir -p %buildroot%_sysconfdir
for f in zshenv zprofile zshrc zlerc zlogout; do
	install -p -m644 zcfg/$f %buildroot%_sysconfdir/$f
done

# Fix paths.
find %buildroot%_datadir/zsh -type f -print0 |
	xargs -r0 grep -FZl /usr/local/bin/zsh |
	xargs -r0 subst -p s:/usr/local/bin/zsh:/bin/zsh:g

# Drop useless crap
rm -f %buildroot%_datadir/zsh/Completion/Linux/_rpmbuild

%check
make check

%files
# Completions that provided by upstream
%exclude %_datadir/zsh/Completion/Unix/_systemd

/bin/zsh
%_bindir/zsh
%_libdir/zsh/
%_datadir/zsh/
%config(noreplace) %_sysconfdir/z*[a-z]
%_man1dir/zsh*.*
%_infodir/zsh.info*
%doc LICENCE META-FAQ NEWS README StartupFiles/z*
%doc Etc/BUGS Etc/CONTRIBUTORS Etc/FAQ Etc/STD-TODO Etc/TODO

%changelog
