%global pkgname		dirsrv
%global groupname	%{pkgname}.target
%def_without selinux

Summary: 389 Administration Server
Name:    389-admin
Version: 1.1.46
Release: alt1.M80P.1
License: GPLv2
Url:     http://port389.org/
# VCS:   https://git.fedorahosted.org/git/389/admin.git
Group:   System/Servers

BuildRequires: 389-adminutil-devel apache2-devel apache2-mod_nss gcc-c++
BuildRequires: libicu-devel libsasl2-devel perl-Mozilla-LDAP perl-CGI
BuildRequires: 389-ds-base mozldap-devel libaprutil1-devel

Requires: apache2-httpd-worker
Requires: apache2-mod_nss
Requires: 389-ds-base

Provides: fedora-ds-adminserver = %version-%release
Obsoletes: fedora-ds-adminserver < %version-%release

Packager: Andrey Cherepanov <cas@altlinux.org>

Source0: %name-%version.tar
Source1: %{pkgname}-admin

%add_perl_lib_path %_libdir/%{pkgname}/perl

%description
Administration Server for 389 Directory Server. Use setup-ds-admin.pl to
setup.

%prep
%setup

%build
export icu_lib=-L%_libdir/
export adminutil_lib=-L%_libdir/
export adminutil_inc=/usr/include/libadminutil/
%add_optflags -I%_includedir/apu-1
%undefine _configure_gettext
%configure --localstatedir=/var \
           --with-modnss-lib=%_libdir/apache2/modules/ \
           --with-httpd=%_sbindir/httpd2.worker \
	   --with-apr-config=/usr/bin/apr-1-config \
	   --with-apxs=%apache2_apxs \
           --with-openldap \
%if_with selinux
           --with-selinux \
%endif
           --with-systemdsystemunitdir=%{_unitdir} \
           --with-systemddirsrvgroupname=%{groupname}

%make

%install
%makeinstall_std

subst 's|%_libdir/httpd|%_libdir/apache2|' %buildroot%_sysconfdir/%{pkgname}/admin-serv/*.conf
subst 's|libmodnss.so|mod_nss.so|' %buildroot%_sysconfdir/%{pkgname}/admin-serv/*.conf
subst 's|%_sysconfdir/mime.types|%_sysconfdir/httpd2/conf/mime.types|' %buildroot%_sysconfdir/%{pkgname}/admin-serv/*.conf
subst 's|LoadModule file_cache_module|#LoadModule file_cache_module|' %buildroot%_sysconfdir/%{pkgname}/admin-serv/*.conf
subst 's|HostnameLookups off|HostnameLookups on|' %buildroot%_sysconfdir/%{pkgname}/admin-serv/httpd.conf
subst 's|LoadModule mpm_worker_module|# LoadModule mpm_worker_module|' \
%buildroot%_sysconfdir/%{pkgname}/admin-serv/httpd.conf
subst 's|LoadModule unixd_module|# LoadModule unixd_module|' \
%buildroot%_sysconfdir/%{pkgname}/admin-serv/httpd.conf

install -pDm755 %SOURCE1 %buildroot%_initdir/%{pkgname}-admin

rm -f %buildroot%_libdir/*.so

%post
%post_service %{pkgname}-admin

%preun
%preun_service %{pkgname}-admin

%files
%doc LICENSE
%dir %_sysconfdir/%pkgname/admin-serv
%config(noreplace)%_sysconfdir/%pkgname/admin-serv/*.conf
%_initdir/%{pkgname}-admin
%_datadir/%pkgname
%config(noreplace)%_sysconfdir/sysconfig/%{pkgname}-admin
%_unitdir/%{pkgname}-admin.service
%_sbindir/*
%_libdir/*.so.*
%_libdir/%pkgname
%_man8dir/*

%changelog
