%define major_version 1.1
%define minor_version 10

%define shortname 389-admin
%define pkgname dirsrv

Name: 389-admin-console
Version: 1.1.12
Release: alt0.M80P.1
Group:   Networking/Other
Url:     http://port389.org
# VCS:	 https://pagure.io/389-admin-console.git
License: GPLv2
Summary: 389 Admin Server Management Console
Packager: Vitaly Kuznetsov <vitty@altlinux.ru>

Source: %name-%version.tar

BuildRequires(Pre): rpm-build-java
BuildRequires: java-devel
BuildRequires: ant
BuildRequires: ldapsdk
BuildRequires: idm-console-framework
BuildRequires: jss

Requires: 389-admin

BuildArch: noarch

%description
A Java based remote management console used for Managing 389
Admin Server.  Requires the 389 Console to load and run the
jar files.

%package doc
Summary: Web docs for 389 Admin Server Management Console
Group: Documentation
Requires: %name = %version-%release

%description doc
Web docs for 389 Admin Server Management Console

%prep
%setup -q

%build
%ant -Dconsole.location=%_datadir/java -Dldapjdk.jar.name=ldapsdk.jar -Dconsole.location=%_javadir -Dbuilt.dir=`pwd`/built

%install
install -d %buildroot%_datadir/%pkgname/html/java
install -m777 built/package/%{shortname}* %buildroot%_datadir/%pkgname/html/java
install -d %buildroot%_datadir/%pkgname/manual/en/admin/help
install -m644 help/en/*.html %buildroot%_datadir/%pkgname/manual/en/admin
install -m644 help/en/tokens.map %buildroot%_datadir/%pkgname/manual/en/admin
install -m644 help/en/help/*.html %buildroot%_datadir/%pkgname/manual/en/admin/help

# create symlinks
pushd %buildroot%_datadir/%pkgname/html/java
ln -s %shortname-%version.jar %shortname-%major_version.jar
ln -s %shortname-%version.jar %shortname.jar
ln -s %shortname-%{version}_en.jar %shortname-%{major_version}_en.jar
ln -s %shortname-%{version}_en.jar %{shortname}_en.jar
ln -s %shortname-%version.jar fedora-admin-1.1.jar
ln -s %shortname-%{version}_en.jar fedora-admin-1.1_en.jar
popd

%files
%doc LICENSE
%_datadir/%pkgname/html/java/%shortname-%version.jar
%_datadir/%pkgname/html/java/%shortname-%major_version.jar
%_datadir/%pkgname/html/java/%shortname.jar
%_datadir/%pkgname/html/java/%shortname-%{version}_en.jar
%_datadir/%pkgname/html/java/%shortname-%{major_version}_en.jar
%_datadir/%pkgname/html/java/%{shortname}_en.jar
%_datadir/%pkgname/html/java/fedora-admin-1.1.jar
%_datadir/%pkgname/html/java/fedora-admin-1.1_en.jar

%files doc
%dir %_datadir/%pkgname/manual/en/admin
%dir %_datadir/%pkgname/manual/en/admin/help
%doc %_datadir/%pkgname/manual/en/admin/tokens.map
%doc %_datadir/%pkgname/manual/en/admin/*.html
%doc %_datadir/%pkgname/manual/en/admin/help/*.html

%changelog
