%define _unpackaged_files_terminate_build 1

%global pkgname	dirsrv
%global groupname %pkgname.target

%def_without selinux

Name: 389-ds-base
Version: 1.3.9.1
Release: alt1.gitb6ba77876

Summary: 389 Directory Server (base)
License: GPLv3+
Group: System/Servers
# Source-git:   https://pagure.io/389-ds-base.git
Url: http://port389.org
Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires: 389-adminutil-devel gcc-c++ libdb4-devel libicu-devel
BuildRequires: libldap-devel libnet-snmp-devel libnl-devel libpam-devel
BuildRequires: libpcre-devel libsasl2-devel libsensors3-devel libsvrcore-devel >= 4.1.2
BuildRequires: libkrb5-devel
BuildRequires: perl-devel
BuildRequires: perl-Mozilla-LDAP perl-libnet perl-bignum
BuildRequires: perl-DBM
BuildRequires: perl-NetAddr-IP
BuildRequires: perl-Archive-Tar
BuildRequires: perl-Socket6
BuildRequires: libsystemd-devel
BuildRequires: libevent-devel
BuildRequires: doxygen
BuildRequires: libgperftools-devel

BuildRequires: python3-module-setuptools
BuildRequires(pre): rpm-build-python3

Provides: fedora-ds = %version-%release
Obsoletes: fedora-ds < %version-%release
Provides: ldif2ldbm
Conflicts: lprng

# AutoReq: yes, noperl
%add_perl_lib_path %_libdir/%pkgname/perl
%add_findprov_skiplist %_datadir/%pkgname/script-templates/*
%add_findreq_skiplist %_datadir/%pkgname/script-templates/* %_sbindir/*-%pkgname
%add_python_req_skip gdb

%description
389 Directory Server is an LDAPv3 compliant server. Use setup-ds.pl to
setup instances.

%package -n 389-ds
Summary: 389 Directory, Administration, and Console Suite
Group: System/Servers
BuildArch: noarch
Requires: 389-ds-base
Requires: 389-admin
Requires: idm-console-framework
Requires: 389-console
Requires: 389-ds-console
Requires: 389-ds-console-doc
Requires: 389-admin-console
Requires: 389-admin-console-doc
Requires: 389-dsgw

%description -n 389-ds
The 389 Directory Server, Administration Server, and Console Suite
provide the LDAPv3 server, the httpd daemon used to administer the
server, and the console GUI application used for server and user/group
administration.

%package devel
Summary: Development libraries for 389 Directory Server
Group: Development/C
Requires: %name = %EVR
Provides: 389-ds-devel = %EVR
Obsoletes: 389-ds-devel < %EVR

%description devel
Development Libraries and heades for 389 Directory Server.

%package libs
Summary: Core libraries for 389 Directory Server
Group: System/Libraries
Provides: 389-ds-libs = %EVR
Obsoletes: 389-ds-libs < %EVR

%description libs
Core libraries for the 389 Directory Server base package.  These
libraries are used by the main package and the -devel package.  This
allows the -devel package to be installed with just the -libs package
and without the main package.

%package -n python3-module-lib389
Summary: A library for accessing, testing, and configuring the 389 Directory Server
BuildArch: noarch
Group: Development/Python3
Requires: krb5-server
Requires: openssl
Requires: iproute

%description -n python3-module-lib389
This module contains tools and libraries for accessing, testing, and
configuring the 389 Directory Server.

BuildArch: noarch


%prep
%setup
%patch -p1
# ALTLinux has bash3 only, thus operation '|&' is not supported
find -name db2index.in -exec sed -i 's/|\&/2>\&1 |/g' {} \;

# ALT specific paths
grep -qsF 'sysctldir = @prefixdir@/lib/sysctl.d' Makefile.am || exit 1
sed -i 's|sysctldir = .*|sysctldir = %_sysctldir|' Makefile.am

grep -qsr '/sasl2\( \|"\)' || exit 1
grep -rl '/sasl2\( \|"\)' | xargs sed -i 's/\/sasl2\( \|"\)/\/sasl2-3\1/g'

grep -qsr '/usr/bin/\(ls\|echo\)' || exit 1
grep -rl '/usr/bin/\(ls\|echo\)' | \
xargs sed -i 's/\/usr\(\/bin\/\(ls\|echo\)\)/\1/g'

grep -qs 'saslpath = "/usr/lib/aarch64-linux-gnu"' \
ldap/servers/slapd/ldaputil.c || exit 1
sed -i 's|\(saslpath = "/usr/\)lib\(/aarch64-linux-gnu"\)|\1lib64\2|g' \
ldap/servers/slapd/ldaputil.c

%build
%autoreconf
# Install SysVInit scripts anyway
subst 's/@\(INITDDIR_TRUE\|SYSTEMD_FALSE\)@//g' Makefile.in

# For strange cleanup before documentation build
mkdir -p man/man3
touch man/man3/_file
%configure  \
	--with-openldap \
        %{subst_with selinux} \
        --enable-tcmalloc \
	--localstatedir=/var \
 	--enable-autobind \
	--with-systemd \
	--with-systemdsystemunitdir=%_unitdir \
	--with-systemdsystemconfdir=%_sysconfdir/systemd/system \
	--with-systemdgroupname=%groupname \
	--with-perldir=%_bindir \
	--with-svrcore-inc=%_includedir \
	--with-svrcore-lib=%_libdir \

%make
pushd ./src/lib389
%python3_build
popd


%install
%makeinstall_std
pushd ./src/lib389
%python3_install
popd

# do not package lib389's tests
rm -rf %buildroot%python3_sitelibdir_noarch/lib389/tests

mkdir -p %buildroot/{%_lockdir,%_localstatedir,%_logdir,%_var/tmp}/%pkgname

# for systemd
mkdir -p %buildroot%_sysconfdir/systemd/system/%groupname.wants

# remove libtool and static libs
rm -f %buildroot%_libdir/%pkgname/{,plugins/}*.{a,la}

# make sure perl scripts have a proper shebang
subst 's|#{{PERL-EXEC}}|#!%_bindir/perl|' %buildroot%_datadir/%pkgname/script-templates/template-*.pl
subst 's|File::Spec->tmpdir|"/tmp"|' %buildroot%_libdir/%pkgname/perl/DSCreate.pm

# move main libraries to common directory
mv %buildroot%_libdir/%pkgname/*.so* %buildroot%_libdir/

# Copy in our docs from doxygen
mkdir -p %buildroot%_man3dir
cp man/man3/* %buildroot%_man3dir

# Fix path to systemctl in scripts
subst 's,%_bindir/systemctl,/bin/systemctl,' %buildroot%_sbindir/*-dirsrv

%files
%doc LICENSE LICENSE.GPLv3+ LICENSE.openssl README
%dir %_sysconfdir/%pkgname
%dir %_sysconfdir/%pkgname/schema
%config(noreplace)%_sysconfdir/%pkgname/schema/*.ldif
%dir %_sysconfdir/%pkgname/config
%dir %_sysconfdir/systemd/system/%groupname.wants
%config(noreplace)%_sysconfdir/%pkgname/config/slapd-collations.conf
%config(noreplace)%_sysconfdir/%pkgname/config/certmap.conf
%config(noreplace)%_sysconfdir/%pkgname/config/ldap-agent.conf
%config(noreplace)%_sysconfdir/%pkgname/config/template-initconfig
%config(noreplace)%_sysconfdir/sysconfig/%pkgname
%config(noreplace)%_sysconfdir/sysconfig/%pkgname.systemd
%_datadir/%pkgname
%_unitdir/dirsrv-snmp.service
%_unitdir/dirsrv.target
%_unitdir/dirsrv@.service
%_bindir/*
%_sbindir/*
%exclude %_sbindir/dsconf
%exclude %_sbindir/dscreate
%exclude %_sbindir/dsctl
%exclude %_sbindir/dsidm
%_libdir/%pkgname/perl
%_libdir/%pkgname/python
%_libdir/%pkgname/plugins/*.so
%_datadir/gdb/auto-load/*
%_sysctldir/70-dirsrv.conf
%dir %_libdir/%pkgname/plugins
%dir %_localstatedir/%pkgname
%dir %_logdir/%pkgname
%ghost %dir %_lockdir/%pkgname
%_initdir/*
%_man1dir/*
%_man8dir/*

%files -n 389-ds
%files devel
%_includedir/%pkgname
%_libdir/*.so
%exclude %_libdir/libns-dshttpd-*.so
%_pkgconfigdir/*.pc
%_man3dir/*

%files libs
%dir %_libdir/%pkgname
%_libdir/libns-dshttpd-*.so
%_libdir/libnunc-stans.so.*
%_libdir/libsds.so.*
%_libdir/libslapd.so.*
%_libdir/libldaputil.so.*

%files -n python3-module-lib389
%_sbindir/dsconf
%_sbindir/dscreate
%_sbindir/dsctl
%_sbindir/dsidm
%python3_sitelibdir_noarch/lib389/
%python3_sitelibdir_noarch/lib389-*.egg-info


%pre
%define _dirsrv_user dirsrv
%define _dirsrv_group dirsrv
%define _dirsrv_home %_localstatedir/dirsrv
/usr/sbin/groupadd -r -f %_dirsrv_group ||:
/usr/sbin/useradd -g %_dirsrv_group -c 'user for 389-ds-base' \
		  -d %_dirsrv_home -s /sbin/nologin -r %_dirsrv_user \
		  > /dev/null 2>&1 ||:

%post
# Upgrade
if [ $1 -gt 1 ]; then
    echo "Checking for upgrade"
    if ! ( sd_booted && /bin/systemctl --version >/dev/null 2>&1 ); then
        echo "Likely, you are not using systemd. Please, stop all the dirsrv instances."
        echo "Then run an upgrade by %_sbindir/setup-ds.pl -u -s General.UpdateMode=offline"
        exit 0
    fi

    /bin/systemctl daemon-reload >/dev/null 2>&1 ||:
    instances=""
    num_inst=0
    echo "Looking for Instances in %_sysconfdir/%pkgname"
    for dir in %_sysconfdir/%pkgname/slapd-* ; do
        if [ ! -d "$dir" ] ; then continue ; fi
        case "$dir" in *.removed) continue ;; esac
        inst="%pkgname@$(echo $(basename $dir) | sed -e 's/slapd-//')"
        echo "Found Instance $inst"
        if /bin/systemctl -q is-active "$inst"; then
            echo "Instance $inst is running, stopping it"
            if ! /bin/systemctl stop "$inst"; then
                echo "Cannot stop Instance. Please check it and run an upgrade by %_sbindir/setup-ds.pl -u -s General.UpdateMode=offline"
                exit 0
            fi
            instances="$instances $inst"
        else
            echo "Instance $inst is not running"
        fi
        let "num_inst++"
    done
    if [ "$num_inst" -eq 0 ]; then
        echo "There are no Instances to upgrade"
        exit 0
    fi
    echo "Upgrading Instances"
    if ! %_sbindir/setup-ds.pl -u -d -l %_logdir/%pkgname/upgrade.log -s \
    General.UpdateMode=offline >/dev/null 2>&1; then
        echo "Upgrade has not been completed successfully. Please check log file %_logdir/%pkgname/upgrade.log and run an upgrade by %_sbindir/setup-ds.pl -u -s General.UpdateMode=offline"
        exit 0
    fi

    for inst in $instances; do
        echo "Restarting Instance $inst"
        /bin/systemctl start "$inst" ||:
    done

    echo "Upgrade has been completed successfully"
fi
%post_service %pkgname-snmp

%preun
# Removal
if [ $1 -eq 0 ]; then
    # disabling all templated units
    /bin/systemctl -q disable %pkgname@
    # remove templated units
    rm -rf %_sysconfdir/systemd/system/%groupname.wants/* >/dev/null 2>&1 ||:
    # stopping by mask
    /bin/systemctl stop %pkgname@*.service
fi
%preun_service %pkgname-snmp

%changelog
