%define major_version 1.2
%define minor_version 16

%define shortname 389-ds
%define pkgname   dirsrv

Name: 389-ds-console
Version: %major_version.%minor_version
Release: alt0.M80P.1
Group: Networking/Other
Url: http://port389.org
License: GPLv2
Summary: 389 Directory Server Management Console
BuildArch: noarch
Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar

BuildRequires(Pre): rpm-build-java
BuildRequires: java-devel
BuildRequires: ant
BuildRequires: ldapsdk
BuildRequires: idm-console-framework
BuildRequires: jss

Provides: fedora-ds-directoryconsole = %version-%release
Obsoletes: fedora-ds-directoryconsole < %version-%release

%description
A Java based remote management console used for managing 389
Directory Server.  The 389 Console is required to load and
run these jar files.

%package          doc
Summary:          Web docs for 389 Directory Server Management Console
Group:            Documentation
Requires:         %name = %version-%release

%description      doc
Web docs for 389 Directory Server Management Console

%prep
%setup -q

%build
%ant -Dconsole.location=%_datadir/java -Dldapjdk.jar.name=ldapsdk.jar -Dconsole.location=%_javadir -Dbuilt.dir=`pwd`/built

%install
install -d %buildroot%_datadir/%pkgname/html/java/
install -m777 built/package/%{shortname}* %buildroot%_datadir/%pkgname/html/java
install -d %buildroot%_datadir/%pkgname/manual/en/slapd/help
install -m644 help/en/*.html %buildroot%_datadir/%pkgname/manual/en/slapd
install -m644 help/en/tokens.map %buildroot%_datadir/%pkgname/manual/en/slapd
install -m644 help/en/help/*.html %buildroot%_datadir/%pkgname/manual/en/slapd/help

# create symlinks
pushd %buildroot%_datadir/%pkgname/html/java
ln -s %shortname-%version.jar %shortname-%major_version.jar
ln -s %shortname-%version.jar %shortname.jar
ln -s %shortname-%{version}_en.jar %shortname-%{major_version}_en.jar
ln -s %shortname-%{version}_en.jar %{shortname}_en.jar
popd

%files
%_datadir/%pkgname/html/java/%shortname-%version.jar
%_datadir/%pkgname/html/java/%shortname-%major_version.jar
%_datadir/%pkgname/html/java/%shortname.jar
%_datadir/%pkgname/html/java/%shortname-%{version}_en.jar
%_datadir/%pkgname/html/java/%shortname-%{major_version}_en.jar
%_datadir/%pkgname/html/java/%{shortname}_en.jar

%files doc
%dir %_datadir/%pkgname/manual/en/slapd
%dir %_datadir/%pkgname/manual/en/slapd/help
%doc %_datadir/%pkgname/manual/en/slapd/tokens.map
%doc %_datadir/%pkgname/manual/en/slapd/*.html
%doc %_datadir/%pkgname/manual/en/slapd/help/*.html

%changelog
