%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl

%define oname Bcps
Name: Coin%oname
Version: 0.93.5
Release: alt1.svn20131121
Summary: Make up the CHiPPS (COIN High Performance Parallel Search Framework) library hierarchy
License: CPL v1.0
Group: Sciences/Mathematics
Url: https://projects.coin-or.org/CHiPPS
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://projects.coin-or.org/svn/CHiPPS/Bcps/trunk
Source: %oname-%version.tar.gz

BuildPreReq: doxygen graphviz libglpk-devel CoinBuildTools gcc-c++
BuildPreReq: libCoinUtils-devel libCoinClp-devel libCoinOsi-devel
BuildPreReq: libCoinCgl-devel libCoinAlps-devel %mpiimpl-devel

%description
BiCePS is one of the libraries that make up the CHiPPS (COIN High
Performance Parallel Search Framework) library hierarchy. It implements
that data-handling functions needed to support development of many types
of relaxation-based branch-and-bound algorithms, especially for solving
mathematical programs. It is intended to capture the implementation of
methods common to all such algorithms without assuming anything about
the structure of the mathematical program or the bounding method used.

%package -n lib%name
Summary: Shared libraries of COIN-OR BiCePS
Group: System/Libraries

%description -n lib%name
BiCePS is one of the libraries that make up the CHiPPS (COIN High
Performance Parallel Search Framework) library hierarchy. It implements
that data-handling functions needed to support development of many types
of relaxation-based branch-and-bound algorithms, especially for solving
mathematical programs. It is intended to capture the implementation of
methods common to all such algorithms without assuming anything about
the structure of the mathematical program or the bounding method used.

This package contains shared libraries of COIN-OR BiCePS.

%package -n lib%name-devel
Summary: Development files of COIN-OR BiCePS
Group: Development/C++
Requires: lib%name = %version-%release

%description -n lib%name-devel
BiCePS is one of the libraries that make up the CHiPPS (COIN High
Performance Parallel Search Framework) library hierarchy. It implements
that data-handling functions needed to support development of many types
of relaxation-based branch-and-bound algorithms, especially for solving
mathematical programs. It is intended to capture the implementation of
methods common to all such algorithms without assuming anything about
the structure of the mathematical program or the bounding method used.

This package contains development files of COIN-OR BiCePS.

%package -n lib%name-devel-doc
Summary: Documentation for COIN-OR BiCePS
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
BiCePS is one of the libraries that make up the CHiPPS (COIN High
Performance Parallel Search Framework) library hierarchy. It implements
that data-handling functions needed to support development of many types
of relaxation-based branch-and-bound algorithms, especially for solving
mathematical programs. It is intended to capture the implementation of
methods common to all such algorithms without assuming anything about
the structure of the mathematical program or the bounding method used.

This package contains development documentation for COIN-OR BiCePS.

%package examples
Summary: Examples for COIN-OR BiCePS
Group: Development/Documentation
BuildArch: noarch

%description examples
BiCePS is one of the libraries that make up the CHiPPS (COIN High
Performance Parallel Search Framework) library hierarchy. It implements
that data-handling functions needed to support development of many types
of relaxation-based branch-and-bound algorithms, especially for solving
mathematical programs. It is intended to capture the implementation of
methods common to all such algorithms without assuming anything about
the structure of the mathematical program or the bounding method used.

This package contains examples for COIN-OR BiCePS.

%prep
%setup

%build
mpi-selector --set %mpiimpl
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

%autoreconf
%configure \
	--with-mpi-incdir=%mpidir/include \
	--with-mpi-lib="-L%mpidir/lib -lmpi" \
	--with-alps-lib=-lAlps \
	--with-alps-incdir=%_includedir/coin
%make_build

doxygen doxydoc/doxygen.conf

%install
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

%makeinstall_std

rm -fR %buildroot%_docdir/coin

%files -n lib%name
%doc %oname/AUTHORS %oname/LICENSE %oname/README
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%doc doxydoc/html/*

%files examples
%doc %oname/examples/*

%changelog
