%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl

%define oname Cbc
Name: Coin%oname
Version: 2.8.9
Release: alt1.svn20140513.0.M80P.1
Summary: COIN-OR Branch-and-Cut MIP Solver
License: CPL v1.0
Group: Sciences/Mathematics
Url: http://www.coin-or.org/projects/Cbc.xml
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://projects.coin-or.org/svn/Cbc/trunk
Source: %oname-%version.tar.gz

BuildPreReq: doxygen graphviz libglpk-devel CoinBuildTools gcc4.9-c++
BuildPreReq: libCoinUtils-devel liblapack-devel
BuildPreReq: libCoinCgl-devel libCoinClp-devel libCoinOsi-devel
BuildPreReq: libCoinVol-devel libCoinDyLP-devel %mpiimpl-devel
BuildPreReq: CoinMiplib3-devel chrpath libnuma-devel

Requires: lib%name = %version-%release

%description
CBC is an open-source MILP solver. It uses many of the COIN components
and is designed to be used with CLP or dylp. It is available as a
library and as a standalone solver.

%package -n lib%name
Summary: Shared libraries of COIN-OR Branch-and-Cut MIP Solver
Group: System/Libraries
Requires: CoinMiplib3-data

%description -n lib%name
CBC is an open-source MILP solver. It uses many of the COIN components
and is designed to be used with CLP or dylp. It is available as a
library and as a standalone solver.

This package contains shared libraries of COIN-OR Branch-and-Cut MIP
Solver.

%package -n lib%name-devel
Summary: Development files of COIN-OR Branch-and-Cut MIP Solver
Group: Development/C++
Requires: lib%name = %version-%release
Requires: CoinMiplib3-devel

%description -n lib%name-devel
CBC is an open-source MILP solver. It uses many of the COIN components
and is designed to be used with CLP or dylp. It is available as a
library and as a standalone solver.

This package contains development files of COIN-OR Branch-and-Cut MIP
Solver.

%package -n lib%name-devel-doc
Summary: Documentation for COIN-OR Branch-and-Cut MIP Solver
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
CBC is an open-source MILP solver. It uses many of the COIN components
and is designed to be used with CLP or dylp. It is available as a
library and as a standalone solver.

This package contains development documentation for COIN-OR
Branch-and-Cut MIP Solver.

%package examples
Summary: Examples for COIN-OR Branch-and-Cut MIP Solver
Group: Sciences/Mathematics
#Requires: lib%name = %version-%release
BuildArch: noarch

%description examples
CBC is an open-source MILP solver. It uses many of the COIN components
and is designed to be used with CLP or dylp. It is available as a
library and as a standalone solver.

This package contains examples for COIN-OR Branch-and-Cut MIP Solver.

%prep
%setup

%build
%set_gcc_version 4.9
mpi-selector --set %mpiimpl
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

%autoreconf
%configure \
	--with-coin-instdir=%prefix \
	--with-blas-lib=-lopenblas \
	--with-lapack-lib=-llapack \
	--with-glpk-incdir=%_includedir \
	--with-dot
TOPDIR=$PWD
%make_build TOPDIR=$TOPDIR
rm -f $(find %oname -name 'libOsiCbc.*') \
	$(find %oname -name 'libCbcSolver.*')
%make_build TOPDIR=$TOPDIR ADDLIB=-lCbc

#make_build -C %oname/examples TOPDIR=$TOPDIR

pushd %oname/doxydoc
doxygen doxygen.conf
popd

%install
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

%makeinstall_std TOPDIR=$PWD

#install -m755 %oname/examples/driver %buildroot%_bindir/%oname-driver

#for i in cbc %oname-driver; do
#	chrpath -r %mpidir/lib %buildroot%_bindir/$i
#done
for i in %buildroot%_libdir/*.so %buildroot%_bindir/cbc
do
	chrpath -r %mpidir/lib $i
done

rm -fR %buildroot%_docdir/coin \
	%buildroot%_datadir/coin/doc

%files
%doc %oname/AUTHORS %oname/LICENSE %oname/README
%_bindir/cbc

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*

%files examples
%doc %oname/examples/*.c* %oname/examples/*.hpp %oname/examples/*.mps
%doc %oname/examples/*.csv %oname/examples/Makefile
#_bindir/%oname-driver

%changelog
