%define oname Csdp
Name: Coin%oname
Version: 6.1.1
Release: alt2.svn20110208
Summary: A C Library for Semidefinite Programming
License: CPL v1.0
Group: Sciences/Mathematics
Url: https://projects.coin-or.org/Csdp
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://projects.coin-or.org/svn/Csdp/trunk
Source: %oname-%version.tar.gz

BuildPreReq: gcc-fortran libgomp-devel
BuildPreReq: liblapack-devel

Requires: lib%name = %version-%release

%description
CSDP is a library of routines that implements a predictor corrector
variant of the semidefinite programming algorithm of Helmberg, Rendl,
Vanderbei, and Wolkowicz. The main advantages of this code are that it
is written to be used as a callable subroutine, it is written in C for
efficiency, the code runs in parallel on shared memory multi-processor
systems, and it makes effective use of sparsity in the constraint
matrices.

%package -n lib%name
Summary: Shared libraries of COIN-OR CSDP
Group: System/Libraries
Conflicts: libmpeg4ip

%description -n lib%name
CSDP is a library of routines that implements a predictor corrector
variant of the semidefinite programming algorithm of Helmberg, Rendl,
Vanderbei, and Wolkowicz. The main advantages of this code are that it
is written to be used as a callable subroutine, it is written in C for
efficiency, the code runs in parallel on shared memory multi-processor
systems, and it makes effective use of sparsity in the constraint
matrices.

This package contains shared libraries of COIN-OR CSDP.

%package -n lib%name-devel
Summary: Development files of COIN-OR CSDP
Group: Development/C
Requires: lib%name = %version-%release
Conflicts: libsdp-devel
Conflicts: libmpeg4ip-devel

%description -n lib%name-devel
CSDP is a library of routines that implements a predictor corrector
variant of the semidefinite programming algorithm of Helmberg, Rendl,
Vanderbei, and Wolkowicz. The main advantages of this code are that it
is written to be used as a callable subroutine, it is written in C for
efficiency, the code runs in parallel on shared memory multi-processor
systems, and it makes effective use of sparsity in the constraint
matrices.

This package contains development files of COIN-OR CSDP.

%package example
Summary: Example for COIN-OR CSDP
Group: Sciences/Mathematics
Requires: lib%name = %version-%release

%description example
CSDP is a library of routines that implements a predictor corrector
variant of the semidefinite programming algorithm of Helmberg, Rendl,
Vanderbei, and Wolkowicz. The main advantages of this code are that it
is written to be used as a callable subroutine, it is written in C for
efficiency, the code runs in parallel on shared memory multi-processor
systems, and it makes effective use of sparsity in the constraint
matrices.

This package contains example for COIN-OR CSDP.

%package docs
Summary: Documentation for COIN-OR CSDP
Group: Documentation
BuildArch: noarch

%description docs
CSDP is a library of routines that implements a predictor corrector
variant of the semidefinite programming algorithm of Helmberg, Rendl,
Vanderbei, and Wolkowicz. The main advantages of this code are that it
is written to be used as a callable subroutine, it is written in C for
efficiency, the code runs in parallel on shared memory multi-processor
systems, and it makes effective use of sparsity in the constraint
matrices.

This package contains documentation for COIN-OR CSDP.

%prep
%setup

%ifarch x86_64
ADDFLAG=-DBIT64
%endif
ADDFLAG="$ADDFLAG -I%_includedir/openblas"
sed -i "s|@ADDFLAG@|$ADDFLAG|" */Makefile

%build
%make_build

export LD_LIBRARY_PATH=$PWD/lib
#make_build unitTest

%install
%makeinstall_std LIBDIR=%_libdir

mv %buildroot%_bindir/theta %buildroot%_bindir/theta.%oname

%files
%doc AUTHORS LICENSE README
%_bindir/*
%exclude %_bindir/csdp-example

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*

%files docs
%doc doc/*.pdf

%files example
%doc example/*.c example/Makefile
%_bindir/csdp-example

%changelog
