%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl

%define oname DyLP
Name: Coin%oname
Version: 1.9.4
Release: alt1.svn20131231
Summary: COIN-OR dynamic simplex algorithm
License: CPL v1.0
Group: Sciences/Mathematics
Url: http://www.coin-or.org/projects/DyLP.xml
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://projects.coin-or.org/svn/DyLP/trunk
Source: %oname-%version.tar.gz

BuildPreReq: doxygen graphviz libglpk-devel CoinBuildTools gcc-c++
BuildPreReq: libCoinOsi-devel %mpiimpl-devel chrpath

%description
DyLP is an open-source implementation of the dynamic simplex algorithm
for linear programming. DyLP is pure C, heavily instrumented and
commented, targetted toward algorithm development. An OSI interface,
OsiDylp, is also available.

%package -n lib%name
Summary: Shared libraries of COIN-OR dynamic simplex algorithm
Group: System/Libraries

%description -n lib%name
DyLP is an open-source implementation of the dynamic simplex algorithm
for linear programming. DyLP is pure C, heavily instrumented and
commented, targetted toward algorithm development. An OSI interface,
OsiDylp, is also available.

This package contains shared libraries of DyLP.

%package -n lib%name-devel
Summary: Development files of COIN-OR dynamic simplex algorithm
Group: Development/C++
Requires: lib%name = %version-%release

%description -n lib%name-devel
DyLP is an open-source implementation of the dynamic simplex algorithm
for linear programming. DyLP is pure C, heavily instrumented and
commented, targetted toward algorithm development. An OSI interface,
OsiDylp, is also available.

This package contains development files of DyLP.

%package -n lib%name-devel-doc
Summary: Documentation for COIN-OR dynamic simplex algorithm
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
DyLP is an open-source implementation of the dynamic simplex algorithm
for linear programming. DyLP is pure C, heavily instrumented and
commented, targetted toward algorithm development. An OSI interface,
OsiDylp, is also available.

This package contains development documentation for DyLP.

%package examples
Summary: Examples for COIN-OR dynamic simplex algorithm
Group: Sciences/Mathematics
#Requires: lib%name = %version-%release
BuildArch: noarch

%description examples
DyLP is an open-source implementation of the dynamic simplex algorithm
for linear programming. DyLP is pure C, heavily instrumented and
commented, targetted toward algorithm development. An OSI interface,
OsiDylp, is also available.

This package contains examples for DyLP.

%prep
%setup

%build
mpi-selector --set %mpiimpl
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

SAMPLE=$(pkg-config coindatasample --variable=datadir)
%autoreconf
%configure \
	--enable-debug \
	--with-coin-instdir=%prefix \
	--with-dot \
	--with-sample-datadir=$SAMPLE
sed -i 's|\(wl\=\).*|\1"-Wl,"|g' libtool
TOPDIR=$PWD
%make_build TOPDIR=$TOPDIR MPIDIR=%mpidir
#make_build -C %oname/examples TOPDIR=$TOPDIR

pushd %oname/doxydoc
doxygen doxygen.conf
popd

%install
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

%makeinstall_std TOPDIR=$PWD MPIDIR=%mpidir

#install -d %buildroot%_bindir
#install -m755 %oname/examples/*dylp %buildroot%_bindir
#install -m755 %oname/examples/plain %buildroot%_bindir/%oname-plain

#for i in %buildroot%_libdir/*.so %buildroot%_bindir/*dylp
for i in %buildroot%_libdir/*.so
do
	chrpath -r %mpidir/lib $i
done

rm -fR %buildroot%_datadir/coin/doc

%files -n lib%name
%doc %oname/AUTHORS %oname/LICENSE %oname/NEWS %oname/README
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%doc %oname/doxydoc/doxydoc/html/*

%files examples
%doc %oname/examples/*.spc %oname/examples/*.c*
%doc %oname/examples/README %oname/examples/Makefile
%doc %oname/src/Dylp/dy_errmsgs.txt
#_bindir/*

%changelog
