%def_without dbus

Name: FlightGear
Version: 2016.1.1
Release: alt1

Summary: open-source flight simulator
License: GPL
Group: Games/Arcade

Url: http://www.flightgear.org
Source0: %name-%version.tar.gz
Source2: FlightGear.menu
Source3: FlightGear-22x22.xpm
Source4: FlightGear-32x32.xpm
Source5: FlightGear-48x48.xpm
Source10: fg-16.png
Source11: fg-32.png
Source12: fg-48.png
Source13: fg-64.png
Source14: fg-128.png
Source15: FlightGear.desktop
Patch1: 0001-check-to-be-sure-that-n-is-not-being-set-as-format-t.patch
Patch2: 0002-make-ShivaVG-and-FGAdminUI-static-libraries.patch
Patch5: 0005-explicitely-link-with-libX11.patch
Patch6: 0006-make-fglauncher-a-static-library.patch

Requires: fgfs-data = %version
#Requires: fgrun >= 1.6.1

# Automatically added by buildreq on Sat Mar 03 2012
# optimized out: alternatives cmake-modules cpio ed elfutils fontconfig glibc-devel-static kde4libs libGL-devel libGLU-devel libICE-devel libOpenSceneGraph-devel libOpenThreads-devel libSM-devel libX11-devel libXau-devel libXext-devel libXt-devel libapr1-devel libaprutil1-devel libdb4-devel libdrm-devel libgdk-pixbuf libgpg-error libldap-devel libneon-devel libopenal-devel libqt4-declarative libqt4-qt3support libqt4-xmlpatterns libstdc++-devel pkg-config plib python-base shared-mime-info strace sysvinit-utils termutils time vim-common vim-minimal xorg-kbproto-devel xorg-xproto-devel xxd xz zlib-devel
BuildRequires: boost-devel-headers cmake fakeroot gcc-c++ imake libXi-devel libXmu-devel libalut-devel libfltk-devel libfreeglut-devel libjpeg-devel libpng-devel libsimgear-devel-static libsubversion-devel libudev-devel plib-devel rpm-utils sisyphus_check vim-console vitmp

BuildRequires: cmake libpng-devel libfltk-devel libudev-devel
BuildPreReq: libOpenSceneGraph-devel boost-devel libXres-devel
BuildPreReq: libXtst-devel libXcomposite-devel libXcursor-devel
BuildPreReq: libXdamage-devel libXdmcp-devel libXfixes-devel
BuildPreReq: libXft-devel libXinerama-devel libxkbfile-devel
BuildPreReq: libXpm-devel libXrandr-devel libXrender-devel
BuildPreReq: libXScrnSaver-devel libXv-devel libXxf86misc-devel
BuildPreReq: libXxf86vm-devel libXxf86vm-devel libapr1-devel

%if_with dbus
# disables screensaver; requires running messagebus service
BuildRequires: libdbus-devel
Requires: dbus
%endif

%description
FlightGear is a free, open-source, multi-platform, and sophisticated
flight simulator framework for the development and pursuit
of interesting flight simulator ideas.

This package contains the engine; see also fgrun or fgo to start
FlightGear conveniently.

You will also need some experience and probably a tutorial:
http://www.4p8.com/eric.brasseur/flight_simulator_tutorial.html

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch5 -p1
%patch6 -p1

sed -i 's/\r//' docs-mini/AptNavFAQ.FlightGear.html
for ext in Cygwin IRIX Joystick Linux MSVC MSVC8 MacOS SimGear Unix \
	Win32-X autoconf mingw plib src xmlsyntax; do
	rm -f docs-mini/README.$ext
done
for f in docs-mini/README.xmlparticles Thanks; do
	iconv -f iso-8859-1 -t utf-8 -o ${f}.utf8 ${f}
	mv -f ${f}.utf8 ${f}
done

# argh
sed -i 's,/lib/FlightGear,/share/flightgear,' CMakeLists.txt

# a glitch in 2.10.0:
# http://www.mail-archive.com/flightgear-devel@lists.sourceforge.net/msg39430.html
rm -f src/Include/version.h

%build
%cmake
%make_build -C BUILD VERBOSE=1

%install
%makeinstall_std -C BUILD

install -pDm644 %SOURCE3 %buildroot%_miconsdir/%name.xpm
install -pDm644 %SOURCE4 %buildroot%_niconsdir/%name.xpm
install -pDm644 %SOURCE5 %buildroot%_liconsdir/%name.xpm

install -pDm644 %SOURCE10 %buildroot%_iconsdir/hicolor/16x16/apps/%name.png
install -pDm644 %SOURCE11 %buildroot%_iconsdir/hicolor/32x32/apps/%name.png
install -pDm644 %SOURCE12 %buildroot%_iconsdir/hicolor/48x48/apps/%name.png
install -pDm644 %SOURCE13 %buildroot%_iconsdir/hicolor/64x64/apps/%name.png
install -pDm644 %SOURCE14 %buildroot%_iconsdir/hicolor/128x128/apps/%name.png

install -pDm644 %SOURCE15 %buildroot%_desktopdir/%name.desktop

rm -rf %buildroot%_datadir/locale

%files
%_bindir/*
%_mandir/*/*
%_iconsdir/*/*/*/%name.png
%_niconsdir/%name.xpm
%_liconsdir/%name.xpm
%_miconsdir/%name.xpm
%_desktopdir/%name.desktop

%changelog
