%define soversion 2.0
%def_disable static

Name: GLEW
Version: 2.0.0
Release: alt1

Summary: The OpenGL Extension Wrangler library
License: BSD, MIT
Group: System/Libraries

Url: http://glew.sourceforge.net/
Packager: Nazarov Denis <nenderus@altlinux.org>

# https://sourceforge.net/projects/glew/files/glew/%version/glew-%version.tgz/download
Source: glew-%version.tgz

BuildRequires: gcc-c++
BuildRequires: libGLU-devel

%description
The OpenGL Extension Wrangler Library (GLEW) is a cross-platform open-source C/C++
extension loading library. GLEW provides efficient run-time mechanisms for determining 
which OpenGL extensions are supported on the target platform. OpenGL core and extension
functionality is exposed in a single header file. GLEW has been tested on a variety of 
operating systems, including Windows, Linux, Mac OS X, FreeBSD, Irix, and Solaris.

%package -n lib%name%soversion
Summary: The OpenGL Extension Wrangler library
Group: System/Libraries
Provides: libGLEW = %version-%release

%description -n lib%name%soversion
The OpenGL Extension Wrangler Library (GLEW) is a cross-platform open-source C/C++
extension loading library. GLEW provides efficient run-time mechanisms for determining 
which OpenGL extensions are supported on the target platform. OpenGL core and extension
functionality is exposed in a single header file. GLEW has been tested on a variety of 
operating systems, including Windows, Linux, Mac OS X, FreeBSD, Irix, and Solaris.

%package -n lib%name-devel
Summary: The OpenGL Extension Wrangler library development files
Group: Development/C
Provides: libglew-devel = %version-%release
Obsoletes: libglew-devel < %version-%release
Provides: lib%{name}mx-devel = %EVR
Obsoletes: lib%{name}mx-devel < %EVR

%description -n lib%name-devel
The OpenGL Extension Wrangler Library (GLEW) is a cross-platform open-source C/C++
extension loading library. GLEW provides efficient run-time mechanisms for determining 
which OpenGL extensions are supported on the target platform. OpenGL core and extension
functionality is exposed in a single header file. GLEW has been tested on a variety of 
operating systems, including Windows, Linux, Mac OS X, FreeBSD, Irix, and Solaris.

The package contains the C headers to compile programs based on %name.

%if_enabled static
%package -n lib%name-devel-static
Summary: The OpenGL Extension Wrangler library development files
Group: Development/C

%description -n lib%name-devel-static
The OpenGL Extension Wrangler Library (GLEW) is a cross-platform open-source C/C++
extension loading library. GLEW provides efficient run-time mechanisms for determining 
which OpenGL extensions are supported on the target platform. OpenGL core and extension
functionality is exposed in a single header file. GLEW has been tested on a variety of 
operating systems, including Windows, Linux, Mac OS X, FreeBSD, Irix, and Solaris.
%endif

%prep
%setup -n glew-%version

%build
%make_build

%install
%makeinstall_std BINDIR=%_bindir LIBLIR=%_libdir INCDIR=%_includedir/GL PKGDIR=%_pkgconfigdir

%files -n lib%name%soversion
%doc doc/*
%_libdir/lib%name.so.%soversion
%_libdir/lib%name.so.%soversion.*

%files -n lib%name-devel
%_includedir/GL/*.h
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib%name.a
%endif

%changelog
