%define soversion 1.13
%define libglew libGLEW%soversion
%define glew_devel libGLEW-devel
%define libglewmx libGLEWmx%soversion
%define glewmx_devel libGLEWmx-devel

Name: GLEW1.13
Version: 1.13.0
Release: alt4

Summary: The OpenGL Extension Wrangler library
License: BSD, MIT
Group: System/Legacy libraries

Url: http://glew.sourceforge.net/
Packager: Nazarov Denis <nenderus@altlinux.org>
Source: glew-%version.tgz

BuildRequires: gcc-c++
BuildRequires: libGLU-devel

%description
The OpenGL Extension Wrangler Library (GLEW) is a cross-platform open-source C/C++
extension loading library. GLEW provides efficient run-time mechanisms for determining 
which OpenGL extensions are supported on the target platform. OpenGL core and extension
functionality is exposed in a single header file. GLEW has been tested on a variety of 
operating systems, including Windows, Linux, Mac OS X, FreeBSD, Irix, and Solaris.

%package -n %libglew
Summary: The OpenGL Extension Wrangler library
Group: System/Legacy libraries
Provides: libGLEW = %version-%release

%description -n %libglew
The OpenGL Extension Wrangler Library (GLEW) is a cross-platform open-source C/C++
extension loading library. GLEW provides efficient run-time mechanisms for determining 
which OpenGL extensions are supported on the target platform. OpenGL core and extension
functionality is exposed in a single header file. GLEW has been tested on a variety of 
operating systems, including Windows, Linux, Mac OS X, FreeBSD, Irix, and Solaris.

%package -n %libglewmx
Summary: The OpenGL Extension Wrangler MX library
Group: System/Legacy libraries
Provides: libGLEWmx = %version-%release
Provides: libGLEW%{soversion}mx = %EVR
Obsoletes: libGLEW%{soversion}mx < %EVR

%description -n %libglewmx
The OpenGL Extension Wrangler Library (GLEW) is a cross-platform open-source C/C++
extension loading library. GLEW provides efficient run-time mechanisms for determining 
which OpenGL extensions are supported on the target platform. OpenGL core and extension
functionality is exposed in a single header file. GLEW has been tested on a variety of 
operating systems, including Windows, Linux, Mac OS X, FreeBSD, Irix, and Solaris.

This package contains libGLEW variant with multiple rendering contexts.

%prep
%setup -n glew-%version

%build
%make_build

%install
mkdir -p %buildroot%_libdir

install -Dp -m0644 lib/libGLEW.so.%version %buildroot%_libdir
install -Dp -m0644 lib/libGLEWmx.so.%version %buildroot%_libdir

%files -n %libglew
%_libdir/libGLEW.so.%soversion
%_libdir/libGLEW.so.%soversion.*

%files -n %libglewmx
%_libdir/libGLEWmx.so.%soversion
%_libdir/libGLEWmx.so.%soversion.*

%changelog
