%define mversion	6
%define dversion	%mversion.9.4
%define drelease	7
%define qlev		Q16
%define mgkdir		ImageMagick
%define soname		4

%def_enable librsvg
%def_enable x

Name: ImageMagick
Version: %dversion.%drelease
Release: alt2.M80P.1

Summary: An X application for displaying and manipulating images
License: OpenSource
Group: Graphics
Url: http://www.imagemagick.org/

Packager: Anton Farygin <rider@altlinux.ru>

Source0: ftp://ftp.imagemagick.org/pub/ImageMagick/%name-%dversion-%drelease.tar.xz

Source1: %name.desktop
Source2: imagemagick16.png
Source3: imagemagick32.png
Source4: imagemagick48.png
Source5: %name.watch
Patch1: ImageMagick-depends.patch

Requires: ghostscript-classic fonts-type1-urw lib%name = %version-%release

BuildPreReq: libpng-devel

# found by buildreq; this might breaq when building against updated libraries
#BuildRequires: ImageMagick-tools

# Automatically added by buildreq on Wed Nov 03 2010
BuildRequires: bzlib-devel curl gcc-c++ glibc-devel-static graphviz groff-base imake libXext-devel libXt-devel libdjvu-devel libjasper-devel libjbig-devel liblcms-devel liblqr-devel librsvg-devel libtiff-devel libwmf-devel libxml2-devel openexr-devel perl-devel transfig xdg-utils xorg-cf-files 

BuildRequires: libjpeg-devel liblcms2-devel liblzma-devel libwebp-devel libgraphviz-devel libjasper-devel libjbig-devel liblcms-devel libtiff-devel libwmf-devel libxml2-devel perl-devel chrpath openexr-devel liblqr-devel libdjvu-devel libltdl-devel perl-parent libopenjpeg2.0-devel
%if_enabled librsvg
BuildRequires: librsvg-devel libpixman-devel
%endif

Requires: %name-tools %name-doc

%description
%name is a powerful image display, conversion and manipulation tool.
It runs in an X session.  With this tool, you can view, edit and display
a variety of image formats.

This package installs the necessary files to run %name.

%package -n lib%name
Summary: %name shared libraries
Group: System/Libraries
Provides: %name-lib = %version
Obsoletes: %name-lib < %version

%description -n lib%name
%name is a powerful image display, conversion and manipulation libraries.

%package -n lib%name-devel
Summary: Header files for %name app development
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel < %version

%description -n lib%name-devel
If you want to create applications that will use %name code or APIs,
you'll need to install these packages as well as %name.  These additional
packages aren't necessary if you simply want to use %name, however.

%package -n lib%name-devel-static
Summary: Static libraries for %name app development
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
If you want to create applications that will use %name code or APIs,
you'll need to install these packages as well as %name.  These additional
packages aren't necessary if you simply want to use %name, however.

lib%name-devel is an addition to %name which includes static libraries files
necessary to develop applications.

%package -n perl-Magick
Summary: Libraries and modules for access to %name from perl
Group: Development/Perl
Requires: lib%name = %version-%release
# perl.prov can't get version from inheritance yet
# so we need to add it manually for versioned dependencies.
Provides: perl(Image/Magick.pm) = %mversion.860

%description -n perl-Magick
This is the %name perl support package.  It includes perl modules
and support files for access to %name library from perl.

%package tools
Summary: Console tools from %name
Group: Graphics
Requires: lib%name = %version-%release
Conflicts: GraphicsMagick-ImageMagick-compat
Provides: convert

%description tools
%name is a powerful image conversion and manipulation tools.
This package installs the necessary files to run %name-tools.

%package doc
Summary: Documentation for %name
Group: Graphics
Requires: %name-tools
BuildArch: noarch

%description doc
Documentation for %name

%def_disable static

%prep
%setup -q -n %name-%dversion-%drelease
#patch1 -p2
touch config.rpath

# XXX tests fail
rm PerlMagick/t/composite.t
rm PerlMagick/t/filter.t
rm PerlMagick/t/montage.t
subst 's,2.69,2.68,' configure.ac

%build
%autoreconf
%configure \
	--with-modules \
	--with-fontpath=%_datadir/fonts/type1/urw \
	--with-gs-font-dir=%_datadir/fonts/type1/urw \
	--with-gvc=yes \
	--with-rsvg=yes \
	--with-lqr=yes \
	--disable-hdri \
	--with-gcc-arch=no \
	--with-perl \
	%{subst_enable x} \
	--with-perl-options="PREFIX=%_prefix INSTALLDIRS=vendor" \
	%{subst_enable static}
subst 's|^\(hardcode_into_libs\)=.*$|\1=no|' libtool
%make_build

pushd PerlMagick
perl Makefile.PL
make
popd

%install
%make transform='' DESTDIR=%buildroot INSTALLDIRS=vendor install


%__subst "s,%_libdir/libMagickCore.la,-L%_libdir -lMagickCore," %buildroot%_libdir/%mgkdir-%dversion/modules-%qlev/*/*.la

%__install -pD -m644 %SOURCE1 %buildroot%_datadir/applications/%name.desktop
%__install -pD -m644 %SOURCE2 %buildroot%_miconsdir/%name.png
%__install -pD -m644 %SOURCE3 %buildroot%_niconsdir/%name.png
%__install -pD -m644 %SOURCE4 %buildroot%_liconsdir/%name.png

chrpath -d %buildroot%perl_vendor_archlib/auto/Image/Magick/Magick.so
chrpath -d %buildroot%perl_vendor_archlib/auto/Image/Magick//Q16/Q16.so

mv %buildroot%_docdir/%name-6 %buildroot%_docdir/%name-%dversion
%files

%files tools
%_bindir/[a-z]*
%_man1dir/%name.1*
%_man1dir/[a-z]*.1*
# display, menu and icons to be moved into subpackage
%_datadir/applications/%name.desktop
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png

%files doc
%dir %_docdir/%name-%dversion
%dir %_docdir/%name-%dversion/www
%_docdir/%name-%dversion/LICENSE
%_docdir/%name-%dversion/images
%_docdir/%name-%dversion/index.html
%_docdir/%name-%dversion/www/*
%exclude %_docdir/%name-%dversion/www/api
%exclude %_docdir/%name-%dversion/www/Magick++

%files -n lib%name
%dir %_libdir/%mgkdir-%dversion
%dir %_libdir/%mgkdir-%dversion/modules-%qlev
%dir %_libdir/%mgkdir-%dversion/modules-%qlev/coders
%dir %_libdir/%mgkdir-%dversion/modules-%qlev/filters
%_libdir/%mgkdir-%dversion/modules-%qlev/*/*
%dir %_datadir/%mgkdir-%mversion
%dir %_sysconfdir/%name-%mversion
%_datadir/%mgkdir-%mversion/*
%config %_sysconfdir/%name-%mversion/*
%_libdir/*.so.*

%files -n lib%name-devel
%dir %_docdir/%name-%dversion
%dir %_docdir/%name-%dversion/www
%_docdir/%name-%dversion/www/api
%_docdir/%name-%dversion/www/Magick++
%_bindir/*-config
%_includedir/*
%_libdir/*.so
%_libdir/%mgkdir-%dversion/config-%qlev
%_pkgconfigdir/*.pc
%_man1dir/*-config.1*

%files -n perl-Magick
%doc www/perl-magick.html images/examples.jpg PerlMagick/demo
%perl_vendor_archlib/Image
%perl_vendor_autolib/Image

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
