%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl
%define vtkver 6.2

%define oname mayavi
Name:           Mayavi
Version:        4.4.0
Release:        alt1.git20150422
Summary:        Scientific data 3-dimensional visualizer

Group:          Graphics
License:        BSD and EPL and LGPLv2+ and LGPLv3+
URL:            http://code.enthought.com/projects/mayavi/
# https://github.com/enthought/mayavi.git
Source:         %name-%version.tar.gz
Source1:        Mayavi.desktop
Source2:        tvtk_doc.desktop
# Removes already generated tvtk class zip file
# https://svn.enthought.com/enthought/ticket/1817
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

BuildRequires: python-module-setuptools python-module-setupdocs
BuildRequires: python-module-sphinx-devel libnumpy-devel
BuildRequires: python-module-vtk%vtkver /proc strace
BuildPreReq: desktop-file-utils
BuildPreReq: python-module-sip-devel libpympi-devel
BuildPreReq: python-module-PyQt4-devel /usr/bin/ssh vtk%vtkver-python
BuildPreReq: libGL-devel libGLU-devel xvfb-run
BuildPreReq: python-module-traits python%_python_version(traits.api)

Provides: %oname = %version-%release
#py_requires %oname tvtk wx
#Requires: python-module-%oname.tests = %version-%release
Requires:       python-module-apptools
#Requires:       python-module-EnthoughtBase
Requires:       python-module-EnvisageCore
Requires:       python-module-EnvisagePlugins
Requires:       python-module-traits
#Requires:       python-module-TraitsGUI
#Requires:       python-module-TraitsBackendQt
Requires: python-module-mayavi = %EVR
Requires: python-module-mayavi.tests = %EVR
Requires: python-module-tvtk = %EVR
Requires: python-module-vtk%vtkver

%add_python_req_skip test tvtk_classes

%description
The Mayavi project includes two related packages for 3-dimensional
visualization:

 * Mayavi2: A tool for easy and interactive visualization of data.
 * TVTK: A Traits-based wrapper for the Visualization Toolkit, a
popular open-source visualization library.
These operate at different levels of abstraction. TVTK manipulates
visualization objects, while Mayavi2 lets you operate on your data,
and then see the results. Most users either use the Mayavi user
interface or program to its scripting interface; you probably don't
need to interact with TVTK unless you want to create a new Mayavi
module.

%package -n python-module-%oname
Summary: Python files for Mayavi, scientific data 3-dimensional visualizer
Group: Development/Python
Conflicts: %name < %version-%release
%add_python_req_skip wxversion

%description -n python-module-%oname
This package contains Python files for Mayavi, scientific data
3-dimensional visualizer.

%package -n python-module-%oname.tests
Summary: Tests for Mayavi, scientific data 3-dimensional visualizer
Group: Development/Python
Requires: python-module-%oname = %version-%release

%description -n python-module-%oname.tests
This package contains tests for Mayavi, scientific data
3-dimensional visualizer.

%package -n python-module-tvtk
Summary: TVTK: A Traits-based wrapper for the Visualization Toolkit
Group: Development/Python
Conflicts: %name < %version-%release

%description -n python-module-tvtk
TVTK: A Traits-based wrapper for the Visualization Toolkit, a
popular open-source visualization library.
These operate at different levels of abstraction. TVTK manipulates
visualization objects, while Mayavi2 lets you operate on your data,
and then see the results. Most users either use the Mayavi user
interface or program to its scripting interface; you probably don't
need to interact with TVTK unless you want to create a new Mayavi
module.

%package -n python-module-tvtk.tests
Summary: Tests for TVTK
Group: Development/Python
Requires: python-module-tvtk = %version-%release

%description -n python-module-tvtk.tests
TVTK: A Traits-based wrapper for the Visualization Toolkit, a
popular open-source visualization library.
These operate at different levels of abstraction. TVTK manipulates
visualization objects, while Mayavi2 lets you operate on your data,
and then see the results. Most users either use the Mayavi user
interface or program to its scripting interface; you probably don't
need to interact with TVTK unless you want to create a new Mayavi
module.

This package contains tests for TVTK.

%package doc
Summary: Documentation for Mayavi, scientific data 3-dimensional visualizer
Group: Documentation
BuildArch: noarch
Conflicts: %name < %version-%release

%description doc
This package contains documentation for Mayavi, scientific data
3-dimensional visualizer.

%prep
%setup

%build
#source %mpidir/bin/mpivars.sh

export PYTHONPATH=$PWD:$PWD/docs/source/mayavi/sphinxext
xvfb-run --server-args="-screen 0 1024x768x24" \
	python setup.py build
#xvfb-run --server-args="-screen 0 1024x768x24" \
#	pvtkpython setup.py build

%install
#source %mpidir/bin/mpivars.sh

export PYTHONPATH=$PWD:$PWD/docs/source/mayavi/sphinxext
xvfb-run --server-args="-screen 0 1024x768x24" \
	python setup.py install --skip-build --root=%buildroot

install -d %buildroot%_man1dir
install -p -m644 docs/mayavi2.man %buildroot%_man1dir/mayavi2.1

install -d %buildroot%_desktopdir
install -p -m644 %SOURCE1 %SOURCE2 %buildroot%_desktopdir

install -d %buildroot%_liconsdir
install -d %buildroot%_miconsdir
install -d %buildroot%_niconsdir

install -p -m644 docs/source/mayavi/images/mayavi2-48x48.png \
	%buildroot%_liconsdir/mayavi2.png
ln -s %_liconsdir/mayavi2.png %buildroot%_miconsdir/
ln -s %_liconsdir/mayavi2.png %buildroot%_niconsdir/

%files
%doc *.txt
%_bindir/mayavi2
%_bindir/tvtk_doc
%python_sitelibdir/*
%exclude %python_sitelibdir/mayavi*
%exclude %python_sitelibdir/tvtk
#exclude %python_sitelibdir/examples
%_man1dir/*
%_desktopdir/*
%_liconsdir/*
%_miconsdir/*
%_niconsdir/*

%files -n python-module-%oname
%python_sitelibdir/mayavi*
%exclude %python_sitelibdir/mayavi/tests

%files -n python-module-%oname.tests
%python_sitelibdir/mayavi/tests

%files -n python-module-tvtk
%python_sitelibdir/tvtk
%exclude %python_sitelibdir/tvtk/tests

%files -n python-module-tvtk.tests
%python_sitelibdir/tvtk/tests

%files doc
%doc docs/*.txt docs/pdf examples docs/build/tvtk docs/build/mayavi

%changelog
