%def_without debug
%def_with libs
%def_with devel
%def_disable static
%define mysqld_user mysql
%define _libexecdir %_sbindir
%define ROOT %_localstatedir/mysql

Name: MySQL
Version: 5.7.28
Release: alt1

Summary: A very fast and reliable SQL database engine
Summary(ru_RU.UTF-8): Очень быстрый и надежный SQL-сервер
Group: Databases
License: GPL / LGPL
Url: http://www.mysql.com/
Packager: MySQL Development Team <mysql@packages.altlinux.org>

Source: %name-%version.tar
Source99: boost.tar
Source1: mysqld.init
Source2: mysql.logrotate
Source3: safe_mysqld
Source4: mysqld_wrapper
Source5: my.cnf
Source6: mysql.chroot.lib
Source7: mysql.chroot.conf
Source8: mysql.chroot.all
Source9: mysql_migrate
Source10: mysqld.sysconfig
Source14: README.ALT-ru_RU.UTF-8
Source15: alt-mysql_install_db.sh
Source16: mysql.control
Source17: mysqld-chroot.control

Source20: mysql.tmpfiles.d
Source21: mysqld.service
Source22: mysqld.service.d-user

Source25: client.cnf
Source26: server.cnf
Source27: mysql-clients.cnf
Source28: chroot.cnf
Source29: no-chroot.cnf

Patch0: mysql-%version.patch

# ALTLinux
Patch1: mysql-5.7.21-alt-chroot.patch
Patch2: mysql-5.0.20-alt-libdir.patch
Patch4: mysql-5.7.21-alt-client.patch
Patch5: mysql-5.7.21-alt-load_defaults.patch
Patch6: mysql-5.1.50-alt-fPIC-innodb.patch
Patch7: mysql-5.7.21-alt-mysql_config-libs.patch
Patch8: mysql-5.5.43-alt-aarch64-lib64.patch
Patch9: mysql-5.7.21-alt-disable-run-libmysql_api_test.patch

# Patches taken from boost 1.59
Patch115: boost-1.58.0-pool.patch
Patch125: boost-1.57.0-mpl-print.patch
Patch136: boost-1.57.0-spirit-unused_typedef.patch
Patch145: boost-1.54.0-locale-unused_typedef.patch
Patch170: boost-1.59.0-log.patch
Patch180: boost-1.59-python-make_setter.patch
Patch181: boost-1.59-test-fenv.patch

# Automatically added by buildreq on Wed Mar 16 2011 (-bi)
BuildRequires: chrooted gcc-c++ libncursesw-devel libreadline-devel libssl-devel perl-DBI libpam0-devel libevent-devel
BuildRequires: libaio-devel libjemalloc-devel libedit-devel perl-GD perl-threads perl-Memoize perl-devel
BuildRequires: liblz4-devel zlib-devel
BuildRequires: cmake control
BuildRequires: libsystemd-devel

%define soname 20

%package -n libmysqlclient%soname
Summary: Shared libraries for MySQL
Summary(ru_RU.UTF-8): Динамические библиотеки для MySQL
License: LGPL
Group: System/Libraries
Provides: libMySQL = %EVR
Obsoletes: libMySQL < %EVR

%package -n libmysqlclient%soname-devel
Summary: Development header files and libraries for MySQL
Summary(ru_RU.UTF-8): Интерфейс прикладного уровня для разработки программ с MySQL
License: LGPL
Group: Development/C
Requires: libmysqlclient%soname = %EVR
Provides: MySQL-devel = %EVR mysql-devel = %EVR
Obsoletes: MySQL-devel < %EVR mysql-devel < %EVR
Provides: libMySQL-devel = %EVR
Obsoletes: libMySQL-devel < %EVR
Conflicts: libmariadb-devel
Provides: libmysqlclient-devel = %EVR

%package -n libmysqlclient%soname-devel-static
Summary: Development static libraries for MySQL
Summary(ru_RU.UTF-8): Интерфейс прикладного уровня для разработки программ с MySQL
License: LGPL
Group: Development/C
Requires: libmysqlclient%soname-devel = %EVR
Provides: libMySQL-devel-static = %EVR
Obsoletes: libMySQL-devel-static < %EVR
Conflicts: libmariadb-devel-static

%package client
Summary: MySQL Client
Summary(ru_RU.UTF-8): Клиент MySQL
License: GPL
Group: Databases
Provides: mysql-client = %EVR
Obsoletes: mysql-client < %EVR

%package server
Summary: A very fast and reliable SQL database engine
Summary(ru_RU.UTF-8): Очень быстрый и надежный SQL-сервер
License: GPL
Group: Databases
PreReq: MySQL-client = %EVR
PreReq: shadow-utils, coreutils, glibc-locales
Requires(post,preun): chkconfig, chrooted, coreutils, findutils, grep, sed
Provides: mysql-server = %EVR MySQL = %EVR mysql = %EVR community-mysql = %EVR
Obsoletes: mysql-server < %EVR MySQL < %EVR mysql < %EVR
Conflicts: mariadb-server-control

%package server-perl
Summary: Perl utils for MySQL-server
Summary(ru_RU.UTF-8): Perl-утилиты для MySQL-server
License: GPL
Group: Databases
Requires: MySQL-server = %EVR, perl-DBD-mysql
BuildArch: noarch


%define see_base For a description of MySQL see the base MySQL RPM or %url
%define see_base_ru Подробное описание смотрите в пакете MySQL или на %url

%description
MySQL is a true multi-user, multi-threaded SQL (Structured Query
Language) database server. MySQL is a client/server implementation
that consists of a server daemon (mysqld) and many different client
programs/libraries.

The main goals of MySQL are speed, robustness and ease of use.  MySQL
was originally developed because we needed a SQL server that could
handle very big databases with magnitude higher speed than what any
database vendor could offer to us. And since we did not need all the
features that made their server slow we made our own. We have now been
using MySQL since 1996 in a environment with more than 40 databases,
10,000 tables, of which more than 500 have more than 7 million
rows. This is about 200G of data.

The base upon which MySQL is built is a set of routines that have been
used in a highly demanding production environment for many
years. While MySQL is still in development, it already offers a rich
and highly useful function set.

This version allows to use transactions with BDB tables and extended
character set support. See the documentation for more information

%description -l ru_RU.UTF-8
MySQL - это многопользовательский, многопоточный SQL-сервер (SQL -
структурированный язык запросов) баз данных. MySQL построен по технологии
клиент/сервер и включает в себя сервер mysqld и набор различных клиентских
программ и библиотек разработчиков.

Козыри MySQL - скорость, надежность и простота использования. Разработка
MySQL ведется на основе программного кода, который используется в
критических промышленных приложениях уже в течение многих лет. Несмотря на
то, что MySQL только разрабатывается, он уже предоставляет богатый и очень
полезный набор функций.

Данная версия MySQL собрана с поддержкой транзакций и расширенной поддержкой
различных текстовых кодировок. См. документацию для более подробной информации.

%description server
MySQL is a true multi-user, multi-threaded SQL (Structured Query
Language) database server. MySQL is a client/server implementation
that consists of a server daemon (mysqld) and many different client
programs/libraries.

The main goals of MySQL are speed, robustness and ease of use.  MySQL
was originally developed because we needed a SQL server that could
handle very big databases with magnitude higher speed than what any
database vendor could offer to us. And since we did not need all the
features that made their server slow we made our own. We have now been
using MySQL since 1996 in a environment with more than 40 databases,
10,000 tables, of which more than 500 have more than 7 million
rows. This is about 200G of data.

The base upon which MySQL is built is a set of routines that have been
used in a highly demanding production environment for many
years. While MySQL is still in development, it already offers a rich
and highly useful function set.

This version allows to use transactions with BDB tables and extended
character set support. See the documentation for more information.

By default, MySQL server runs in safe chrooted environment with own uid and gid.

%description server-perl
MySQL is a true multi-user, multi-threaded SQL (Structured Query
Language) database server. MySQL is a client/server implementation
that consists of a server daemon (mysqld) and many different client
programs/libraries.
This package contents perl utils for MySQL-server.

%description server -l ru_RU.UTF-8
MySQL - это многопользовательский, многопоточный SQL-сервер (SQL -
структурированный язык запросов) баз данных. MySQL построен по технологии
клиент/сервер и включает в себя сервер mysqld и набор различных клиентских
программ и библиотек разработчиков.

Козыри MySQL - скорость, надежность и простота использования. Разработка
MySQL ведется на основе программного кода, который используется в
критических промышленных приложениях уже в течение многих лет. Несмотря на
то, что MySQL только разрабатывается, он уже предоставляет богатый и очень
полезный набор функций.

Данная версия MySQL собрана с поддержкой транзакций и расширенной поддержкой
различных текстовых кодировок. См. документацию для более подробной информации.

%description -n libmysqlclient%soname
This package contains the shared libraries (*.so*) which certain
languages and applications need to dynamically load and use MySQL.

%description -n libmysqlclient%soname -l ru_RU.UTF-8
Этот пакет содержит динамически загружаемые библиотеки (файлы *.so*),
требуемые для работы большинства клиентских приложений, взаимодействующих
с СУБД MySQL.

%description -n libmysqlclient%soname-devel
This package contains the development header files and libraries
necessary to develop MySQL client applications.

%see_base

%description -n libmysqlclient%soname-devel -l ru_RU.UTF-8
Этот пакет содержит файлы заголовков и библиотеки интерфейса
прикладного уровня, необходимые для разработки клиентских
приложений, взаимодействующих с SQL-сервером MySQL.

%see_base_ru

%description -n libmysqlclient%soname-devel-static
This package contains the development libraries for static linking
necessary to develop MySQL client applications.

%see_base

%description -n libmysqlclient%soname-devel-static -l ru_RU.UTF-8
Этот пакет содержит статические библиотеки интерфейса прикладного уровня,
необходимые для разработки клиентских приложений,
взаимодействующих с SQL-сервером MySQL.

%see_base_ru

%description client
This package contains the standard MySQL clients.

%see_base

%description client -l ru_RU.UTF-8
Этот пакет содержит стандартные клиентские программы для SQL-сервера MySQL

%see_base_ru

%prep
%setup -a99
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch4 -p1
%patch5 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1

# Patch Boost
pushd boost/boost_1_59_0
%patch115 -p0
%patch125 -p1
%patch136 -p1
%patch145 -p1
%patch170 -p2
%patch180 -p2
%patch181 -p2
popd

# with patch4
# Prepare commands list for completion in mysql client.
sed -n 's/^\([[:space:]]*{[[:space:]]*SYM.*(\)\("[&<=>|!A-Z][^"]*"\).*/{\2,0, 0, 0, ""},/p' <sql/lex.h >client/mysql_symbols.inc

%build

%cmake \
	-DBUILD_CONFIG=mysql_release \
	-DFEATURE_SET="community" \
	-DINSTALL_LAYOUT=RPM \
	-DCMAKE_VERBOSE_MAKEFILE=ON \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=ON \
	-DCMAKE_C_FLAGS:STRING="$CFLAGS" \
	-DCMAKE_CXX_FLAGS:STRING="$CXXFLAGS" \
	-DCMAKE_INSTALL_PREFIX="%_prefix" \
	-DSYSCONFDIR="%_sysconfdir" \
	-DSYSCONF2DIR="%_sysconfdir/my.cnf.d" \
	-DINSTALL_INCLUDEDIR=include/mysql \
	-DINSTALL_INFODIR=share/info \
	-DINSTALL_LIBDIR="%_lib" \
	-DINSTALL_MANDIR=share/man \
	-DINSTALL_MYSQLSHAREDIR=share/mysql \
	-DINSTALL_MYSQLTESTDIR=share/mysql-test \
	-DINSTALL_PLUGINDIR="%_lib/mysql/plugin" \
	-DINSTALL_SBINDIR=sbin \
	-DINSTALL_SCRIPTDIR=sbin \
	-DINSTALL_SUPPORTFILESDIR=share/mysql \
	-DINSTALL_MYSQLDATADIR="%ROOT" \
	-DINSTALL_MYSQLKEYRINGDIR="/var/lib/mysql-keyring" \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DMYSQL_UNIX_ADDR="%ROOT/mysql.sock" \
	-DMYSQL_DATADIR="%ROOT" \
	-DMYSQL_USER=mysql \
	-DWITH_SSL=system \
	-DWITH_ZLIB=system \
	-DWITH_LZ4=system \
	-DWITH_LIBEVENT=system \
	-DWITH_EDITLINE=system \
	-DWITH_PIC=ON \
	-DWITH_EXTRA_CHARSETS=all \
	-DWITH_ARCHIVE_STORAGE_ENGINE=ON \
	-DWITH_BLACKHOLE_STORAGE_ENGINE=ON \
	-DWITH_INNOBASE_STORAGE_ENGINE=ON \
	-DWITH_PARTITION_STORAGE_ENGINE=ON \
	-DWITH_FEDERATED_STORAGE_ENGINE=ON \
	-DWITHOUT_EXAMPLE_STORAGE_ENGINE=ON \
	-DENABLED_LOCAL_INFILE=ON \
	-DWITH_READLINE=OFF \
	-DWITH_SYSTEMD=ON \
	-DCMAKE_C_FLAGS="%optflags" \
	-DCMAKE_CXX_FLAGS="%optflags" \
	-DWITH_BOOST=../boost/boost_1_59_0 \
	-DCOMPILATION_COMMENT="(%distribution)" \
	-DMYSQL_SERVER_SUFFIX="-%release"

%cmake_build

%install
mkdir -p %buildroot{%_bindir,%_sbindir,%_includedir,%_mandir,%_datadir,/var/log/mysql}
mkdir -p %buildroot%ROOT/{etc,/%_lib,%_libdir,%_libdir/mysql/plugin/,dev,log,tmp,/var/{nis,yp/binding},db/mysql,usr/share/mysql/charsets}
touch %buildroot%ROOT{%_sysconfdir/{hosts,services,{host,nsswitch,resolv}.conf},/dev/urandom,/var/nis/NIS_COLD_START}

%cmakeinstall_std


# Install various helper scripts.
install -pD -m755 %SOURCE1 %buildroot%_initdir/mysqld
install -pD -m644 %SOURCE2 %buildroot%_sysconfdir/logrotate.d/mysql
install -pD -m755 %SOURCE3 %buildroot%_sbindir/safe_mysqld
install -pD -m755 %SOURCE4 %buildroot%_sbindir/mysqld_wrapper
install -pD -m750 %SOURCE6 %buildroot%_sysconfdir/chroot.d/mysql.lib
%if "%_libdir" == "/usr/lib64"
sed -i s,usr/lib,usr/lib64,g %buildroot%_sysconfdir/chroot.d/mysql.lib
%endif
install -pD -m750 %SOURCE7 %buildroot%_sysconfdir/chroot.d/mysql.conf
install -pD -m750 %SOURCE8 %buildroot%_sysconfdir/chroot.d/mysql.all
install -pD -m750 %SOURCE9 %buildroot%_sbindir/mysql_migrate
install -pD -m644 %SOURCE10 %buildroot%_sysconfdir/sysconfig/mysqld
install -pD -m755 %SOURCE16 %buildroot%_controldir/mysqld
install -pD -m755 %SOURCE17 %buildroot%_controldir/mysqld-chroot

# Backwards compatibility symlinks (ALT #14863)
ln -snf ../sbin/safe_mysqld %buildroot%_bindir/mysqld_safe

# delete deprecated
rm -f %buildroot%_bindir/mysql_install_db

# Install configuration files.
install -pD -m644 %SOURCE5 %buildroot%_sysconfdir/my.cnf
install -pD -m644 %SOURCE25 %buildroot%_sysconfdir/my.cnf.d/client.cnf
install -pD -m644 %SOURCE26 %buildroot%_sysconfdir/my.cnf.d/server.cnf
install -pD -m644 %SOURCE27 %buildroot%_sysconfdir/my.cnf.d/mysql-clients.cnf
install -pD -m644 %SOURCE28 %buildroot%_sysconfdir/my.cnf.server/chroot.cnf
install -pD -m644 %SOURCE29 %buildroot%_sysconfdir/my.cnf.server/no-chroot.cnf

install -pD -m644 %SOURCE20 %buildroot%_tmpfilesdir/mysql.conf
install -pD -m644 %SOURCE21 %buildroot%_unitdir/mysqld.service
install -pD -m644 %SOURCE22 %buildroot%_sysconfdir/systemd/system/mysqld.service.d/user.conf

# Fix libmysqlclient_r symlinks
(
	cd %buildroot%_libdir
	N="libmysqlclient_r.so"
	for l in $N.*; do
		if [ -h $l ]; then
			t=${l#$N}
			ln -sf libmysqlclient.so$t $N$t
		fi
	done
)

# Populate chroot with data to some extent.
install -pD -m644 %buildroot%_datadir/mysql/charsets/* \
		     %buildroot%ROOT%_datadir/mysql/charsets

(
	cd %buildroot%_datadir/mysql
	for i in */errmsg.sys; do
		install -pD -m644 $i  %buildroot%ROOT%_datadir/mysql/$i
	done
)


mkdir -p %buildroot%_docdir/MySQL-%version
install -p -m644 README %SOURCE14 %buildroot%_docdir/MySQL-%version

rm -f %buildroot%_bindir/safe_mysqld
rm -f %buildroot%_datadir/mysql/mysql{-*.spec,-log-rotate,.server}

touch %buildroot%ROOT/log/queries
touch %buildroot%_logdir/mysql/info

install -p -m 0750 -d %buildroot%_localstatedir/mysql-files
install -p -m 0700 -d %buildroot%_localstatedir/mysql-keyring

# not needed in rpm package
rm -rf %buildroot%_datadir/mysql-test
rm -f %buildroot%_libdir/mysql/plugin/*.la
rmdir %buildroot%_libdir/mysql/plugin/debug
rm -f %buildroot%_bindir/mysql_embedded
rm -f %buildroot%_libdir/mysql/*.a
rm -f %buildroot%_datadir/mysql/magic
rm -f %buildroot%_datadir/mysql/mysqld_multi.server

# broken manpages referencing missing paths
rm -f %buildroot%_man1dir/mysql{_client_,}test_embedded.1
rm -fr %buildroot/usr/share/info


%define get_datadir \
DATADIR=`/usr/bin/my_print_defaults mysqld |sed -ne 's/^--datadir=\\(.*\\)/\\1/pg' |tail -1` \
[ -n "$DATADIR" ] || { echo "Failed to read configuration"; exit 1; }

%postun server
if [ $1 = 0 ]; then
	rm -f %ROOT/lib/* %ROOT/var/yp/binding/*
fi

%preun server
%preun_service mysqld

%pre server
/usr/sbin/groupadd -r -f %mysqld_user
/usr/sbin/useradd -r -g %mysqld_user -d %ROOT -s /dev/null -c "MySQL server" -n %mysqld_user >/dev/null 2>&1 ||:

if [ ! -e %ROOT/my.cnf -a -f /etc/my.cnf -a ! -L /etc/my.cnf -a ! -e /etc/my.cnf.rename ]; then
	mv -v /etc/my.cnf /etc/my.cnf.rename &&
	chown 0:0 /etc/my.cnf.rename &&
	chmod 600 /etc/my.cnf.rename ||
	{ echo "Error moving my.cnf" >&2; exit 1; }
fi

%pre_control mysqld
%pre_control mysqld-chroot

echo "####################################################################"
echo "#   You may need database format conversion for correct operation: #"
echo "#  Please consider using: /usr/bin/mysql_upgrade according to      #"
echo "#  https://dev.mysql.com/doc/refman/5.7/en/upgrading.html          #"
echo "####################################################################"

%post server
if [ -f /etc/my.cnf.rename -a ! -L /etc/my.cnf.rename -a ! -e /etc/my.cnf ]; then
	mv -fv %ROOT/my.cnf %ROOT/my.cnf.rpmnew &&
	mv -v /etc/my.cnf.rename %ROOT/my.cnf &&
	chown 0:0 %ROOT/my.cnf &&
	chmod 600 %ROOT/my.cnf ||
	{ echo "Error moving my.cnf" >&2; mv -v /etc/my.cnf.rename /etc/my.cnf; }
fi

if grep "^[[:space:]]*skip-bdb[[:space:]]*$" /var/lib/mysql/my.cnf > /dev/null 2>&1; then
	sed -i "s/^[[:space:]]*skip-bdb[[:space:]]*$/#skip-bdb/" /var/lib/mysql/my.cnf;
fi

if grep "^[[:space:]]*bdb-logdir=" /var/lib/mysql/my.cnf > /dev/null 2>&1; then
	sed -i "s/^[[:space:]]*bdb-logdir=/#bdb-logdir=/" /var/lib/mysql/my.cnf;
fi


if grep "^[[:space:]]*skip-locking[[:space:]]*$" /var/lib/mysql/my.cnf > /dev/null 2>&1; then
	sed -i "s/^[[:space:]]*skip-locking[[:space:]]*$/skip-external-locking/" /var/lib/mysql/my.cnf;
fi

rm -rf %ROOT/dev
%_sysconfdir/chroot.d/mysql.all force

%post_control -s local mysqld
%post_control -s enabled mysqld-chroot


# see also http://dev.mysql.com/doc/refman/5.5/en/upgrading.html
%get_datadir
if [ "$DATADIR" = / ]; then
	# Have to update configuration manually.
	sed -i 's,^datadir=/$,datadir=/db,g' /etc/my.cnf &&
		DATADIR=`/usr/bin/my_print_defaults mysqld |sed -ne 's/^--datadir=\(.*\)/\1/pg' |tail -1` ||
		{ echo "Failed to update configuration"; exit 1; }
fi

NEED_RESTART=
if [ -f "%ROOT/mysql/db.frm" -a ! -f "%ROOT$DATADIR/mysql/db.frm" ]; then
	%_initdir/mysqld status &>/dev/null && %_initdir/mysqld stop && NEED_RESTART=1 ||:
	(cd %ROOT
	install -d -m750 -o %mysqld_user -g adm ".$DATADIR"
	for d in `find -mindepth 1 -maxdepth 1 -type d |grep -Ev '\./(dev|etc|lib|log|tmp|db)$'`; do
		mv -i "$d" ".$DATADIR/$d"
	done)
	echo "Database root have been moved to $DATADIR"
fi

if [ -n "$NEED_RESTART" ]; then
	%_initdir/mysqld start ||:
else
	%post_service mysqld
fi

%triggerin server -- MySQL-server < 5.7.21-alt1
#if pre 5.7.21 installation of server have never been run, we should
#remove empty /var/lib/mysql/db/mysql dir to enable --initialize sequence
%get_datadir
# look for empty dir 
if [ "$(ls -A %ROOT$DATADIR/mysql)" ]; then
#     echo "Database dir is not Empty"
     echo "%ROOT$DATADIR/mysql"
else
#    echo "Database dir is Empty, removing"
    rmdir %ROOT$DATADIR/mysql ||:
fi

echo "####################################################################"
echo "#              Attention! MySQL upgrade 5.5.xx -> %version           #"
echo "####################################################################"
echo "#  Please backup your data before you start conversion!            #"
echo "#  You may need database format conversion for correct operation:  #"
echo "# 1. run server: /usr/sbin/mysqld -C utf8 --skip-grant-tables &    #"
echo "# 2. run converter:  /usr/bin/mysql_upgrade                        #"
echo "#  To ensure the conversion succeeded:                             #"
echo "# 3. cat %ROOT$DATADIR/mysql_upgrade_info                      #"
echo "# MySQL version should be displayed as: \"%version\"                   #"
echo "####################################################################"

%triggerpostun server -- MySQL-server < 5.5.28-alt1
%get_datadir
# they've moved innodb to plugins in later 5.1 just to move it back in 5.5, sigh
if [ -f /var/lib/mysql/my.cnf -a -f "%ROOT$DATADIR/ibdata1" ]; then
	if grep "^plugin-load=innodb=ha_innodb_plugin\.so" /var/lib/mysql/my.cnf; then
		echo "  WARNING: if InnoDB is used, please examine /var/lib/mysql/my.cnf*"
		echo "  and ensure that the *builtin* innodb is in use again"
	fi
fi

%if_with libs
%files -n libmysqlclient%soname
%_libdir/*.so.*
%endif

%if_with devel
%files -n libmysqlclient%soname-devel
%_bindir/mysql_config
%_libdir/*.so
%_includedir/*
%_aclocaldir/mysql.m4
%_pkgconfigdir/*.pc
%endif

%if_enabled static
%files -n libmysqlclient%soname-devel-static
%_libdir/*.a
%_libdir/mysql
%_pkgconfigdir/*.pc
%endif

%files client
%dir %_sysconfdir/my.cnf.d
%config(noreplace) %_sysconfdir/my.cnf.d/client.cnf
%config(noreplace) %_sysconfdir/my.cnf.d/mysql-clients.cnf
%_bindir/innochecksum
%_bindir/my_print_defaults
%_bindir/mysql
%_bindir/mysql_client_test
%_bindir/mysqladmin
%_bindir/mysqlbinlog
%_bindir/mysqlcheck
%_bindir/mysqldump
%_bindir/mysqlimport
%_bindir/mysqlpump
%_bindir/mysqlshow
%_bindir/mysqltest
%_bindir/mysqlslap
%_bindir/perror
%_bindir/replace
%_bindir/resolve*
%_bindir/lz4_decompress
%_bindir/zlib_decompress
%_mandir/man?/*

%files server-perl
%_bindir/mysqldumpslow

%files server
%_initdir/*
%config(noreplace) %_sysconfdir/sysconfig/*
%config(noreplace) %_sysconfdir/logrotate.d/*
%config(noreplace) %_sysconfdir/control.d/facilities/*
%config %_sysconfdir/chroot.d/*
%config(noreplace) %_sysconfdir/my.cnf
%config(noreplace) %_sysconfdir/my.cnf.d/server.cnf
%_sysconfdir/my.cnf.server
%config(noreplace) %_sysconfdir/my.cnf.server/*.cnf
%_tmpfilesdir/mysql.conf
%_unitdir/mysqld.service
%config(noreplace) %_sysconfdir/systemd/system/mysqld.service.d/user.conf

%_bindir/*isam*
%_bindir/mysql_secure_installation
%_bindir/mysql_ssl_rsa_setup
%_bindir/mysql_tzinfo_to_sql
%_bindir/mysql_upgrade
%_bindir/mysqld_safe
%_bindir/mysql_plugin
%_sbindir/*
%_libdir/mysql/plugin
%_datadir/mysql
%attr(750,root,adm) %dir /var/log/mysql
%ghost %verify(not md5 mtime size) /var/log/mysql/*
%attr(0770,root,mysql) %dir %_localstatedir/mysql-files
%attr(0700,mysql,mysql) %dir %_localstatedir/mysql-keyring
%dir %_docdir/MySQL-%version
%_docdir/MySQL-%version/README*
%attr(3771,root,mysql) %dir %ROOT
%attr(710,root,mysql) %dir %ROOT/%_lib
%attr(710,root,mysql) %dir %ROOT/%_libdir
%attr(710,root,mysql) %dir %ROOT/%_libdir/mysql
%attr(710,root,mysql) %dir %ROOT/%_libdir/mysql/plugin
%attr(710,root,mysql) %dir %ROOT%_sysconfdir
%ghost %ROOT%_sysconfdir/hosts
%ghost %ROOT%_sysconfdir/services
%ghost %ROOT%_sysconfdir/*.conf
%dir %ROOT/dev
%ghost %ROOT/dev/urandom
%attr(710,root,mysql) %dir %ROOT/var
%dir %ROOT/var/nis
%ghost %ROOT/var/nis/NIS_COLD_START
%dir %ROOT/var/yp
%dir %ROOT/var/yp/binding
%dir %ROOT/usr
%dir %ROOT%_datadir
%ROOT%_datadir/mysql
%attr(3770,root,mysql) %dir %ROOT/db
%attr(750,mysql,mysql) %ghost %ROOT/db/*
%attr(3770,root,mysql) %dir %ROOT/log
%attr(660,mysql,mysql) %ghost %verify(not md5 mtime size) %ROOT/log/*
%attr(3770,root,mysql) %dir %ROOT/tmp

%changelog
