%define git_hash .git1d3ce06d137c
#define git_hash %nil

%define dbus_version 1.2.12-alt2
%define libdbus_glib_version 0.76

%define nm_glib_sover 4
%define libnm_glib libnm-glib%nm_glib_sover
%define nm_glib_vpn_sover 1
%define libnm_glib_vpn libnm-glib-vpn%nm_glib_vpn_sover
%define nm_util_sover 2
%define libnm_util libnm-util%nm_util_sover

%define ppp_version 2.4.7
%define wpa_supplicant_version 0.7.3-alt3
%define dhcpcd_version 4.0.0
%define openresolv_version 3.5.4-alt3

%def_enable systemd
%def_enable introspection
%def_disable teamdctl
%def_enable nmtui
%def_enable bluez5dun
%def_enable vala

# There is no sources in debuginfo with LTO
%def_disable lto

# NOTE: ONLY use sanitizers for debug purposes
%def_disable sanitizers

%define _name %name-daemon
%define dispatcherdir %_sysconfdir/NetworkManager/dispatcher.d
%define nmlibdir %_prefix/lib/NetworkManager

%define _unpackaged_files_terminate_build 1

Name: NetworkManager
Version: 1.8.9
Release: alt1.M80P.2%git_hash
License: %gpl2plus
Group: System/Configuration/Networking
Summary: Install NetworkManager daemon and plugins
Url: http://www.gnome.org/projects/NetworkManager/
# git://git.freedesktop.org/git/NetworkManager/NetworkManager.git
Source: %name-%version.tar
Source1: %name.conf
Source2: 50-ntpd
Source5: 20-hostname
Source6: NetworkManager.sysconfig
Source7: 30-efw
Source8: 80-etcnet-iface-scripts
Source9: NetworkManager-prestart
Source10: nm-dispatcher-sh-functions
Source11: NetworkManager.init
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

# For tests
BuildPreReq: dbus dhcpcd dhcp-client
BuildRequires: python3-module-pygobject3 python-module-dbus

BuildPreReq: intltool libgcrypt-devel libtool
BuildRequires: glibc-devel-static iproute2 libnl-devel libwireless-devel ppp-devel
BuildRequires: libdbus-glib-devel >= %libdbus_glib_version
BuildRequires: libpolkit1-devel libnss-devel libgio-devel libuuid-devel gtk-doc perl-YAML
BuildRequires: libudev-devel
BuildRequires: libgnome-bluetooth-devel
BuildRequires: iptables
BuildRequires: libmm-glib-devel
BuildRequires: libndp-devel
BuildRequires: libreadline-devel
BuildRequires: libaudit-devel
BuildRequires: libcurl-devel libpsl-devel
%{?_enable_teamdctl:BuildRequires: libteam-devel libjansson-devel}
%{?_enable_nmtui:BuildRequires: libnewt-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgudev-gir-devel}
%{?_enable_systemd:BuildRequires: systemd-devel libsystemd-login-devel}
%{?_enable_bluez5dun:BuildRequires: libbluez-devel}
%{?_enable_vala:BuildRequires: vala-tools}
# For create-exports-NetworkManager.sh
BuildRequires: /proc

Requires: nm-dhcp-client
Requires: dnsmasq

Requires: %name-adsl = %version-%release
Requires: %name-bluetooth = %version-%release
Requires: %name-wifi = %version-%release
Requires: %name-wwan = %version-%release
Requires: %name-ppp = %version-%release

Provides: network-config-subsystem

%description
NetworkManager is a system service that manages network interfaces and
connections based on user or automatic configuration. It supports
Ethernet, Bridge, Bond, VLAN, Team, InfiniBand, Wi-Fi, mobile broadband
(WWAN), PPPoE and other devices, and supports a variety of different VPN
services.

This is virtual package for install NetworkManager daemon
and all its plugins (excluding VPN plugins).

%package daemon
License: %gpl2plus
Group: System/Configuration/Networking
Summary: Network Link Manager and User Applications
Requires: dbus >= %dbus_version
Requires: iproute2 openssl
Requires: nss >= 3.11.7
Requires: openresolv >= %openresolv_version
Requires: openresolv-dnsmasq >= %openresolv_version
Requires: libshell

Conflicts: NetworkManager-vpnc < 1.1.90
Conflicts: NetworkManager-openvpn < 1.1.90
Conflicts: NetworkManager-pptp < 1.1.90
Conflicts: NetworkManager-openconnect < 1.1.90
Conflicts: NetworkManager-l2tp < 1.1.0
Conflicts: NetworkManager-ssh < 1.1.0
Conflicts: NetworkManager-gnome < 1.1.90

Conflicts: dhcpcd < %dhcpcd_version

Obsoletes: nmcli

%description daemon
NetworkManager is a system service that manages network interfaces and
connections based on user or automatic configuration. It supports
Ethernet, Bridge, Bond, VLAN, Team, InfiniBand, Wi-Fi, mobile broadband
(WWAN), PPPoE and other devices, and supports a variety of different VPN
services.

This package contents NetworkManager daemon itself and other
utilities.

%package adsl
Summary: ADSL device plugin for NetworkManager
Group: System/Configuration/Networking
Requires: ppp-pppoe
Requires: %_name = %version-%release
Requires: %name-ppp = %version-%release

%description adsl
This package contains NetworkManager support for ADSL devices.

%package bluetooth
Summary: Bluetooth device plugin for NetworkManager
Group: System/Configuration/Networking
Requires: %_name = %version-%release
Requires: %name-wwan = %version-%release

%description bluetooth
This package contains NetworkManager support for Bluetooth devices.

%package wifi
Summary: Wifi plugin for NetworkManager
Group: System/Configuration/Networking
Requires: wpa_supplicant >= %wpa_supplicant_version
Requires: %_name = %version-%release

%description wifi
This package contains NetworkManager support for Wifi and OLPC devices.

%package wwan
Summary: Mobile broadband device plugin for NetworkManager
Group: System/Configuration/Networking
Requires: ModemManager >= 0.7
Requires: %_name = %version-%release

%description wwan
This package contains NetworkManager support for mobile broadband (WWAN) devices.

%package ppp
Summary: PPP plugin for NetworkManager
Group: System/Configuration/Networking
Requires: %_name = %version-%release
Requires: ppp = %ppp_version

%description ppp
This package contains NetworkManager support for PPP.

%package tui
License: %gpl2plus
Summary: Curses-based Text User Interface for NetworkManager
Group: System/Configuration/Networking
Requires: %_name = %version-%release

%description tui
%summary

%package devel
License: %gpl2plus
Summary: Libraries and headers for adding NetworkManager support to applications
Group: Development/Other
Requires: libdbus-glib >= %libdbus_glib_version
Requires: libdbus-devel >= %dbus_version
Requires: pkgconfig

%description devel
This package contains various headers accessing some NetworkManager
functionality from applications.

%package -n libnm
License: %gpl2plus
Summary: Library for adding NetworkManager support to applications
Group: System/Libraries

%description -n libnm
This package contains the libraries that make it easier to use some
NetworkManager functionality from applications.

%package -n %libnm_glib
License: %gpl2plus
Summary: Library for adding NetworkManager support to applications that use glib
Group: System/Libraries
Requires: dbus >= %dbus_version
Obsoletes: NetworkManager-glib < 0.9.10.0

%description -n %libnm_glib
This package contains the library that applications can use to query
connection status via NetworkManager.

%package -n %libnm_glib_vpn
License: %gpl2plus
Summary: Library for creating VPN connections via NetworkManager
Group: System/Libraries
Requires: dbus >= %dbus_version
Obsoletes: NetworkManager-glib < 0.9.10.0

%description -n %libnm_glib_vpn
This package contains the library that applications can use for creating
VPN connections via NetworkManager.

%package -n %libnm_util
License: %gpl2plus
Summary: A convenience library to ease the access to NetworkManager.
Group: System/Libraries
Requires: dbus >= %dbus_version
Obsoletes: NetworkManager-glib < 0.9.10.0

%description -n %libnm_util
This package contains a convenience library to ease the access to
NetworkManager.

%package glib-devel
Summary: Header files for adding NetworkManager support to applications that use glib.
Group: Development/GNOME and GTK+
Requires: libnm-glib-devel libnm-glib-vpn-devel libnm-util-devel
BuildArch: noarch

%description glib-devel
Virtual package for backward compatibility.
Deprecated and will be removed soon.

%package -n libnm-devel
Summary: Header files for adding NetworkManager support to applications.
Group: Development/C
Requires: glib2-devel
Requires: pkgconfig
Requires: libdbus-glib-devel >= %libdbus_glib_version
Requires: libnm = %version-%release

%description -n libnm-devel
This package contains the header and pkg-config files for development
applications using NetworkManager functionality.

%package -n libnm-glib-devel
Summary: Header files for adding NetworkManager support to applications that use glib.
Group: Development/C
Requires: %name-devel = %version-%release
Requires: libnm-util-devel = %version-%release
Requires: glib2-devel
Requires: pkgconfig
Requires: libdbus-glib-devel >= %libdbus_glib_version
Requires: %libnm_glib = %version-%release

%description -n libnm-glib-devel
This package contains the header and pkg-config files for development
applications that can to query connection status via NetworkManager.

%package -n libnm-glib-vpn-devel
Summary: Header files for %libnm_glib_vpn
Group: Development/C
Requires: %name-devel = %version-%release
Requires: libnm-glib-devel = %version-%release
Requires: glib2-devel
Requires: pkgconfig
Requires: libdbus-glib-devel >= %libdbus_glib_version
Requires: %libnm_glib_vpn = %version-%release

%description -n libnm-glib-vpn-devel
This package contains the header and pkg-config files for development
applications that can to create VPN connections via NetworkManager.

%package -n libnm-util-devel
Summary: Header files for %libnm_util
Group: Development/C
Requires: %name-devel = %version-%release
Requires: %libnm_util = %version-%release
Requires: glib2-devel
Requires: pkgconfig
Requires: libdbus-glib-devel >= %libdbus_glib_version

%description -n libnm-util-devel
This package contains the header and pkg-config files
for %libnm_util.

%package -n libnm-devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description -n libnm-devel-doc
This package contains development documentation for %name.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
Obsoletes: NetworkManager-glib-devel-doc < 0.9.10.0
Provides: NetworkManager-glib-devel-doc = %version-%release
BuildArch: noarch
Requires: libnm-devel-doc = %version-%release

# No comments
Obsoletes: %name-%name-devel-doc < %version-%release

%description devel-doc
This package contains development documentation for %name.
Includes libnm-util and libnm-glib development documentation.

%package -n libnm-gir
Summary: GObject introspection data for the NetworkManager (libnm)
Group: System/Libraries
Requires: %libnm_glib %libnm_glib_vpn %libnm_util

%description -n libnm-gir
GObject introspection data for the NetworkManager (libnm).

%package -n libnm-gir-devel
Summary: GObject introspection devel data for the NetworkManager (libnm)
Group: System/Libraries
BuildArch: noarch
Requires: %name-glib-gir = %version-%release
Requires: libnm-glib-devel = %version-%release
Requires: libnm-glib-vpn-devel = %version-%release
Requires: libnm-util-devel = %version-%release

%description -n libnm-gir-devel
GObject introspection devel data for the NetworkManager (libnm).

%package glib-gir
Summary: GObject introspection data for the NetworkManager
Group: System/Libraries
Requires: %libnm_glib %libnm_glib_vpn %libnm_util

%description glib-gir
GObject introspection data for the NetworkManager.

%package glib-gir-devel
Summary: GObject introspection devel data for the NetworkManager
Group: System/Libraries
BuildArch: noarch
Requires: %name-glib-gir = %version-%release
Requires: libnm-glib-devel = %version-%release
Requires: libnm-glib-vpn-devel = %version-%release
Requires: libnm-util-devel = %version-%release

%description glib-gir-devel
GObject introspection devel data for the NetworkManager.


%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
	--docdir=%_defaultdocdir/%name-%version \
	--disable-static \
	--with-crypto=nss \
	--with-dhclient=/sbin/dhclient \
	--with-dhcpcd=yes \
	--with-dnsmasq=/usr/sbin/dnsmasq \
	--enable-gtk-doc=yes \
	--with-config-dns-rc-manager-default=resolvconf \
	--with-resolvconf=/sbin/resolvconf \
	--enable-concheck \
	--with-pppd-plugin-dir=%_libdir/pppd/%ppp_version \
	--enable-ppp=yes \
	--with-system-ca-path=/var/lib/ssl/certs \
	--enable-tests=yes \
	%{?_enable_systemd:--with-systemdsystemunitdir=/lib/systemd/system} \
%if_enabled systemd
	--with-session-tracking=systemd \
	--with-suspend-resume=systemd \
	--with-config-logging-backend-default=journal \
%else
	--with-session-tracking=ck \
	--with-suspend-resume=upower \
	--with-config-logging-backend-default=syslog \
%endif
	--with-udev-dir=/lib/udev \
	--enable-polkit=yes \
	--enable-polkit-agent \
	--enable-modify-system=no \
	--enable-etcnet-alt \
	--disable-ifcfg-rh \
	--disable-ifcfg-suse \
	--disable-ifupdown \
	--disable-ifnet \
	--with-config-plugins-default='etcnet-alt,ibft' \
	--with-modem-manager-1 \
	%{subst_enable teamdctl} \
%if_enabled nmtui
	--with-nmtui=yes \
%else
	--with-nmtui=no \
%endif
%if_enabled bluez5dun
	--enable-bluez5-dun \
%else
	--disable-bluez5-dun \
%endif
	--enable-introspection=auto \
	%{subst_enable lto} \
	%{subst_enable vala} \
	--with-libaudit=yes-disabled-by-default \
	--with-ofono=no \
%if_enabled teamdctl
	--enable-json-validation \
%else
	--disable-json-validation \
%endif
	--with-libpsl=yes \
%if_enabled sanitizers
	--enable-address-sanitizer \
	--enable-undefined-sanitizer \
%else
	--disable-address-sanitizer \
	--disable-undefined-sanitizer \
%endif
	--with-dist-version=%version-%release \
	--disable-silent-rules \
	--enable-more-warnings=error

%make_build

# Set charset utf8 for utf8 man page
sed -i '1i .\\" -*- mode: troff; coding: utf8 -*-' man/nmcli-examples.7

%install
%makeinstall_std
%find_lang %name
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_sysconfdir/NetworkManager/VPN
mkdir -p %buildroot%_sysconfdir/NetworkManager/system-connections
mkdir -p %buildroot%_sysconfdir/NetworkManager/conf.d
mkdir -p %buildroot%nmlibdir/conf.d
mkdir -p %buildroot/%_var/log/
touch %buildroot/%_var/log/NetworkManager
mkdir -p %buildroot/%_var/lib/NetworkManager
touch %buildroot/%_var/lib/NetworkManager/timestamps
touch %buildroot/%_var/lib/NetworkManager/NetworkManager.state
mkdir -p %buildroot%nmlibdir/VPN/
install -m 0644 %SOURCE1 %buildroot%_sysconfdir/NetworkManager/
install -m 0755 %SOURCE2 %buildroot%dispatcherdir/
install -m 0755 %SOURCE5 %buildroot%dispatcherdir/
install -m 0755 %SOURCE7 %buildroot%dispatcherdir/
install -m 0755 %SOURCE8 %buildroot%dispatcherdir/
install -Dm0644 %SOURCE6 %buildroot%_sysconfdir/sysconfig/%name

# Create pre-down.d/pre-up.d directories and
# symlink scripts if needed
mkdir -p %buildroot%dispatcherdir/pre-{up,down}.d
ln -s ../80-etcnet-iface-scripts %buildroot%dispatcherdir/pre-up.d/80-etcnet-iface-scripts
ln -s ../80-etcnet-iface-scripts %buildroot%dispatcherdir/pre-down.d/80-etcnet-iface-scripts

# Install initscript
install -Dm0755 %SOURCE11 %buildroot%_initrddir/NetworkManager

# Install NetworkManager pre start script
install -Dm0755 %SOURCE9 %buildroot%_sbindir/NetworkManager-prestart

# Install functions file for nm-dispather scripts
install -Dm0644 %SOURCE10 %buildroot%_libexecdir/NetworkManager/nm-dispatcher-sh-functions

# Install example configs
mkdir -p %buildroot%_defaultdocdir/%name-%version/examples/conf.d/
cp -a examples/nm-conf.d/* %buildroot%_defaultdocdir/%name-%version/examples/conf.d/

# Use 31-mac-addr-change.conf
# See https://bugzilla.altlinux.org/32467
# https://bugzilla.gnome.org/show_bug.cgi?id=777523
mv %buildroot%_defaultdocdir/%name-%version/examples/conf.d/31-mac-addr-change.conf %buildroot%nmlibdir/conf.d/

%check
make check

%pre daemon
# Workaround for upgrade
[ -d %_var/lib/NetworkManager/timestamps ] &&
rm -rf %_var/lib/NetworkManager/timestamps/ ||:

%post daemon
#post_service %name
SYSTEMCTL=systemctl
if sd_booted && "$SYSTEMCTL" --version >/dev/null 2>&1; then
	"$SYSTEMCTL" daemon-reload ||:
	if [ "$1" -eq 1 ]; then
		"$SYSTEMCTL" -q preset %name.service %name-wait-online.service %name-dispatcher.service ||:
	fi
else
	if [ "$1" -eq 1 ]; then
		/sbin/chkconfig --add NetworkManager ||:
	else
		/sbin/chkconfig NetworkManager resetpriorities ||:
	fi
fi

%preun daemon
#preun_service %name
if [ "$1" -eq 0 ]; then
	SYSTEMCTL=systemctl
	if sd_booted && "$SYSTEMCTL" --version >/dev/null 2>&1; then
		"$SYSTEMCTL" --no-reload -q disable %name.service %name-wait-online.service %name-dispatcher.service ||:
	else
		chkconfig --del NetworkManager ||:
	fi

    killall -TERM nm-system-settings >/dev/null 2>&1 ||:
fi

%triggerpostun daemon -- %name <= 0.9.8.2-alt3
SYSTEMCTL=systemctl
if sd_booted && "$SYSTEMCTL" -q is-enabled %name.service; then
	"$SYSTEMCTL" enable -q %name-dispatcher.service
fi

%files

%files -f %name.lang daemon
%doc COPYING NEWS AUTHORS README CONTRIBUTING TODO
%_bindir/nm-online
%_bindir/nmcli
%_datadir/dbus-1/system-services/*.service
%doc %_man1dir/*.*
%doc %_man5dir/*.*
%doc %_man7dir/*.*
%doc %_man8dir/*.*
%doc %_defaultdocdir/%name-%version/
%dir %_libexecdir/NetworkManager/
%dir %_libdir/NetworkManager/
%dir %nmlibdir/
%dir %nmlibdir/VPN/
%_libdir/NetworkManager/libnm-settings-plugin-*.so
%_libexecdir/NetworkManager/nm-*
%_sbindir/*
%_sysconfdir/dbus-1/system.d/*.conf
%config(noreplace) %_sysconfdir/NetworkManager/%name.conf
%_initrddir/NetworkManager
%dir %_sysconfdir/NetworkManager
%dir %_sysconfdir/NetworkManager/VPN
%dir %_sysconfdir/NetworkManager/system-connections
%dir %_sysconfdir/NetworkManager/conf.d
%dir %nmlibdir/conf.d/
%config %nmlibdir/conf.d/31-mac-addr-change.conf
%dir %_var/lib/NetworkManager
%dispatcherdir/
%ghost %config(noreplace) %_var/log/NetworkManager
%ghost %config(noreplace) %_var/lib/NetworkManager/NetworkManager.state
%ghost %config(noreplace) %_var/lib/NetworkManager/timestamps
/lib/udev/rules.d/*
%_datadir/polkit-1/actions/*.policy
%_datadir/bash-completion/completions/*
%config(noreplace) %_sysconfdir/sysconfig/%name
%{?_enable_systemd:/lib/systemd/system/%name.service}
%{?_enable_systemd:/lib/systemd/system/%name-wait-online.service}
%{?_enable_systemd:/lib/systemd/system/%name-dispatcher.service}

%exclude %_man1dir/nmtui*

%files adsl
%_libdir/%name/libnm-device-plugin-adsl.so

%files bluetooth
%_libdir/%name/libnm-device-plugin-bluetooth.so

%files wifi
%_libdir/%name/libnm-device-plugin-wifi.so

%files wwan
%_libdir/%name/libnm-device-plugin-wwan.so
%_libdir/%name/libnm-wwan.so

%if_enabled nmtui
%files tui
%_bindir/nmtui*
%_man1dir/nmtui*
%endif

%files ppp
%_libdir/pppd/%ppp_version/nm-pppd-plugin.so
%_libdir/%name/libnm-ppp-plugin.so

%files devel
%dir %_includedir/%name
%_includedir/%name/%name.h
%_includedir/%name/NetworkManagerVPN.h
%_includedir/%name/nm-version-macros.h
%_includedir/%name/nm-version.h
%_pkgconfigdir/%name.pc

%files -n libnm
%_libdir/libnm.so.*

%files -n %libnm_glib
%_libdir/libnm-glib.so.%nm_glib_sover
%_libdir/libnm-glib.so.%nm_glib_sover.*

%files -n %libnm_glib_vpn
%_libdir/libnm-glib-vpn.so.%nm_glib_vpn_sover
%_libdir/libnm-glib-vpn.so.%nm_glib_vpn_sover.*

%files -n %libnm_util
%_libdir/libnm-util.so.%nm_util_sover
%_libdir/libnm-util.so.%nm_util_sover.*

%files glib-devel

%files -n libnm-devel
%_includedir/libnm
%_pkgconfigdir/libnm.pc
%_libdir/libnm.so
%{?_enable_vala:%_vapidir/libnm.*}
%_datadir/dbus-1/interfaces/*.xml

%files -n libnm-glib-devel
%_includedir/libnm-glib
%exclude %_includedir/libnm-glib/nm-vpn-*.h
%_pkgconfigdir/libnm-glib.pc
%_libdir/libnm-glib.so
%{?_enable_vala:%_vapidir/libnm-glib.*}

%files -n libnm-glib-vpn-devel
%_includedir/libnm-glib/nm-vpn-*.h
%_pkgconfigdir/libnm-glib-vpn.pc
%_libdir/libnm-glib-vpn.so

%files -n libnm-util-devel
%_includedir/%name/nm-setting*.h
%_includedir/%name/nm-connection.h
%_includedir/%name/nm-utils*.h
%_pkgconfigdir/libnm-util.pc
%_libdir/libnm-util.so
%{?_enable_vala:%_vapidir/libnm-util.*}

%files -n libnm-devel-doc
%doc %_datadir/gtk-doc/html/libnm

%files devel-doc
%doc %_datadir/gtk-doc/html/%name
%doc %_datadir/gtk-doc/html/libnm-glib
%doc %_datadir/gtk-doc/html/libnm-util

%if_enabled introspection
%files -n libnm-gir
%_libdir/girepository-1.0/NM-1.0.typelib

%files -n libnm-gir-devel
%_datadir/gir-1.0/NM-1.0.gir

%files glib-gir
%_libdir/girepository-1.0/NMClient-1.0.typelib
%_libdir/girepository-1.0/NetworkManager-1.0.typelib

%files glib-gir-devel
%_datadir/gir-1.0/NMClient-1.0.gir
%_datadir/gir-1.0/NetworkManager-1.0.gir
%endif

%exclude %_libdir/NetworkManager/*.la
%exclude %_libdir/pppd/%ppp_version/*.la

%changelog
