%define nm_version 1.4.1-alt1.git20160914
#define git_date .git20170703
%define git_date %nil

%define _unpackaged_files_terminate_build 1

%def_without appindicator
%def_without team
%def_without selinux
%def_with gcr

Name: NetworkManager-applet-gtk
Version: 1.8.4
Release: alt0.M80P.1%git_date
License: %gpl2plus
Group: Graphical desktop/GNOME
Summary: Panel applet for use with NetworkManager
Url: http://www.gnome.org/projects/NetworkManager/
# Upstream: git://git.gnome.org/network-manager-applet
Source: nm-applet-%version.tar
Patch: nm-applet-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

BuildPreReq: libdbus-devel libdbus-glib libgtk+3-devel intltool libtool libpolkit1-devel

BuildRequires: libwireless-devel
BuildRequires: libnotify-devel
BuildRequires: NetworkManager-devel >= %nm_version
BuildRequires: libnm-util-devel >= %nm_version
BuildRequires: libnm-glib-devel >= %nm_version
BuildRequires: libnm-glib-vpn-devel >= %nm_version
BuildRequires: NetworkManager-glib-gir-devel >= %nm_version
BuildRequires: libnm-devel >= %nm_version
BuildRequires: libnm-gir-devel >= %nm_version
BuildRequires: iso-codes-devel
BuildRequires: gnome-common
BuildRequires: libgudev-devel
BuildRequires: libmm-glib-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
BuildRequires: libsecret-devel
BuildRequires: gtk-doc
%{?_with_appindicator:BuildRequires: libappindicator-gtk3-devel}
%{?_with_team:BuildRequires: libjansson-devel}
%{?_with_selinux:BuildRequires: libselinux-devel}
%{?_with_gcr:BuildRequires: gcr-libs-devel}

Requires: NetworkManager-daemon >= %nm_version
Requires: dbus-tools-gui
Requires: mobile-broadband-provider-info
#Requires: polkit-gnome
Requires: iso-codes

Obsoletes: NetworkManager-gnome < 0.9.8.4
Provides: NetworkManager-gnome = %version-%release

%description
This package contains GNOME utilities and applications for use with
NetworkManager, including a panel applet for wireless networks.

%package -n libnm-gtk
License: %gpl2plus
Group: Graphical desktop/GNOME
Summary: Private libraries for NetworkManager GUI support (libnm-glib version)

%description -n libnm-gtk
This package contains private libraries to be used only by nm-applet and
the GNOME Control Center.

This library will be obsolete by libnma in the future.

%package -n libnm-gtk-devel
License: %gpl2plus
Group: Development/GNOME and GTK+
Summary: Private header files for NetworkManager GUI support (libnm-glib version)
Requires: libnm-gtk = %version-%release
Requires: libnm-util-devel >= %nm_version
Requires: libnm-glib-devel >= %nm_version
Requires: libnm-glib-vpn-devel >= %nm_version
Requires: libgtk+3-devel

%description -n libnm-gtk-devel
This package contains private header and pkg-config files to be used
only by nm-applet and the GNOME control center.

This library will be obsolete by libnma in the future.

%package -n libnm-gtk-gir
License: %gpl2plus
Group: System/Libraries
Summary: GObject introspection data for the libnm-gtk
Requires: libnm-gtk = %version-%release

%description -n libnm-gtk-gir
GObject introspection data for the libnm-gtk.

%package -n libnm-gtk-gir-devel
License: %gpl2plus
Group: System/Libraries
Summary: GObject introspection devel data for the libnm-gtk
BuildArch: noarch
Requires: libnm-gtk-gir = %version-%release
Requires: libnm-gtk-devel = %version-%release

%description -n libnm-gtk-gir-devel
GObject introspection devel data for the libnm-gtk.

%package -n libnma
License: %gpl2plus
Group: Graphical desktop/GNOME
Summary: Private libraries for NetworkManager GUI support (libnm version)

%description -n libnma
This package contains private libraries to be used only by nm-applet and
the GNOME Control Center.

%package -n libnma-devel
License: %gpl2plus
Group: Development/GNOME and GTK+
Summary: Private header files for NetworkManager GUI support (libnm version)
Requires: libnma = %version-%release
Requires: libnm-devel >= %nm_version
Requires: libgtk+3-devel

%description -n libnma-devel
This package contains private header and pkg-config files to be used
only by nm-applet and the GNOME control center.

%package -n libnma-gir
License: %gpl2plus
Group: System/Libraries
Summary: GObject introspection data for the libnma
Requires: libnma = %version-%release

%description -n libnma-gir
GObject introspection data for the libnma.

%package -n libnma-gir-devel
License: %gpl2plus
Group: System/Libraries
Summary: GObject introspection devel data for the libnma
BuildArch: noarch
Requires: libnma-gir = %version-%release
Requires: libnma-devel = %version-%release

%description -n libnma-gir-devel
GObject introspection devel data for the libnma.

%package -n libnma-devel-doc
Summary: Development documentation for libnma-devel-doc
Group: Development/Documentation
BuildArch: noarch

%description -n libnma-devel-doc
This package contains development documentation for libnma-devel-doc.

%prep
%setup -n nm-applet-%version
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
	%{subst_with selinux} \
	%{subst_with gcr} \
	--with-wwan \
	%{subst_with appindicator} \
	%{subst_with team} \
	--enable-introspection \
	--with-libnm-gtk \
	--enable-gtk-doc \
	--enable-more-warnings=error

%make_build

%install
%makeinstall_std
%find_lang nm-applet

# For VPN plugins
mkdir -p %buildroot/%_datadir/gnome-vpn-properties

%check
make check

%files -f nm-applet.lang
%_bindir/*
%_iconsdir/hicolor/*/apps/*
%_sysconfdir/xdg/autostart/nm-applet.desktop
%_datadir/GConf/gsettings/nm-applet.convert
%_datadir/glib-2.0/schemas/org.gnome.nm-applet.gschema.xml
%doc %_man1dir/*.*

%_datadir/applications/*.desktop
%_datadir/appdata/*.xml
%dir %_datadir/gnome-vpn-properties

%files -n libnm-gtk
%_libdir/libnm-gtk.so.*

%files -n libnm-gtk-devel
%_includedir/libnm-gtk/
%_libdir/libnm-gtk.so
%_pkgconfigdir/libnm-gtk.pc

%files -n libnm-gtk-gir
%_libdir/girepository-1.0/NMGtk-1.0.typelib

%files -n libnm-gtk-gir-devel
%_datadir/gir-1.0/NMGtk-1.0.gir

%files -n libnma
%_libdir/libnma.so.*

%files -n libnma-devel
%_includedir/libnma/
%_libdir/libnma.so
%_pkgconfigdir/libnma.pc

%files -n libnma-gir
%_libdir/girepository-1.0/NMA-1.0.typelib

%files -n libnma-gir-devel
%_datadir/gir-1.0/NMA-1.0.gir

%files -n libnma-devel-doc
%doc %_datadir/gtk-doc/html/libnma

%changelog
