%define nm_version 1.1.90
%define nm_applet_version 1.1.90
%define nm_applet_name NetworkManager-applet-gtk
%define git_date %nil
#define git_date .git20111101

%def_with libnm_glib

%define _unpackaged_files_terminate_build 1

%ifarch e2k
%define more_warnings no
%else
%define more_warnings error
%endif

Name: NetworkManager-openvpn
Version: 1.8.0
Release: alt0.M80P.1%git_date
License: %gpl2plus
Group: System/Configuration/Networking
Summary: NetworkManager VPN plugin for OpenVPN
Url: http://www.gnome.org/projects/NetworkManager
# git://git.gnome.org/network-manager-openvpn
Source0: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

BuildRequires: intltool
BuildRequires: NetworkManager-devel >= %nm_version
BuildRequires: libnm-devel >= %nm_version
BuildRequires: libnma-devel >= %nm_applet_version
%if_with libnm_glib
BuildRequires: libnm-glib-vpn-devel >= %nm_version
BuildRequires: libnm-gtk-devel >= %nm_applet_version
%endif
BuildRequires: libgtk+3-devel
BuildRequires: libsecret-devel

Requires: NetworkManager-daemon   >= %nm_version
Requires: openvpn          >= 2.1

%description
NetworkManager-openvpn provides VPN support to NetworkManager for
OpenVPN.

%package gtk
License: %gpl2plus
Summary: Applications for use %name with %nm_applet_name
Group: Graphical desktop/GNOME
Requires: %nm_applet_name >= %nm_applet_version
Requires: NetworkManager-openvpn = %version-%release

Obsoletes: %name-gnome < 0.9.8.4
Provides: %name-gnome = %version-%release

%description gtk
This package contains applications for use with
NetworkManager panel applet.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
%if_without libnm_glib
	--without-libnm-glib \
%endif
	--disable-silent-rules \
	--enable-more-warnings=%more_warnings
%make_build

%install
%makeinstall_std
%find_lang %name

%check
make check

%files
%doc AUTHORS README
%_libexecdir/NetworkManager/nm-openvpn-service
%_libexecdir/NetworkManager/nm-openvpn-service-openvpn-helper
%_libdir/NetworkManager/libnm-vpn-plugin-openvpn.so
%config %_sysconfdir/dbus-1/system.d/nm-openvpn-service.conf
%if_with libnm_glib
%config %_sysconfdir/NetworkManager/VPN/nm-openvpn-service.name
%endif
%config %_libexecdir/NetworkManager/VPN/nm-openvpn-service.name

%files gtk -f %name.lang
%if_with libnm_glib
%_libdir/NetworkManager/libnm-openvpn-properties.so*
%endif
%_libexecdir/NetworkManager/nm-openvpn-auth-dialog
%_libdir/NetworkManager/libnm-vpn-plugin-openvpn-editor.so
%_datadir/appdata/*.xml

%exclude %_libdir/NetworkManager/*.la

%changelog
