%define nm_version 1.1.90
%define nm_applet_version 1.1.90
%define nm_applet_name NetworkManager-applet-gtk
%define git_date %nil
#define git_date .git20151024

%def_with libnm_glib

%define _unpackaged_files_terminate_build 1

Name: NetworkManager-ssh
Version: 1.2.6
Release: alt0.M80P.1%git_date
License: %gpl2plus
Group: System/Configuration/Networking
Summary: NetworkManager VPN plugin for SSH
Url: https://github.com/danfruehauf/NetworkManager-ssh
# git:git://github.com/danfruehauf/NetworkManager-ssh.git
Source0: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

BuildRequires: intltool
BuildRequires: NetworkManager-devel >= %nm_version
BuildRequires: libnm-devel >= %nm_version
BuildRequires: libnma-devel >= %nm_applet_version
%if_with libnm_glib
BuildRequires: libnm-glib-vpn-devel >= %nm_version
BuildRequires: libnm-gtk-devel >= %nm_applet_version
%endif
BuildRequires: libgtk+3-devel
BuildRequires: libsecret-devel

Requires: NetworkManager-daemon   >= %nm_version
Requires: openssh

%description
This package contains software for integrating VPN capabilities with
the OpenSSH server with NetworkManager.

%package gtk
License: %gpl2plus
Summary: Applications for use %name with %nm_applet_name
Group: Graphical desktop/GNOME
Requires: %nm_applet_name >= %nm_applet_version
Requires: %name = %version-%release

Obsoletes: %name-gnome < 0.9.1-alt2
Provides: %name-gnome = %version-%release

%description gtk
This package contains applications for use with
NetworkManager panel applet.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
%if_without libnm_glib
	--without-libnm-glib \
%endif
	--disable-silent-rules \
	--enable-more-warnings=error
%make_build

%install
%makeinstall_std
%find_lang %name

%check
make check

%files
%doc AUTHORS README README.md
%_libexecdir/NetworkManager/nm-ssh-service
%config %_sysconfdir/dbus-1/system.d/nm-ssh-service.conf
%if_with libnm_glib
%config %_sysconfdir/NetworkManager/VPN/nm-ssh-service.name
%endif
%config %_libexecdir/NetworkManager/VPN/nm-ssh-service.name

%files gtk -f %name.lang
%if_with libnm_glib
%_libdir/NetworkManager/libnm-ssh-properties.so
%endif
%_libexecdir/NetworkManager/nm-ssh-auth-dialog
%_datadir/gnome-vpn-properties/*
%_libdir/NetworkManager/libnm-vpn-plugin-ssh.so
%_datadir/appdata/*.xml

%exclude %_libdir/NetworkManager/*.la

%changelog
