%define nm_version 1.1.90
%define nm_applet_version 1.1.90
%define nm_applet_name NetworkManager-applet-gtk
%define git_date %nil
#define git_date .git20110510

%def_with libnm_glib

%define _unpackaged_files_terminate_build 1

Name: NetworkManager-vpnc
Version: 1.2.4
Release: alt1%git_date
License: %gpl2plus
Group: System/Configuration/Networking
Summary: NetworkManager VPN plugin for vpnc
Url: http://www.gnome.org/projects/NetworkManager/
# git://git.gnome.org/network-manager-vpnc
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

BuildRequires: NetworkManager-devel >= %nm_version
BuildRequires: libnm-devel >= %nm_version
BuildRequires: libnma-devel >= %nm_applet_version
%if_with libnm_glib
BuildRequires: libnm-glib-vpn-devel >= %nm_version
BuildRequires: libnm-gtk-devel >= %nm_applet_version
%endif
BuildRequires: libgtk+3-devel
BuildRequires: libsecret-devel
BuildRequires: intltool gettext

Requires: NetworkManager-daemon   >= %nm_version
Requires: vpnc             >= 0.4

%description
This package contains software for integrating the vpnc VPN software
with NetworkManager and the GNOME desktop

%package gtk
License: %gpl2plus
Summary: Applications for use %name with %nm_applet_name
Group: Graphical desktop/GNOME
Requires: %nm_applet_name >= %nm_applet_version
Requires: NetworkManager-vpnc = %version-%release

Obsoletes: %name-gnome < 0.9.8.6
Provides: %name-gnome = %version-%release

%description gtk
This package contains applications for use with
NetworkManager panel applet.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
%if_without libnm_glib
	--without-libnm-glib \
%endif
	--enable-more-warnings=yes
%make_build

%install
%makeinstall_std
%find_lang %name

%check
make check

%files
%doc AUTHORS
%config %_sysconfdir/dbus-1/system.d/nm-vpnc-service.conf
%_libexecdir/NetworkManager/nm-vpnc-service
%_libexecdir/NetworkManager/nm-vpnc-service-vpnc-helper
%_libdir/NetworkManager/libnm-vpn-plugin-vpnc.so
%if_with libnm_glib
%config %_sysconfdir/NetworkManager/VPN/nm-vpnc-service.name
%endif
%config %_libexecdir/NetworkManager/VPN/nm-vpnc-service.name

%files gtk -f %name.lang
%if_with libnm_glib
%_libdir/NetworkManager/libnm-vpnc-properties.so
%endif
%_libexecdir/NetworkManager/nm-vpnc-auth-dialog
%_datadir/gnome-vpn-properties/*
%_libdir/NetworkManager/libnm-vpn-plugin-vpnc-editor.so
%_datadir/appdata/*.xml

%exclude %_libdir/NetworkManager/*.la

%changelog
