Name: ORBit
Version: 0.5.17
Release: alt3.qa4.1

Summary: High-performance CORBA Object Request Broker
License: LGPL/GPL
Group: System/Libraries
Url: http://orbit-resource.sourceforge.net/

Source: %url/%name-%version.tar.bz2
Patch0: %name-0.5.5-texinfo.patch
Patch1: %name-%version-libs-alt.patch
Patch2: %name-0.5.17-alt-libpopt.patch

Prefix: %prefix

Requires: lib%name = %version-%release

# Automatically added by buildreq on Sun Nov 10 2002
BuildRequires: flex glib-devel glibc-devel libwrap-devel

BuildPreReq: libpopt-devel
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
%name is a high-performance CORBA ORB (object request broker).
It allows programs to send requests and  receive replies from
other programs, regardless of the locations of the two programs.
ORBit features CORBA bindings for the C language.

You will need to install this package and the related header files,
libraries and utilities if you want to write programs that use CORBA
technology.

%package -n lib%name
Summary: Libraries for %name
Group: System/Libraries

%description -n lib%name
%name is a high-performance CORBA ORB (object request broker).
It allows programs to send requests and  receive replies from
other programs, regardless of the locations of the two programs.

This package contains the shared libraries required for ORBit
and components using it to function.

%package devel
Summary: Development libraries, header files and utilities for %name
Group: Development/GNOME and GTK+
Requires: %name = %version-%release, glib-devel, indent
Provides: lib%name-devel = %version
Obsoletes: lib%name-devel
Conflicts: lib%name-devel-static <= 0.5.11-alt1
# indent is called by orbit-idl

%description devel
%name is a high-performance CORBA ORB (object request broker).
It allows programs to send requests and  receive replies from
other programs, regardless of the locations of the two programs.

This package contains the header files, libraries and utilities
necessary to write programs that use CORBA technology.

%package devel-static
Summary: Development static libraries for %name
Group: Development/GNOME and GTK+
Requires: %name-devel = %version-%release
Provides: lib%name-devel-static = %version
Obsoletes: lib%name-devel-static

%description devel-static
%name is a high-performance CORBA ORB (object request broker).
It allows programs to send requests and  receive replies from
other programs, regardless of the locations of the two programs.

This package contains the static libraries necessary to write
statically linked programs that use CORBA technology.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p2
touch .now
find -type f -newer .now -print0 |xargs -r0 touch
rm -f .now
%set_automake_version 1.4
#needed by patch #1
automake

%build
%add_optflags -fno-strict-aliasing
%configure
rm -fR popt
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
export LD_LIBRARY_PATH=$PWD/libIDL/.libs
#NO SMP
%make

%install
mkdir -p $RPM_BUILD_ROOT%prefix
%makeinstall

%files
%doc AUTHORS NEWS README TODO
%_bindir/*-server
%_bindir/name-client
%_bindir/orbit-ird
%_bindir/ior-decode
%_datadir/idl/*

%files -n lib%name
%_libdir/*.so.*

%files devel
%_bindir/orbit-idl
%_bindir/*-config
%_libdir/*.sh
%_libdir/*.so
%_libdir/libname-server.a
%_libdir/liborbit-c-backend.a
%_libdir/pkgconfig/*
%_includedir/*
%_infodir/*.info*
%_datadir/aclocal/*
%doc ChangeLog docs/*.txt docs/IDEA1

%files devel-static
%_libdir/libIDL.a
%_libdir/libIIOP.a
%_libdir/libORBit*.a

%changelog
