# vim: set ft=spec: -*- rpm-spec -*-

Name: PokerTH
Version: 1.1.1
Release: alt3

Summary: Texas Hold'em poker game
Group: Games/Cards
License: %gagpl3plus
Url: http://www.pokerth.net/

Source: %name-%version.tar
Patch: %name-%version-%release.patch

# Patches form Fedora spec
# (upstream patches actually)
# https://github.com/pokerth/pokerth/pull/299
Patch1:         pokerth-1.1.1-fstream-ambiguity.patch
# https://github.com/zaphoyd/websocketpp/issues/457
Patch2:         pokerth-1.1.1-ownerless.patch
# Upstream patches for C++11 support
Patch3:         pokerth-1.1.1-cxx11-build.patch
Patch4:         pokerth-1.1.1-cxx11-fixes.patch

BuildRequires(pre): rpm-build-licenses >= 2.0.5-alt1

BuildRequires: boost-asio-devel boost-filesystem-devel boost-program_options-devel boost-interprocess-devel gcc-c++ libSDL-devel libSDL_mixer-devel libcurl-devel libdb4-devel libgnutls-openssl-devel libgsasl-devel qt5-base-devel

BuildPreReq: libgcrypt-devel zlib-devel libsqlite3-devel phonon-devel tinyxml-devel libircclient-devel libprotobuf-devel
BuildPreReq: protobuf-compiler

Requires: %name-data = %version-%release

%description
PokerTH is a poker game written in C++/Qt5. You can play the popular
"Texas Hold'em" poker variant against up to nine computer-opponents or
play network games with people all over the world.

%package data
Summary: Data files for %name
Group: Games/Cards
BuildArch: noarch

%description data
PokerTH is a poker game written in C++/Qt5. You can play the popular
"Texas Hold'em" poker variant against up to nine computer-opponents or
play network games with people all over the world.

This package contents data files for %name.

%prep
%setup
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build
qmake-qt5 \
	QMAKE_CFLAGS_RELEASE="%optflags" \
	QMAKE_CXXFLAGS_RELEASE="%optflags" \
	pokerth.pro
sed -i 's|-pipe |%optflags -fno-strict-aliasing |g' Makefile*
%make_build

%install
%makeinstall_std INSTALL_ROOT=%buildroot
mkdir -p %buildroot%_bindir
install -pm755 pokerth bin/pokerth_server %buildroot%_bindir

%files
%_bindir/*

%files data
%_datadir/pokerth
%_desktopdir/pokerth.desktop
%_pixmapsdir/pokerth.png

%changelog
