%def_with fcitx
%def_with ibus
%def_with nas
%def_with pulse
%def_disable static

Name: SDL2
Version: 2.0.6
Release: alt3.M80P.1

Summary: Simple DirectMedia Layer
License: zlib
Group: System/Libraries

Url: http://www.libsdl.org/
Packager: Nazarov Denis <nenderus@altlinux.org>

Source: http://www.libsdl.org/release/%name-%version.tar.gz

BuildRequires(pre): rpm-build-ubt

BuildPreReq: libXext-devel
BuildPreReq: libdbus-devel

%{?_with_fcitx:BuildRequires: fcitx-devel}
BuildRequires: gcc-c++
BuildRequires: libGLES-devel
BuildRequires: libXScrnSaver-devel
BuildRequires: libXxf86vm-devel
BuildRequires: libalsa-devel
%{?_with_nas:BuildRequires: libaudio-devel}
BuildRequires: libesd-devel
%{?_with_ibus:BuildRequires: libibus-devel}
%{?_with_pulse:BuildRequires: libpulseaudio-devel}
BuildRequires: libsamplerate-devel
BuildRequires: libudev-devel

%description
This is the Simple DirectMedia Layer, a generic API that provides low
level access to audio, keyboard, mouse, and display framebuffer across
multiple platforms.

%package -n lib%name
Summary: Simple DirectMedia Layer
Group: System/Libraries

%description -n lib%name
This is the Simple DirectMedia Layer, a generic API that provides low
level access to audio, keyboard, mouse, and display framebuffer across
multiple platforms.

%package -n lib%name-devel
Summary: Libraries, includes and more to develop SDL applications.
Group: Development/C
# Since 2.0.5, `sdl2-config --libs` forces new dtags;
# the support for RUNPATH (a new tag) has been added in:
Conflicts: rpm-build < 4.0.4-alt100.96

%description -n lib%name-devel
This is the Simple DirectMedia Layer, a generic API that provides low
level access to audio, keyboard, mouse, and display framebuffer across
multiple platforms.

This is the libraries, include files and other resources you can use
to develop SDL applications.

%if_enabled static
%package -n lib%name-devel-static
Summary: Static libraries to develop SDL applications.
Group: Development/C

%description -n lib%name-devel-static
This is the Simple DirectMedia Layer, a generic API that provides low
level access to audio, keyboard, mouse, and display framebuffer across
multiple platforms.

This is the static libraries you can use to develop SDL applications.
%endif

%prep
%setup

%build
%configure
%make_build

%install
%makeinstall_std
rm -f %buildroot%_libdir/*.la

%files -n lib%name
%doc BUGS.txt COPYING.txt CREDITS.txt INSTALL.txt README*.txt TODO.txt WhatsNew.txt
%_libdir/lib%name-2.0.so.*

%files -n lib%name-devel
%_bindir/sdl2-config
%dir %_includedir/%name
%_includedir/%name/*.h
%_libdir/lib%name.so
%dir %_libdir/cmake
%dir %_libdir/cmake/%name
%_libdir/cmake/%name/sdl2-config.cmake
%_pkgconfigdir/sdl2.pc
%_aclocaldir/sdl2.m4

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib%name*.a
%endif

%changelog
