
%def_disable celt051
%def_enable opus
%def_enable lz4
%def_disable gstreamer
%def_disable manual

Name: SPICE
Version: 0.14.1
Release: alt1
Summary: Implements the SPICE protocol
Group: Graphical desktop/Other
License: LGPLv2+
Url: http://www.spice-space.org/

# VCS: https://gitlab.freedesktop.org/spice/spice.git
Source: %name-%version.tar
Source2: spice-common.tar

BuildRequires: gcc-c++
BuildRequires: libjpeg-devel libpixman-devel >= 0.17.7 zlib-devel
BuildRequires: libssl-devel >= 1.0.0 libsasl2-devel openssl
BuildRequires: libcacard-devel >= 0.1.2
BuildRequires: python-module-six python-module-pyparsing
BuildRequires: glib2-devel >= 2.32 libgio-devel >= 2.32
BuildRequires: spice-protocol >= 0.12.14
%{?_enable_manual:BuildRequires: asciidoc asciidoc-a2x}
%{?_enable_celt051:BuildRequires: libcelt051-devel >= 0.5.1.1}
%{?_enable_opus:BuildRequires: libopus-devel >= 0.9.14}
%{?_enable_lz4:BuildRequires: liblz4-devel}
%{?_enable_gstreamer:BuildRequires: gstreamer1.0-devel gst-plugins1.0-devel gst-plugins1.0-gir-devel}

%description
The Simple Protocol for Independent Computing Environments (SPICE) is
a remote display system built for virtual environments which allows
you to view a computing 'desktop' environment not only on the machine
where it is running, but from anywhere on the Internet and from a wide
variety of machine architectures.

%package -n libspice-server
Summary: Implements the server side of the SPICE protocol
Group: System/Libraries

%description -n libspice-server
The Simple Protocol for Independent Computing Environments (SPICE) is
a remote display system built for virtual environments which allows
you to view a computing 'desktop' environment not only on the machine
where it is running, but from anywhere on the Internet and from a wide
variety of machine architectures.

This package contains the run-time libraries for any application that wishes
to be a SPICE server.

%package -n libspice-server-devel
Summary: Header files, libraries and development documentation for spice-server
Group: Development/C
Requires: libspice-server = %version-%release

%description -n libspice-server-devel
This package contains the header files, static libraries and development
documentation for spice-server. If you like to develop programs
using spice-server, you will need to install spice-server-devel.

%prep
%setup
mkdir -p subprojects
pushd subprojects
tar -xf %SOURCE2
popd
# version in .tarball-version file
echo "%version" > .tarball-version

%build
rm -f GITVERSION
%autoreconf
%configure			\
	%{subst_enable celt051}	\
	%{subst_enable lz4}	\
	--enable-smartcard

%make_build

%install
%make_install install DESTDIR=%buildroot
rm -f %buildroot%_libdir/libspice-server.a
rm -f %buildroot%_libdir/libspice-server.la

%files -n libspice-server
%doc COPYING README NEWS
%_libdir/libspice-server.so.*

%files -n libspice-server-devel
%_includedir/spice-server
%_libdir/libspice-server.so
%_pkgconfigdir/spice-server.pc

%changelog
