%define oname allegro
%define _optlevel 3

%define major 5
%define minor 0
%define bugfix 10
%define sover 5.0
Name: %oname%sover
Version: %major.%minor.%bugfix
Release: alt1

Group: System/Libraries
Summary: Game programming library
License: Giftware 
URL: http://alleg.sourceforge.net
Packager: Repocop Q. A. Robot <repocop@altlinux.org>

Source0: http://sunsite.auc.dk/allegro/%name-%version.tar
Patch0: allegro-4.0.1-allegro.h.patch
Patch1: allegro-4.1.8-allegro.h.patch

Obsoletes: %name

BuildRequires: esound-devel gcc-c++ glib2-devel libalsa-devel 
BuildRequires: libjack-devel libaudiofile-devel pkgconfig cmake
BuildRequires: libX11-devel libGL-devel libGLU-devel libXxf86dga-devel
BuildPreReq: libXtst-devel libXcomposite-devel libXcursor-devel
BuildPreReq: libXft-devel libXi-devel libXinerama-devel libXpm-devel
BuildPreReq: libXrender-devel libXrandr-devel libXt-devel libXv-devel
BuildPreReq: libXxf86misc-devel libICE-devel svgalib-devel /proc
BuildPreReq: libpng-devel zlib-devel libogg-devel libvorbis-devel
BuildPreReq: libXxf86vm-devel libXdamage-devel libXdmcp-devel
BuildPreReq: libXScrnSaver-devel libflac-devel libjpeg-devel
BuildPreReq: libopenal-devel libphysfs-devel dumb-devel
BuildPreReq: libgtk+2-devel libpixman-devel

%package -n lib%name
Group: System/Libraries
Summary: Game programming library

%package -n lib%name-devel
Group: Development/C
Summary: Game programming library development files
Requires: lib%name = %version-%release
Provides: allegro-devel = %version-%release
Obsoletes: allegro-devel

%description
Allegro is a library of functions for use in computer games.

%description -n lib%name
Allegro is a library of functions for use in computer games.

%description -n lib%name-devel
Allegro is a library of functions for use in computer games.

This package contains files needed to build programs using Allegro.

%prep
%setup

%build
mkdir Build
pushd Build

FLAGS="-pthread -fno-strict-aliasing %optflags"
FLAGS="$FLAGS %optflags_shared"
cmake \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix \
	-DCMAKE_CXX_FLAGS:STRING="$FLAGS" \
	-DCMAKE_C_FLAGS:STRING="$FLAGS" \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DWANT_LINUX_CONSOLE:BOOL=ON \
	-DDOCDIR:STRING=share/doc \
	-DCMAKE_STRIP:FILEPATH="/bin/echo" \
%ifarch x86_64
	-DLIB_SUFFIX:STRING=64 \
%endif
	..
%make_build

popd

%install
%makeinstall_std -C Build

install -d %buildroot%_man3dir
install -p -m644 docs/man/* %buildroot%_man3dir

gzip CHANGES*

%files -n lib%name
%doc README.txt CHANGES* LICENSE.txt CONTRIBUTORS.txt
%_libdir/*.so.*

%files -n lib%name-devel
%doc docs/html/refman/*
%_includedir/*
%_libdir/*.so
%_man3dir/*
%_pkgconfigdir/*

%changelog
