Name: alsa-utils
Version: 1.1.0
Release: alt1.1
Serial: 1

Summary: Advanced Linux Sound Architecture (ALSA) utils
License: GPL
Group: System/Kernel and hardware

Url: http://www.alsa-project.org
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: dialog
#Requires: libalsa >= %version
Obsoletes: alsa2-utils < 0.9.4
Provides: alsa2-utils = %version
Conflicts: alsa-utils < 1.0.9a-alt1

BuildRequires: intltool libalsa-devel libncursesw-devel xmlto libfftw3-devel
Requires: libncursesw >= 5.7

%add_findreq_skiplist %_sbindir/alsa-info.sh

%description
Advanced Linux Sound Architecture (ALSA) utils. Modularized
architecture with support for a large range of ISA and PCI cards.
Fully compatible with OSS/Lite but contains many enhanced features.

%package -n aplay
Summary: play utility for ALSA
Group: Sound

%description -n aplay
This package contains minimal client utility for ALSA:
"aplay" is traditional "play" equivalent.

%package -n amixer
Summary: Command-line mixer for ALSA soundcard driver
License: GPL
Group: Sound

%description -n amixer
amixer allows command-line control of the mixer for the ALSA soundcard
driver.  amixer supports multiple soundcards.

%package -n alsa-bat
Summary: Basic Audio Tester
License: GPL
Group: Sound
Conflicts: bacula-bat

%description -n alsa-bat
BAT(Basic Audio Tester) is a simple command-line utility intended
to help automate audio driver and sound server testing with
little human interaction. BAT can be used to test audio quality,
stress test features and test audio before and after PM state
changes.

%prep
%setup
%patch -p1

touch config.rpath

%build
%autoreconf
%configure \
	--with-curses=ncursesw \
	--disable-alsaconf
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang --with-man --output=%name.lang %name

%files -f %name.lang
%doc ChangeLog README
%_bindir/*
%exclude %_bindir/aplay
%exclude %_bindir/arecord
%exclude %_bindir/amixer
%exclude %_bindir/bat
%_sbindir/*
%_datadir/alsa/speaker-test
%_datadir/alsa/init
%_datadir/sounds/alsa
%_man1dir/*.1*
%exclude %_man1dir/aplay.1*
%exclude %_man1dir/arecord.1*
%exclude %_man1dir/amixer.1*
%exclude %_man1dir/bat.1*
%_man7dir/*.7*

%files -n aplay
%_bindir/aplay
%_bindir/arecord
%_man1dir/aplay.1*
%_man1dir/arecord.1*

%files -n amixer
%_bindir/amixer
%_man1dir/amixer.1*

%files -n alsa-bat
%_bindir/bat
%_man1dir/bat.1*

%changelog
