Name: alterator
Version: 4.25
Release: alt1.M80P.4

Summary: ALT Linux configurator engine
License: GPLv2+
Group: System/Configuration/Other
Url: http://wiki.sisyphus.ru/Alterator
Packager: Stanislav Ievlev <inger@altlinux.org>

Source: %name-%version.tar

#backward compatibility
Provides: %name-common = %version , %name-menu = %version, %name-help = %version, %name-sdk = %version, %name-autoinstall = %version
Obsoletes: %name-common, %name-menu, %name-help, %name-sdk, %name-autoinstall

Requires: rpm-macros-%name = %version-%release
Requires: alterator-l10n >= 2.0-alt2
Requires: guile18 >= 1.6.8-alt4

Requires(pre): libguile-vhttpd >= 0.7.3-alt1
Requires(pre): shadow-utils

#incompatibility
Conflicts: alterator-lookout < 1.3-alt13
Conflicts: alterator-fbi < 5.24-alt1
Conflicts: alterator-xkb < 2.0-alt3
Conflicts: alterator-vm <= 0.3-alt31
Conflicts: installer-stage2 <= 0.8-alt1

# Automatically added by buildreq on Fri Dec 29 2006
BuildRequires: guile18-devel libexpat-devel pam_userpass-devel

%define guile_version 1.8

%define _alterator_datadir %_datadir/%name
%define _alterator_libdir %_libexecdir/%name

%add_findreq_skiplist %_alterator_datadir/build/profiles/*
%add_findreq_skiplist %_alterator_datadir/build/xgettext/*
%add_findreq_skiplist %_alterator_datadir/build/msgfmt/*

%description
ALT Linux configurator engine

%package doc
Summary: documentation and samples for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: %name = %version-%release

%description doc
documentation and samples for %name

%package -n rpm-macros-%name
Summary: Set of RPM macros for packaging %name-based applications
Group: Development/Other
BuildArch: noarch
Conflicts: %name < 4.7-alt6

%description -n rpm-macros-%name
Set of RPM macros for packaging %name-based applications for ALT Linux.
Install this package if you want to create RPM packages that use %name.

%prep
%setup

%build
%make_build GUILE_VERSION=%guile_version

%check
%make check-api

%install
%makeinstall GUILE_VERSION=%guile_version unitdir=%buildroot%_unitdir
ln -s ../bin/alterator-cmdline %buildroot%_sbindir/

#create special directories
mkdir -p %buildroot%_runtimedir/alteratord
mkdir -p %buildroot%_cachedir/%name
mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_sysconfdir/%name
mkdir -p %buildroot%_sysconfdir/tmpfiles.d
mkdir -p %buildroot%_rpmmacrosdir

install -Dpm640 alterator-chkpwd.pamd %buildroot%_sysconfdir/pam.d/alterator-chkpwd

cat >%buildroot%_rpmmacrosdir/%name<<EOF
%%_alterator_datadir %%_datadir/%name
%%_alterator_libdir %%_libexecdir/%name

%%_alterator_backend2dir %%_alterator_libdir/backend2
%%_alterator_backend3dir %%_alterator_libdir/backend3
EOF

cat >%buildroot%_sysconfdir/tmpfiles.d/%name.conf<<EOF
d /var/run/alteratord 0710 root _alteratord -
EOF

%pre
/usr/sbin/groupadd -r -f _alteratord

%post
%post_service alteratord

%preun
%preun_service alteratord

%files
%_bindir/*

%dir %_alterator_libdir
%_alterator_libdir/backend3
%attr(700,root,root) %dir %_alterator_libdir/hooks

%_alterator_datadir

%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/menu
%attr(700,root,root) %dir %_cachedir/%name
%attr(700,root,root) %dir %_localstatedir/%name
%_sysconfdir/tmpfiles.d/%name.conf

%_datadir/guile/%guile_version/alterator
%_libdir/*.so.*
%_libdir/libguile*.so

%_sbindir/*
%_initdir/*
%_mandir/man?/*
%attr(710,root,_alteratord) %dir /var/run/alteratord

%_unitdir/alteratord.service
%_unitdir/alteratord.socket

%attr(640,root,root) %_sysconfdir/pam.d/alterator-chkpwd

%files doc
%doc doc/samples doc/internals

%files -n rpm-macros-%name
%_rpmmacrosdir/*

%changelog
