%define _hooksdir %_sysconfdir/hooks/hostname.d

Name: alterator-auth
Version: 0.40
Release: alt0.M80P.2

%filter_from_requires /^samba-common$/d;/systemd-services/d

Source:%name-%version.tar

Summary: Alterator module for system wide auth settings
License: GPL
Group: System/Configuration/Other
Requires: alterator >= 4.7-alt4
Requires: alterator-l10n >= 2.0-alt1
Requires: pam-config >= 1.7.0-alt1
Requires: pam_krb5
Requires: libnss-myhostname
Requires: avahi-daemon
Requires: settime-rfc867
Requires: bind-utils

Conflicts: alterator-fbi < 5.9-alt2
Conflicts: alterator-lookout < 1.6-alt6

Provides: alterator-nsswitch = %version
Obsoletes: alterator-nsswitch

BuildPreReq: alterator alterator-lookout

BuildArch: noarch

%description
Alterator module for system wide auth settings

%package -n task-auth-ad-winbind
Summary: Metapackage to authenticate in Active Directory domain by winbind
Group: System/Configuration/Other
Requires: alterator-auth
Requires: samba-winbind
Requires: samba-winbind-clients
Requires: samba-common-tools
Requires: krb5-kinit
Requires: pam_mount
Requires: libnss-role
Requires: alterator-datetime

%description -n task-auth-ad-winbind
Metapackage to authenticate in Active Directory domain by Winbind.

%package -n task-auth-ad-sssd
Summary: Metapackage to authenticate in Active Directory domain by sssd
Group: System/Configuration/Other
Requires: alterator-auth
Requires: sssd-ad
Requires: samba-common-tools
Requires: krb5-kinit
Requires: pam_mount
Requires: libnss-role
Requires: alterator-datetime

Provides:  task-auth-ad = %EVR
Obsoletes: task-auth-ad < %EVR

%description -n task-auth-ad-sssd
Metapackage to authenticate in Active Directory domain by SSSD.

%package -n task-auth-ldap-sssd
Summary: Metapackage to authenticate in LDAP domain by sssd
Group: System/Configuration/Other
Requires: alterator-auth
Requires: sssd-ldap
Requires: sssd-krb5
Requires: krb5-kinit
Requires: pam_mount
Requires: libnss-role

Provides:  task-auth-ldap = %EVR
Obsoletes: task-auth-ldap < %EVR

%description -n task-auth-ldap-sssd
Metapackage to authenticate in LDAP domain by SSSD.

%package -n task-auth-freeipa
Summary: Metapackage to authenticate in FreeIPA domain
Group: System/Configuration/Other
Requires: alterator-auth
Requires: freeipa-client
Requires: krb5-kinit
Requires: pam_mount
Requires: libnss-role
Requires: alterator-datetime

%description -n task-auth-freeipa
Metapackage to authenticate in FreeIPA domain.

%prep
%setup -q

%build
%make_build libdir=%_libdir

%install
export GUILE_LOAD_PATH=/usr/share/alterator/lookout
%makeinstall
install -Dpm644 etc/user-groups %buildroot%_sysconfdir/alterator/auth/user-groups
install -Dpm644 etc/admin-groups %buildroot%_sysconfdir/alterator/auth/admin-groups
install -Dpm755 sbin/system-auth %buildroot/%_sbindir/system-auth
install -Dpm755 hooks/auth %buildroot/%_hooksdir/90-auth

%files
%config(noreplace) %_sysconfdir/alterator/auth/user-groups
%config(noreplace) %_sysconfdir/alterator/auth/admin-groups
%_alterator_datadir/applications/*
%_alterator_datadir/ui/*/
%_sbindir/system-auth
%_hooksdir/90-auth
%_alterator_backend3dir/*

%files -n task-auth-ad-winbind

%files -n task-auth-ad-sssd

%files -n task-auth-ldap-sssd

%files -n task-auth-freeipa

%changelog
