# -*- mode: RPM-SPEC; tab-width: 8; fill-column: 70; -*- 
# $Id: alterator-control.spec,v 1.15 2006/04/28 10:48:26 inger Exp $ 

%define _altdata_dir %_datadir/alterator

Name: alterator-wizardface
Version: 2.0.1
Release: alt1

Packager: Stanislav Ievlev <inger@altlinux.org>

BuildArch: noarch

Source:%name-%version.tar

#replace previous version in branch
Provides: alterator-wizard = %version
Obsoletes: alterator-wizard

Requires: alterator >= 4.7-alt1 alterator-sh-functions
Requires: alterator-lookout >= 2.1-alt4
Requires: alterator-l10n >= 2.5-alt8
Requires: alterator-browser-qt

%add_findreq_skiplist %_datadir/install2/postinstall.d/*
%add_findreq_skiplist %_datadir/install2/initinstall.d/*

Summary: alterator's wizard like module aggregator
License: GPL
Group: System/Configuration/Other

BuildPreReq: alterator >= 4.7-alt1

# Automatically added by buildreq on Mon Jul 11 2005 (-bi)
BuildRequires: alterator

%description
alterator's wizard like module aggregator

%package usermode
Summary: Usermode bindings for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: %name = %version-%release
Requires: consolehelper

%description usermode
Usermode bindings for %name

%prep
%setup -q

%build
%make_build

%install
%makeinstall

#install consolehelper
obj=alterator-wizard

%__install -d %buildroot/%_bindir
%__ln_s %_libexecdir/consolehelper/helper %buildroot%_bindir/$obj
%__install -d %buildroot%_sysconfdir/pam.d/

cat>%buildroot%_sysconfdir/pam.d/$obj<<EOF
#%PAM-1.0
auth	sufficient	pam_rootok.so
auth	required	pam_stack.so service=system-auth
account	required	pam_permit.so
password	required	pam_deny.so
session	optional	pam_xauth.so
EOF

%__install -d %buildroot%_sysconfdir/security/console.apps/
cat>%buildroot%_sysconfdir/security/console.apps/$obj<<EOF
USER=root
PROGRAM=%_sbindir/$obj
SESSION=true
FALLBACK=true
EOF

%files
%_sbindir/*
%_altdata_dir/ui/wizard/*
%_alterator_backend3dir/*
%_datadir/install2/initinstall.d/*
%_datadir/install2/postinstall.d/*

%files usermode
%config(noreplace) %_sysconfdir/pam.d/*
%config(noreplace) %_sysconfdir/security/console.apps/*
%_bindir/*

%changelog
