%def_with backport
%def_without gnome2
%define gnome3ver 3.90

Name: altlinux-freedesktop-menu
Version: 0.65
%if_without backport
Release: alt1
%else
Release: alt1.M80P.1
%endif

Summary: Implementation of the freedesktop.org menu specification
License: BSD or GPL
Group: Graphical desktop/Other

URL: http://altlinux.org/
Source: %name-%version.tar
Packager: Igor Vlasenko <viy@altlinux.org>

Patch: fix_cinnamon_menu.patch

#BuildPreReq: rpm-build-xdg
BuildRequires: intltool glib2-devel
BuildArch: noarch

%description
altlinux freedesktop.org menu

%package common
Summary: common files for altlinux freedesktop menus
Group: Graphical desktop/Other
Requires(pre): %name-icon-theme
Requires: %name-icon-theme
Requires: wm-common-freedesktop
#Conflicts: altlinux-menus < 0.5.2

%description common
%summary

%package nested-menu
Summary: altlinux freedesktop menu with shallow layout
Group: Graphical desktop/Other
Requires(pre): %name-common
Requires: %name-common
Provides: %name-provider

%description nested-menu
freedesktop.org compliant altlinux menu with nested layout

%package shallow-menu
Summary: altlinux freedesktop menu with shallow layout
Group: Graphical desktop/Other
Requires(pre): %name-common
Requires: %name-common
Provides: %name-provider
Provides: %name-gnomish-menu

%description shallow-menu
freedesktop.org compliant altlinux menu with shallow layout

%package xfce
Summary: xfce freedesktop menu
Group: Graphical desktop/XFce
Provides: xfce-freedesktop-menu
Conflicts: libgarcon-freedesktop-menu
Obsoletes: libgarcon-freedesktop-menu
Requires: %name-provider

%description xfce
ALTLinux freedesktop.org menu for XFCE

%package enlightenment
Summary: Enlightenment freedesktop menu
Group: Graphical desktop/Other
Provides: enlightenment-freedesktop-menu
Requires(pre): %name-provider
Requires: %name-provider

%description enlightenment
ALTLinux freedesktop.org menu for Enlightenment DE

%package lxde
Summary: lxde freedesktop menu
Group: Graphical desktop/Other
Provides: lxde-freedesktop-menu
Conflicts: lxde-lxmenu-data
Obsoletes: lxde-lxmenu-data < 0.2
# specifics of lxde menu migration
Requires(pre): %name-provider
Requires: %name-provider

%description lxde
ALTLinux freedesktop.org menu for LXDE

%package mate
Summary: mate freedesktop menu
Group: Graphical desktop/Other
Provides: mate-freedesktop-menu
Conflicts: mate-menus-default
#Requires: mate-menus-resources
Requires: %name-provider

%description mate
ALTLinux freedesktop.org menu for MATE

%package gnome3
Summary: gnome3 freedesktop menu
Group: Graphical desktop/GNOME
Provides: gnome3-freedesktop-menu
Conflicts: gnome-menus-default
Provides: gnome-menus = %gnome3ver.%version
Obsoletes: gnome-menus-default < %gnome3ver.%version
Requires: %name-provider
#Provides: %name-gnome = %version
Conflicts: %name-gnome < %version
Obsoletes: %name-gnome < %version
Conflicts: libgnome-menus <= 3.8.0-alt1

%description gnome3
ALTLinux freedesktop.org menu for GNOME3

%package cinnamon
Summary: cinnamon freedesktop menu
Group: Graphical desktop/GNOME
Provides: cinnamon-freedesktop-menu
Conflicts: cinnamon <= 1.6.7-alt2
Requires: %name-provider

%description cinnamon
ALTLinux freedesktop.org menu for Cinnamon

%package kde3
Summary: kde3 freedesktop menu
Group: Graphical desktop/KDE
Provides: kde3-freedesktop-menu
Conflicts: kde3-menu-original
Obsoletes: kde3-menu-original
Requires(pre): %name-provider
Requires: %name-provider
Requires: kde3-menu-common
Conflicts: kdelibs <= 3.5.12-alt8

%description kde3
ALTLinux freedesktop.org menu for KDE3

%package kde4
Summary: kde4 freedesktop menu
Group: Graphical desktop/KDE
Provides: kde4-freedesktop-menu = %version
Conflicts: kde4-menu-original
Obsoletes: kde4-menu-original
Requires(pre): %name-provider
Requires: %name-provider
Requires(pre): %name-generic
Requires: %name-generic
#Requires: kde4-menu-common
Conflicts: altlinux-menus
Conflicts: kde4libs <= 4.6.2-alt6
Conflicts: kde4base-runtime-core <= 4.6.2-alt1

%description kde4
ALTLinux freedesktop.org menu for KDE4

%package generic
Summary: generic freedesktop menu
Group: Graphical desktop/Other
Provides: generic-freedesktop-menu
Requires(pre): %name-provider
Requires: %name-provider
Conflicts: altlinux-menus
Conflicts: kde4libs <= 4.6.2-alt6
Conflicts: kde4base-runtime-core <= 4.6.2-alt1

%description generic
ALTLinux freedesktop.org menu for a generic freedesktop-compliant DE

%prep
%setup
%patch -p2

%build
touch AUTHORS ChangeLog NEWS README
intltoolize
%autoreconf 
%configure 
%make_build

%check
cat > ignore.list <<EOF
altlinux-audiovideo-audiovideoediting.directory
altlinux-audiovideo-midi.directory
altlinux-audiovideo-player.directory
altlinux-audiovideo-recorder.directory
altlinux-audiovideo-tuner.directory
altlinux-audiovideo-tv.directory
altlinux-education-construction.directory
altlinux-education-medicalsoftware.directory
altlinux-enlightenment.directory
altlinux-game-roleplaying.directory
altlinux-graphics-rastergraphics.directory
altlinux-java.directory
altlinux-lxde.directory
altlinux-mate.directory
altlinux-network-instantmessaging.directory
altlinux-network-p2p.directory
altlinux-network-telephony.directory
altlinux-network-videoconference.directory
altlinux-office-flowchart.directory
altlinux-science-medicalsoftware.directory
altlinux-settings-java.directory
altlinux-settings-lxde.directory
altlinux-settings-mate.directory
altlinux-settings-xfce.directory
altlinux-xfce.directory
EOF

ok=1
for i in desktop-directories/*.directory; do
    j=`basename $i`
    if ! grep $j ignore.list >/dev/null && ! grep 'Name\[ru\]=' $i >/dev/null; then
    	echo
        echo "$j is not translated - please, update po files"
	echo
	ok=0
    fi
done
rm ignore.list
[ $ok -gt 0 ] || exit 1

%install
%makeinstall_std
install -Dm755 altlinux-freedesktop-menu-post.sh %buildroot%_sbindir/altlinux-freedesktop-menu-post
install -Dm755 altlinux-freedesktop-menu.filetrigger %buildroot%_rpmlibdir/altlinux-freedesktop-menu.filetrigger

ln -s gnome3-applications.menu %buildroot%_sysconfdir/xdg/menus/gnome-applications.menu

mkdir -p %buildroot%_sysconfdir/xdg/menus/{,enlightenment-,gnome-,gnome3-,cinnamon-,kde3-,lxde-,mate-,xfce-}applications-merged
mkdir -p %buildroot%_sysconfdir/xdg/menus/{,mate-}settings-merged

install -D -m644 layout/kde4-merged.menu %buildroot%_sysconfdir/kde4/xdg/menus/applications-merged/50-kde4-merged.menu

install -m0644 altlinux-directories/*.directory %buildroot/%_datadir/desktop-directories/

# alternatives
mkdir -p %buildroot%_altdir
cat <<EOF >>%buildroot%_altdir/%name-nested-menu
%_sysconfdir/xdg/menus/altlinux-applications.menu	%_sysconfdir/xdg/menus/altlinux-applications-nested.menu	1000
EOF
cat <<EOF >>%buildroot%_altdir/%name-shallow-menu
%_sysconfdir/xdg/menus/altlinux-applications.menu	%_sysconfdir/xdg/menus/altlinux-applications-shallow.menu	100
EOF

#find_lang %name

%post lxde
# hack around lxde
touch /etc/xdg/menus/lxde-applications.menu

#files 
#-f %name.lang
#doc AUTHORS ChangeLog NEWS README

%files common
%dir %_sysconfdir/xdg/menus/applications-merged
%_datadir/desktop-directories/altlinux-*.directory
#config (noreplace) is too dangerous for unexpirienced user
%config %_sysconfdir/xdg/menus/altlinux-*.menu
%_sbindir/altlinux-freedesktop-menu-post

%files nested-menu
%_altdir/%name-nested-menu

%files shallow-menu
%_altdir/%name-shallow-menu

%files xfce
#config (noreplace) is too dangerous for unexpirienced user
%verify(not mtime) %config %_sysconfdir/xdg/menus/xfce-applications.menu
%dir %_sysconfdir/xdg/menus/xfce-applications-merged

%files lxde
#config (noreplace) is too dangerous for unexpirienced user
%verify(not mtime) %config %_sysconfdir/xdg/menus/lxde-applications.menu
%dir %_sysconfdir/xdg/menus/lxde-applications-merged

%files gnome3
%verify(not mtime) %config %_sysconfdir/xdg/menus/gnome3-applications.menu
%_sysconfdir/xdg/menus/gnome-applications.menu
%dir %_sysconfdir/xdg/menus/gnome-applications-merged
%dir %_sysconfdir/xdg/menus/gnome3-applications-merged

%files cinnamon
%verify(not mtime) %config %_sysconfdir/xdg/menus/cinnamon-applications.menu
%dir %_sysconfdir/xdg/menus/cinnamon-applications-merged

%files mate
%verify(not mtime) %config %_sysconfdir/xdg/menus/mate-applications.menu
%dir %_sysconfdir/xdg/menus/mate-applications-merged
%verify(not mtime) %config %_sysconfdir/xdg/menus/mate-settings.menu
%dir %_sysconfdir/xdg/menus/mate-settings-merged


%files kde3
%verify(not mtime) %config %_sysconfdir/xdg/menus/kde3-applications.menu
%dir %_sysconfdir/xdg/menus/kde3-applications-merged

%files generic
%verify(not mtime) %config %_sysconfdir/xdg/menus/applications.menu

%files enlightenment
%verify(not mtime) %config %_sysconfdir/xdg/menus/enlightenment.menu
# Enlightenment is too buggy to display a proper menu :(
#%config %_sysconfdir/xdg/menus/enlightenment-applications.menu
%exclude %_sysconfdir/xdg/menus/enlightenment-applications.menu
%dir %_sysconfdir/xdg/menus/enlightenment-applications-merged

%files kde4
%config %_sysconfdir/kde4/xdg/menus/applications-merged/50-kde4-merged.menu
%dir %_sysconfdir/kde4/xdg/menus/applications-merged
%_datadir/kde4/desktop-directories/altlinux-*.directory

%changelog
