%set_automake_version 1.11

%define qtdir %_qt3dir
%define kdedir %_K3prefix

%def_disable final
%define cmake 0

Name: amarok
Version: 1.4.10
Release: alt17

Summary: Amarok is a music player for KDE.
License: GPL
Group: Sound
Url: http://amarok.kde.org/

Packager: Pavlov Konstantin <thresh@altlinux.ru>

%py_provides Publisher

Source0: ftp://ftp.kde.org/pub/kde/stable/amarok/%version/src/%name-%version.tar.bz2

Patch1: amarok-1.4.10-alt-ruby19.patch
Patch2: amarok-1.4.6-alt-playlist.patch
Patch3: amarok-1.4.9.1-alt-link.patch
Patch4: amarok-1.4.10-alt-ru_translation.patch
Patch5: amarok-1.4.7-alt-ru_desktop_translation.patch
Patch6: amarok-1.4.5-alt11553-collectionscanner.patch
Patch7: amarok-1.4.7-alt-player-icons.patch
Patch8: amarok-1.4.8-alt-libgpod_042.patch
Patch9: amarok-1.4.10-alt-mongrel.patch
Patch11: amarok-1.4.10-SA33505.patch
Patch10: amarok-1.4.9.1-libmtp-0.3.0-API.patch
Patch12: amarok-1.4.10-fix-FTBFS-gcc4.4.patch
Patch13: amarok-1.4.10-fix-automake-detection.patch
Patch14: 10_queuemedia.patch
Patch15: 11_bug403340_cancel_rename_when_deleting_items.diff
Patch16: 13_lastfm_crash_434835.diff
Patch17: 15_temptables_more_indices.diff
Patch18: 16_gnome_multimedia_keys.diff
Patch19: 17_xiph_audio_mimetypes.diff
Patch20: 18_add_lastfm_recommended_radio.diff
Patch22: 22_fix_wikipedia_tab.diff
Patch23: amarok-1.4.10-fix-autoconf-2.64.patch
Patch24: amarok-1.4.10-alt-gcc4.5.patch
Patch25: amarok-alt-malloc.patch
Patch26: amarok-alt-DSO.patch
Patch27: tde-3.5.13-build-defdir-autotool.patch

BuildRequires: cmake doxygen gcc-c++ kdebase-devel libSDL-devel libXext-devel libXrender-devel libxml2-devel
BuildRequires: libXt-devel libavahi-devel libjpeg-devel libpng-devel libruby-devel
BuildRequires: libtag-devel libtunepimp-devel libusb-devel libvisual0.4-devel qt3-designer ruby xml-utils
BuildRequires: libxine-devel libmpeg4ip-devel libtunepimp-devel libgpod-devel libsqlite3-devel libmtp-devel
BuildRequires: libMySQL-devel postgresql-devel

%description
amaroK is an advanced audio player.
Excellent streaming support, audio effects, visualisations and smooth 
crossfading separate this player from existing KDE solutions. 
At the same time amaroK provides a very intuitive and quick user interface, 
with unparalleled playlist handling, optimized for very large playlists.
The built-in StreamBrowser makes finding web streams as easy as using a radio: 
you can pick your favorite program right inside of amaroK.

%description -l ru_RU.UTF-8
amaroK - передовой аудио плеер. Превосходная поддержка потокового воспроизведения, 
звуковые эффекты, визуализации. В то же самое время amaroK обеспечивает очень интуитивный
и быстрый пользовательский интерфейс. Плейлист оптимизирован для очень больших плейлистов.
Встроенный StreamBrowser делает обнаружение потоков в сети столь же легкими как и использование
радио: Вы можете выбрать и настроить их прямо в amaroK.

%package -n kde3-amarok
Group: Sound
Summary: Amarok is a music player for KDE.
Requires: kde3-amarok-engine
Provides: amarok = %version-%release
Obsoletes: amarok < %version-%release
%description -n kde3-amarok
amaroK is an advanced audio player.
Excellent streaming support, audio effects, visualisations and smooth 
crossfading separate this player from existing KDE solutions. 
At the same time amaroK provides a very intuitive and quick user interface, 
with unparalleled playlist handling, optimized for very large playlists.
The built-in StreamBrowser makes finding web streams as easy as using a radio: 
you can pick your favorite program right inside of amaroK.
%description -n kde3-amarok -l ru_RU.UTF-8
amaroK - передовой аудио плеер. Превосходная поддержка потокового воспроизведения, 
звуковые эффекты, визуализации. В то же самое время amaroK обеспечивает очень интуитивный
и быстрый пользовательский интерфейс. Плейлист оптимизирован для очень больших плейлистов.
Встроенный StreamBrowser делает обнаружение потоков в сети столь же легкими как и использование
радио: Вы можете выбрать и настроить их прямо в amaroK.

%package -n kde3-amarok-engine-xine
Summary: Xine engine for amaroK player
Group: Sound
Requires: kde3-amarok = %version-%release
Provides: kde3-amarok-engine
Provides: amarok-engine-xine = %version-%release
Obsoletes: amarok-engine-xine < %version-%release
%description -n kde3-amarok-engine-xine
amarok-engine-xine is an engine for amaroK player.
It uses xine library for output sound stream.
%description -n kde3-amarok-engine-xine -l ru_RU.UTF-8
amarok-engine-xine - это движок для воспроизведения
звука для аудиоплеера amaroK. Он использует библиотеку
xine для вывода аудиопотока.

%package -n kde3-amarok-mediadevice-ipod
Summary: iPod plugin for amaroK player
Group: Sound
Requires: kde3-amarok = %version-%release
Provides: amarok-mediadevice-ipod = %version-%release
Obsoletes: amarok-mediadevice-ipod < %version-%release
%description -n kde3-amarok-mediadevice-ipod
amarok-mediadevice-ipod is a plugin for Apple iPod
player
%description -n kde3-amarok-mediadevice-ipod -l ru_RU.UTF-8
amarok-mediadevice-ipod - плагин, использующийся для
взаимодействия с плеером iPod от Apple

%package -n kde3-amarok-mediadevice-generic
Summary: VFAT plugin for amaroK player
Group: Sound
Requires: kde3-amarok = %version-%release
Provides: %name-mediadevice-vfat
Provides: amarok-mediadevice-generic = %version-%release
Obsoletes: amarok-mediadevice-generic < %version-%release
%description -n kde3-amarok-mediadevice-generic
amarok-mediadevice-generic is a generic plugin for
various devices that uses VFAT filesystem
%description -n kde3-amarok-mediadevice-generic -l ru_RU.UTF-8
amarok-mediadevice-generic - плагин, используемый для работы
с различного рода медиаустройствами, поддерживающими
тип файловой системы VFAT

%package -n kde3-amarok-mediadevice-daap
Summary: DAAP (Digital Audio Access Protocol) plugin for amaroK player
Group: Sound
Requires: kde3-amarok = %version-%release
Provides: amarok-mediadevice-daap = %version-%release
Obsoletes: amarok-mediadevice-daap < %version-%release
%description -n kde3-amarok-mediadevice-daap
amarok-mediadevice-daap is a plugin for interoperability
with various devices that uses Digital Audio Access
Protocol (DAAP)
%description -n kde3-amarok-mediadevice-daap -l ru_RU.UTF-8
amarok-mediadevice-daap - плагин для работы с различными
устройствами, использующими протокол Digital Audio Access
Protocol (DAAP)

%package -n kde3-amarok-mediadevice-mtp
Summary: MTP (Media Transfer Protocol) plugin for amaroK player
Group: Sound
Requires: kde3-amarok = %version-%release
Provides: amarok-mediadevice-mtp = %version-%release
Obsoletes: amarok-mediadevice-mtp < %version-%release
%description -n kde3-amarok-mediadevice-mtp
amarok-mediadevice-daap is a plugin for interoperability
with various devices that uses Media Transfer Protocol (MTP)
%description -n kde3-amarok-mediadevice-mtp -l ru_RU.UTF-8
amarok-mediadevice-daap - плагин для работы с различными
устройствами, использующими протокол Media Transfer Protocol (MTP)

%prep
%setup -q

##%patch1 -p2
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
##%patch10 -p0
%patch11 -p1
%patch12 -p2
##%patch13 -p2

##%patch14 -p1
##%patch15 -p1
##%patch16 -p1
##%patch17 -p1
##%patch18 -p1
##%patch19 -p1
%patch20 -p1
##%patch22 -p1

%patch23 -p1
##%patch24 -p2

%patch25 -p2
%patch26
%patch27

%if %cmake
%else
cp -Rp /usr/share/libtool/aclocal/libtool.m4 admin/libtool.m4.in
cp -Rp /usr/share/libtool/config/ltmain.sh admin/ltmain.sh
%make -f admin/Makefile.common svn
%endif

%build
rm -rf %buildroot
export QTDIR=%qtdir
export KDEDIR=%kdedir

export PATH=$QTDIR/bin:$KDEDIR/bin:$PATH

%if %cmake
BD=%_builddir/%name-%version/BUILD

if ! [ -f $BD/CMakeCache.txt ]
then
%K3cmake -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DAUTODETECT_QT_DIRS="ON" \
    -DCMAKE_VERBOSE_MAKEFILE="ON" \
    -DBUILD_ALL="ON" \
    -DWITH_XINE="ON" \
    -DWITH_IPOD="ON" \
    -DWITH_MTP="ON" \
    -DWITH_DAAP="ON" \
    -DWITH_MP4V2="ON" \
    -DCMAKE_SKIP_RPATH="OFF" \
    -DWITH_GCC_VISIBILITY="ON"
fi
%K3make

%else
# else if cmake

##export CPPFLAGS="$CPPFLAGS -I/usr/include/mpeg4 -I%_includedir/tqtinterface"

%K3configure \
	%{subst_enable final} \
	--enable-new-ldflags \
	--enable-gcc-hidden-visibility \
	--disable-debug \
	--disable-rpath \
	--with-xine \
	--with-mp4v2 \
	--with-musicbrainz \
	--with-libgpod \
	--with-libmtp \
	--with-daap \
	--with-included_sqlite \
	--without-ifp \
	--enable-postgresql \
	--enable-mysql

%make_build

%endif
# end if cmake

%install
%K3install

rm -fr %buildroot%_K3datadir/apps/%name/scripts/templates

%K3find_lang --with-kde %name

%files -n kde3-amarok -f %name.lang
%_K3bindir/amarok
%_K3bindir/amarokapp
%_K3bindir/amarok_libvisual
%_K3bindir/amarok_proxy.rb
%_K3bindir/amarokcollectionscanner
%_K3libdir/libamarok.so.*
%_K3libdir/kde3/libamarok_void-engine_plugin.so
%_K3libdir/kde3/konqsidebar_universalamarok.so
%_K3libdir/kde3/libamarok_massstorage-device.so
%_K3libdir/kde3/libamarok_nfs-device.so
%_K3libdir/kde3/libamarok_smb-device.so
/usr/share/kde/applications/kde/amarok.desktop
%dir %_K3datadir/apps/%name
%_K3datadir/apps/%name/data
%_K3datadir/apps/%name/icons
%_K3datadir/apps/%name/images
%_K3datadir/apps/%name/scripts
%_K3datadir/apps/%name/themes
%_K3datadir/apps/%name/*.rc
%_K3datadir/apps/konqueror/servicemenus/amarok_append.desktop
%_K3datadir/apps/konqueror/servicemenus/amarok_addaspodcast.desktop
%_K3datadir/apps/konqueror/servicemenus/amarok_play_audiocd.desktop
%_K3datadir/apps/konqsidebartng/add/amarok.desktop
%_K3datadir/apps/konqsidebartng/entries/amarok.desktop
%_K3datadir/apps/konqsidebartng/kicker_entries/amarok.desktop
%_K3datadir/apps/profiles/amarok.profile.xml
%_K3datadir/config/amarokrc
%_K3datadir/config.kcfg/amarok.kcfg
%_K3datadir/services/amaroklastfm.protocol
%_K3datadir/services/amarokitpc.protocol
%_K3datadir/services/amarokpcast.protocol
%_K3datadir/services/amarok_void-engine_plugin.desktop
%_K3datadir/services/amarok_massstorage-device.desktop
%_K3datadir/services/amarok_nfs-device.desktop
%_K3datadir/services/amarok_smb-device.desktop
%_K3datadir/servicetypes/amarok_plugin.desktop
%_K3datadir/servicetypes/amarok_codecinstall.desktop
%_kde3_iconsdir/*/*/apps/amarok.png
%lang(pt_BR) /usr/share/kde/doc/HTML/pt_BR/amarok

%files -n kde3-amarok-engine-xine
%_K3libdir/kde3/libamarok_xine-engine.so
%_K3datadir/config.kcfg/xinecfg.kcfg
%_K3datadir/services/amarok_xine-engine.desktop

%files -n kde3-amarok-mediadevice-ipod
%_K3libdir/kde3/libamarok_ipod-mediadevice.so
%_K3datadir/services/amarok_ipod-mediadevice.desktop

%files -n kde3-amarok-mediadevice-generic
%_K3libdir/kde3/libamarok_generic-mediadevice.so
%_K3datadir/services/amarok_generic-mediadevice.desktop

%files -n kde3-amarok-mediadevice-mtp
%_K3libdir/kde3/libamarok_mtp-mediadevice.so
%_K3datadir/services/amarok_mtp-mediadevice.desktop

%files -n kde3-amarok-mediadevice-daap
%_K3bindir/amarok_daapserver.rb
%_K3libdir/kde3/libamarok_daap-mediadevice.so
%_K3datadir/apps/%name/ruby_lib
%_K3datadir/services/amarok_daap-mediadevice.desktop

%changelog
