Name: amavisd-new
Version: 2.6.6
Release: alt3
Serial: 1

Summary: A Mail Virus Scanner
License: GPL
Group: Networking/Mail
Url: http://www.ijs.si/software/amavisd/
Packager: Alexey Shabalin <shaba@altlinux.ru>

Source: %name-%version.tar.gz
Source1: amavisd.init
Source2: amavisd-new-notify.tar.gz
Source3: conf.d.tar.gz
Source6: amavisd-new-README.postfix.ALT.KOI8-R
Source7: amavisd-new-README.postfix.ALT.UTF8
Source8: %name.cron
Source10: amavisd-av-control
Source11: amavisd-spam-control
Source12: amavisd-new.tmpfiles.conf
Patch: amavisd-perl5.18.patch
Patch1: amavisd-skipsomedeps.patch

BuildArch: noarch
Provides: amavisd

Requires: file
Requires: perl-Archive-Zip >= 1.14
Requires: perl-BerkeleyDB 
Requires: perl-Convert-UUlib
Requires: perl-Convert-TNEF
Requires: perl-IO-stringy
Requires: perl-IO-Zlib
Requires: perl-MailTools
Requires: perl-Mail-DKIM >= 0.31

BuildRequires: perl-BerkeleyDB perl-IO-stringy perl-Unix-Syslog perl-Compress-Zlib perl-MIME-tools perl-Net-Server

%description
Amavisd-new is a high-performance interface between mailer (MTA) and 
content checkers: virus scanners, and/or SpamAssassin. It is written 
in Perl for maintainability, without paying a significant price for speed.
It talks to MTA via (E)SMTP or LMTP, or by using helper programs. 
Best with Postfix, fine with dual-sendmail setup and Exim v4, works 
with sendmail/milter, or with any MTA as a SMTP relay. For Courier and 
qmail MTA there is a patch in the distributed package.

%package utils
Summary: Utils package for amavisd-new.
Group: Networking/Mail
Requires: %name

%description utils
This package contains amavisd-new utils: snmp-agent, nanny, release.

%package smtpd
Summary: Virtual package for amavisd-new with MTA.
Group: Networking/Mail
Requires: %name
Requires: smtpdaemon

%description smtpd
This package contains require MTA daemon. If you use postfix, sendmail or exim
you will need to install %name-smtpd.

%package cron
Summary: Cron package for clean quarantine.
Group: Networking/Mail
Requires: %name
Requires: stmpclean
Requires: crontabs

%description cron
This package contains cron script for clean quarantine.

%package spamassassin
Summary: Virtual package for amavisd-new with SpamAssassin.
Group: Networking/Mail
Requires: %name
Requires: perl-Mail-SpamAssassin
Requires: spamassassin >= 2.60

%description spamassassin
This package contains require SpamAssassin perl module.
If you use SpamAssassin, you will need to install %name-spamassassin.

%package razor
Summary: Virtual package for amavisd-new with razor.
Group: Networking/Mail
Requires: %name
Requires: perl-Razor

%description razor
This package contains require razor. If you use razor,
you will need to install %name-razor.

%package clamav
Summary: Virtual package for amavisd-new with clamav antivirus.
Group: Networking/Mail
Requires: %name
Requires: clamav

%description clamav
This package contains require razor. If you use razor,
you will need to install %name-clamav.

%package ext-archives
Summary: Virtual package for amavisd-new with external archives.
Group: Networking/Mail
Requires: %name
Requires: bzip2
Requires: lha
Requires: lzop
Requires: ncompress
#Requires:	nomarch
#Requires:	arc
Requires: unace
Requires: unarj
Requires: unrar
#Requires:	zoo

%description ext-archives
This package contains require external archives.

%package mysql
Summary: Virtual package is supported lookups in mysql.
Group: Networking/Mail
Requires: %name
Requires: perl-DBD-mysql

%description mysql
Amavisd-new is supported for storing information
about processed mail (logging/reporting) and optionally for quarantining
to a SQL database.

%package postgresql
Summary: Virtual package SQL is supported lookups in PostgreSQL.
Group: Networking/Mail
Requires: %name
Requires: perl-DBD-Pg

%description postgresql
Amavisd-new is supported for storing information
about processed mail (logging/reporting) and optionally for quarantining
to a SQL database.

%package ldap-client
Summary: Virtual package is supported lookups in LDAP.
Group: Networking/Mail
Requires: %name
Requires: perl-ldap >= 0.32

%description ldap-client
Amavisd-new is supported lookups multiple search attributes
in LDAP.

%package ldap-server
Summary: Package is supported lookups in LDAP.
Group: Networking/Mail
Requires: openldap-servers

%description ldap-server
Amavisd-new is supported lookups multiple search attributes
in LDAP.


%package p0f
Summary: Virtual package for amavisd-new with p0f.
Group: Networking/Mail
Requires: %name
Requires: p0f

%description p0f
This package contains require p0f and perl script p0f-analyzer.pl. If you use p0f,
you will need to install %name-p0f.

%package complete
Summary: Package contein all subpackages amavisd-new.
Group: Networking/Mail
Requires: %name
Requires: %name-utils
Requires: %name-cron
Requires: %name-spamassassin
Requires: %name-razor
Requires: %name-clamav
Requires: %name-ext-archives
Requires: %name-mysql
Requires: %name-postgresql
Requires: %name-ldap-client
Requires: %name-smtpd
Requires: %name-ldap-server
Requires: %name-p0f

%description complete
All subpackages Amavisd-new.

%prep
%setup -q
%patch -p2
%patch1 -p2

%install
mkdir -p \
	%buildroot%_initdir \
	%buildroot%_sysconfdir/amavis \
	%buildroot%_sysconfdir/tmpfiles.d \
	%buildroot%_sbindir \
	%buildroot%_bindir \
	%buildroot%_spooldir/amavis \
	%buildroot%_spooldir/amavis/db \
	%buildroot%_spooldir/amavis/quarantine \
	%buildroot%_spooldir/amavis/tmp \
	%buildroot%_var/run/amavis \
        %buildroot%_sysconfdir/cron.daily \
        %buildroot%_sysconfdir/openldap/schema \
        %buildroot%_controldir

install -m 755 %SOURCE1 %buildroot%_initdir/amavisd
install -m 640 amavisd.conf %buildroot%_sysconfdir/amavis/amavisd.conf-old
install -m 640 amavisd.conf-default %buildroot%_sysconfdir/amavis/amavisd.conf-default
install -m 640 amavisd.conf-sample %buildroot%_sysconfdir/amavis/amavisd.conf-sample
install -m 700 %SOURCE8 %buildroot%_sysconfdir/cron.daily/%name
install -m 755 amavisd %buildroot%_sbindir/amavisd
install -m 755 amavisd-agent %buildroot%_bindir/amavisd-agent
install -m 755 amavisd-nanny %buildroot%_bindir/amavisd-nanny
install -m 755 amavisd-release %buildroot%_bindir/amavisd-release
install -m 755 p0f-analyzer.pl %buildroot%_bindir/p0f-analyzer.pl

install -m444 LDAP.schema %buildroot%_sysconfdir/openldap/schema/amavisd-new.schema

tar -xzf %SOURCE2 -C %buildroot%_sysconfdir/amavis/
tar -xzf %SOURCE3 -C %buildroot%_sysconfdir/amavis/

###
## Install Attention README
###
install -m 0644 %SOURCE6 README.ALT.KOI8-R
install -m 0644 %SOURCE7 README.ALT.UTF

install -m 755 %SOURCE10 %buildroot%_controldir/amavisd-av
install -m 755 %SOURCE11 %buildroot%_controldir/amavisd-spam

install -m 644 %SOURCE12 %buildroot%_sysconfdir/tmpfiles.d/amavisd.conf

%post
%post_service amavisd

%preun
%preun_service amavisd

%files
%doc AAAREADME.first INSTALL LICENSE README_FILES RELEASE_NOTES test-messages
%doc LDAP.schema TODO
%doc README.ALT.UTF README.ALT.KOI8-R
%config %_initdir/amavisd
%config %_sysconfdir/tmpfiles.d/amavisd.conf
# %attr(640,root,mail) %config(noreplace) %_sysconfdir/amavis/amavisd.conf
%_controldir/amavisd-*
%attr(750,root,mail) %dir %_sysconfdir/amavis/conf.d
%attr(640,root,mail) %config(noreplace) %_sysconfdir/amavis/conf.d/*
%attr(640,root,mail) %_sysconfdir/amavis/amavisd.conf-*
%attr(640,root,mail) %_sysconfdir/amavis/notify_*
%_sbindir/amavisd
%attr(775,mail,mail) %dir %_spooldir/amavis
%attr(770,mail,mail) %dir %_spooldir/amavis/db
%attr(750,mail,mail) %dir %_spooldir/amavis/quarantine
%attr(750,mail,mail) %dir %_spooldir/amavis/tmp
%attr(775,root,mail) %dir %_var/run/amavis

%files utils
%_bindir/amavisd-agent 
%_bindir/amavisd-nanny
%_bindir/amavisd-release

%files cron
%_sysconfdir/cron.daily/%name

%files spamassassin
%files razor
%files clamav
%files ext-archives
%files mysql
%files postgresql
%files ldap-client
%files smtpd
%files ldap-server
%attr(644,root,ldap) %_sysconfdir/openldap/schema/amavisd-new.schema
%files p0f
%_bindir/p0f-analyzer.pl

%files complete

%changelog
