Name: ansible
Summary: SSH-based configuration management, deployment, and task execution system
Version: 2.7.10
Release: alt0.M80P.1

Group: System/Libraries
License: GPLv3
Source0: %name-%version.tar

Patch0:%name-%version-alt.patch

Url: http://www.ansible.com

Packager: Evgenii Terechkov <evg@altlinux.org>

BuildArch: noarch
BuildRequires: python-module-setuptools asciidoc-a2x python-module-jinja2 python-module-yaml python-modules-json python-module-packaging python-module-docutils
#BuildRequires: python-module-docutils-compat

Requires: ca-certificates >= 2015.10.29
%py_requires yaml
%py_requires paramiko

# Skip findreq on all modules:
%add_findreq_skiplist %python_sitelibdir/%name/modules/*
%add_findreq_skiplist %python_sitelibdir/%name/plugins/*
%add_findreq_skiplist %python_sitelibdir/%name/module_utils/ansible_tower.py

%description
Ansible is a radically simple model-driven configuration management,
multi-node deployment, and remote task execution system. Ansible works
over SSH and does not require any software or daemons to be installed
on remote nodes. Extension modules can be written in any language and
are transferred to managed machines automatically.

%prep
%setup
%patch0 -p1

%build
%python_build

%install
%python_install
mkdir -p %buildroot%_sysconfdir/%name/
cp examples/ansible.cfg %buildroot%_sysconfdir/%name/
touch %buildroot%_sysconfdir/%name/hosts
mkdir -p %buildroot/%_man1dir
make docs
cp -v docs/man/man1/*.1 %buildroot/%_man1dir/

%files
%_bindir/%{name}*
%config(noreplace) %_sysconfdir/%name
%_man1dir/%{name}*
%python_sitelibdir/%{name}*
%doc examples/playbooks examples/scripts examples/hosts
%doc README.rst changelogs/CHANGELOG-v*.rst CODING_GUIDELINES.md MODULE_GUIDELINES.md

%changelog
