Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-java
# END SourceDeps(oneline)
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# Copyright (c) 2000-2008, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%bcond_with tests
%bcond_without javadoc

%global ant_home %{_datadir}/ant
%global major_version 1.9

Name:           ant
Version:        1.9.6
Release:        alt1_2jpp8
Epoch:          0
Summary:        Java build tool
Summary(it):    Tool per la compilazione di programmi java
Summary(fr):    Outil de compilation pour java
License:        ASL 2.0
URL:            http://ant.apache.org/
Source0:        http://www.apache.org/dist/ant/source/apache-ant-%{version}-src.tar.bz2
Source2:        apache-ant-1.8.ant.conf

# Fix some places where copies of classes are included in the wrong jarfiles
Patch4:         apache-ant-class-path-in-manifest.patch

BuildRequires:  jpackage-utils >= 0:1.7.5
BuildRequires:  ant
BuildRequires:  ant-junit
BuildRequires:  junit
BuildRequires:  hamcrest
BuildRequires:  xalan-j2
BuildRequires:  xerces-j2
BuildRequires:  xml-commons-apis

# Theoretically Ant might be usable with just JRE, but typical Ant
# workflow requires full JDK, so we recommend it here.

Requires:       xerces-j2
Requires:       xml-commons-apis

Requires:       %{name}-lib = %{epoch}:%{version}-%{release}

Obsoletes:      %{name}-scripts < %{epoch}:%{version}-%{release}
Provides:       %{name}-scripts = %{epoch}:%{version}-%{release}

BuildArch:      noarch
Source44: import.info

Obsoletes:      %{name}-style-xsl < %{version}
Obsoletes:      %{name}-nodeps < %{version}
Provides:       %{name}-nodeps = %{version}
Obsoletes:      %{name}-trax < %{version}
Provides:       %{name}-trax = %{version}


%description
Apache Ant is a Java library and command-line tool whose mission is to
drive processes described in build files as targets and extension
points dependent upon each other.  The main known usage of Ant is the
build of Java applications.  Ant supplies a number of built-in tasks
allowing to compile, assemble, test and run Java applications.  Ant
can also be used effectively to build non Java applications, for
instance C or C++ applications.  More generally, Ant can be used to
pilot any type of process which can be described in terms of targets
and tasks.


%package optional
Summary: Optional tasks for Ant
Group: Development/Java

Requires: %name = %{?epoch:%epoch:}%version-%release
Requires: %name-antlr = %{?epoch:%epoch:}%version-%release
Requires: %name-apache-bcel = %{?epoch:%epoch:}%version-%release
Requires: %name-commons-logging = %{?epoch:%epoch:}%version-%release
Requires: %name-commons-net = %{?epoch:%epoch:}%version-%release
Requires: %name-apache-oro = %{?epoch:%epoch:}%version-%release
Requires: %name-apache-regexp = %{?epoch:%epoch:}%version-%release
Requires: %name-javamail = %{?epoch:%epoch:}%version-%release
Requires: %name-jdepend = %{?epoch:%epoch:}%version-%release
Requires: %name-jmf = %{?epoch:%epoch:}%version-%release
Requires: %name-jsch = %{?epoch:%epoch:}%version-%release
Requires: %name-junit = %{?epoch:%epoch:}%version-%release
Requires: %name-apache-log4j = %{?epoch:%epoch:}%version-%release
Requires: %name-swing = %{?epoch:%epoch:}%version-%release
Requires: %name-apache-resolver = %{?epoch:%epoch:}%version-%release
Requires: %name-apache-bsf = %{?epoch:%epoch:}%version-%release
#Requires: %name-jai = %{?epoch:%epoch:}%version-%release
#Requires: %name-stylebook = %{?epoch:%epoch:}%version-%release

%description optional
Optional build tasks for ant, a platform-independent build tool for Java.

%files optional



%description -l fr
Ant est un outil de compilation multi-plateformes pour java. Il est
utilisé par les projets apache-jakarta et apache-xml.

%description -l it
Ant e' un tool indipendente dalla piattaforma creato per faciltare la
compilazione di programmi java.
Allo stato attuale viene utilizzato dai progetti apache jakarta ed
apache xml.

%package lib
Group: Development/Java
Summary:        Core part of %{name}

%description lib
Core part of Apache Ant that can be used as a library.

%package jmf
Group: Development/Java
Summary:        Optional jmf tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}

%description jmf
Optional jmf tasks for %{name}.

%description jmf -l fr
Taches jmf optionelles pour %{name}.

%package swing
Group: Development/Java
Summary:        Optional swing tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}

%description swing
Optional swing tasks for %{name}.

%description swing -l fr
Taches swing optionelles pour %{name}.

%package antlr
Group: Development/Java
Summary:        Optional antlr tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       antlr
BuildRequires:  antlr

%description antlr
Optional antlr tasks for %{name}.

%description antlr -l fr
Taches antlr optionelles pour %{name}.

%package apache-bsf
Group: Development/Java
Summary:        Optional apache bsf tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       bsf
BuildRequires:  bsf

#Provides: ant-bsf = %{epoch}:%version-%release
Obsoletes: ant-bsf < 1.8.0

%description apache-bsf
Optional apache bsf tasks for %{name}.

%description apache-bsf -l fr
Taches apache bsf optionelles pour %{name}.

%package apache-resolver
Group: Development/Java
Summary:        Optional apache resolver tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       xml-commons-resolver
BuildRequires:  xml-commons-resolver

#Provides: ant-xml-resolver = %{epoch}:%version-%release
Obsoletes: ant-xml-resolver < 1.8.0

%description apache-resolver
Optional apache resolver tasks for %{name}.

%description apache-resolver -l fr
Taches apache resolver optionelles pour %{name}.

%package commons-logging
Group: Development/Java
Summary:        Optional commons logging tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       apache-commons-logging
BuildRequires:  apache-commons-logging

%description commons-logging
Optional commons logging tasks for %{name}.

%description commons-logging -l fr
Taches commons logging optionelles pour %{name}.

%package commons-net
Group: Development/Java
Summary:        Optional commons net tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       apache-commons-net
BuildRequires:  apache-commons-net

%description commons-net
Optional commons net tasks for %{name}.

%description commons-net -l fr
Taches commons net optionelles pour %{name}.

# Disable because we don't ship the dependencies
%if 0
%package jai
Group: Development/Java
Summary:        Optional jai tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       jai
BuildRequires:  jai

%description jai
Optional jai tasks for %{name}.

%description jai -l fr
Taches jai optionelles pour %{name}.
%endif

%package apache-bcel
Group: Development/Java
Summary:        Optional apache bcel tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       bcel
BuildRequires:  bcel

#Provides: ant-bcel = %{epoch}:%version-%release
Obsoletes: ant-bcel < 1.8.0

%description apache-bcel
Optional apache bcel tasks for %{name}.

%description apache-bcel -l fr
Taches apache bcel optionelles pour %{name}.

%package apache-log4j
Group: Development/Java
Summary:        Optional apache log4j tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       log4j
BuildRequires:  log4j

#Provides: ant-log4j = %{epoch}:%version-%release
Obsoletes: ant-log4j < 1.8.0

%description apache-log4j
Optional apache log4j tasks for %{name}.

%description apache-log4j -l fr
Taches apache log4j optionelles pour %{name}.

%package apache-oro
Group: Development/Java
Summary:        Optional apache oro tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       jakarta-oro
BuildRequires:  jakarta-oro

%description apache-oro
Optional apache oro tasks for %{name}.

%description apache-oro -l fr
Taches apache oro optionelles pour %{name}.

%package apache-regexp
Group: Development/Java
Summary:        Optional apache regexp tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       regexp
BuildRequires:  regexp

%description apache-regexp
Optional apache regexp tasks for %{name}.

%description apache-regexp -l fr
Taches apache regexp optionelles pour %{name}.

%package apache-xalan2
Group: Development/Tools
Summary:        Optional apache xalan2 tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       regexp
BuildRequires:  regexp
Requires:       xalan-j2

%description apache-xalan2
Optional apache xalan2 tasks for %{name}.

%description apache-xalan2 -l fr
Taches apache xalan2 optionelles pour %{name}.

%package javamail
Group: Development/Java
Summary:        Optional javamail tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       javamail 
BuildRequires:  javamail 

%description javamail
Optional javamail tasks for %{name}.

%description javamail -l fr
Taches javamail optionelles pour %{name}.

%package jdepend
Group: Development/Java
Summary:        Optional jdepend tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       jdepend
BuildRequires:  jdepend

%description jdepend
Optional jdepend tasks for %{name}.

%description jdepend -l fr
Taches jdepend optionelles pour %{name}.

%package jsch
Group: Development/Java
Summary:        Optional jsch tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       jsch
BuildRequires:  jsch

%description jsch
Optional jsch tasks for %{name}.

%description jsch -l fr
Taches jsch optionelles pour %{name}.

%package junit
Group: Development/Java
Summary:        Optional junit tasks for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       junit
Requires:       xalan-j2

%description junit
Optional junit tasks for %{name}.

%description junit -l fr
Taches junit optionelles pour %{name}.

%package testutil
Group: Development/Tools
Summary:        Test utility classes for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}
Requires:       junit

%description testutil
Test utility tasks for %{name}.

%package manual
Group: Development/Java
Summary:        Manual for %{name}
BuildArch: noarch
Obsoletes: ant-task-reference < 1.8.0

%description manual
Documentation for %{name}.

%description manual -l it
Documentazione di %{name}.

%description manual -l fr
Documentation pour %{name}.

%package javadoc
Group: Development/Java
Summary:        Javadoc for %{name}
BuildArch: noarch

%description javadoc
Javadoc for %{name}.

%description javadoc -l fr
Javadoc pour %{name}.

# -----------------------------------------------------------------------------

%prep
%setup -q -n apache-ant-%{version}
#Fixup version
find -name build.xml -o -name pom.xml | xargs sed -i -e s/-SNAPSHOT//

# Fix class-path-in-manifest rpmlint warning
%patch4

# clean jar files
find . -name "*.jar" | %{_bindir}/xargs -t rm

# failing testcases. TODO see why
rm src/tests/junit/org/apache/tools/ant/types/selectors/SignedSelectorTest.java \
   src/tests/junit/org/apache/tools/ant/taskdefs/condition/IsFileSelectedTest.java \
   src/tests/junit/org/apache/tools/ant/taskdefs/condition/IsSignedTest.java \
   src/tests/junit/org/apache/tools/ant/taskdefs/JarTest.java \
   src/tests/junit/org/apache/tools/mail/MailMessageTest.java

#install jars
build-jar-repository -s -p lib/optional antlr bcel javamail/mailapi jdepend junit log4j oro regexp bsf commons-logging commons-net jsch xalan-j2 xml-commons-resolver xalan-j2-serializer xerces-j2 xml-commons-apis hamcrest/core

# Fix file-not-utf8 rpmlint warning
iconv KEYS -f iso-8859-1 -t utf-8 -o KEYS.utf8
mv KEYS.utf8 KEYS
iconv LICENSE -f iso-8859-1 -t utf-8 -o LICENSE.utf8
mv LICENSE.utf8 LICENSE

%build
%{ant} jars test-jar

%if %with javadoc
export CLASSPATH=$(build-classpath antlr bcel javamail/mailapi jdepend junit log4j oro regexp bsf commons-logging commons-net jsch xalan-j2 xml-commons-resolver xerces-j2 xml-commons-apis)
%{ant} javadocs
%endif

#remove empty jai and netrexx jars. Due to missing dependencies they contain only manifests.
rm -fr build/lib/ant-jai.jar build/lib/ant-netrexx.jar
# -----------------------------------------------------------------------------

%install
# ANT_HOME and subdirs
mkdir -p $RPM_BUILD_ROOT%{ant_home}/{lib,etc,bin}

# jars
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}/%{name}
install -d -m 755 $RPM_BUILD_ROOT%{_mavenpomdir}

for jar in build/lib/*.jar
do
  # Make sure that installed JARs are not empty
  jar tf ${jar} | egrep -q *.class

  jarname=$(basename $jar .jar)
  pomname="JPP.%{name}-${jarname}.pom"

  #instal jar
  install -m 644 ${jar} $RPM_BUILD_ROOT%{_javadir}/%{name}/${jarname}.jar
  # jar aliases
  ln -sf ../../java/%{name}/${jarname}.jar $RPM_BUILD_ROOT%{ant_home}/lib/${jarname}.jar

  #bootstrap does not have a pom
  [ $jarname == ant-bootstrap ] && continue

  # add backward compatibility for nodeps jar that is now part of main
  # jar
  alias=
  [ $jarname == ant ] && alias=org.apache.ant:ant-nodeps,apache:ant,ant:ant
  [ $jarname == ant-launcher ] && alias=ant:ant-launcher

  #install pom
  install -p -m 644 src/etc/poms/${jarname}/pom.xml $RPM_BUILD_ROOT%{_mavenpomdir}/${pomname}
  %add_maven_depmap ${pomname} %{name}/${jarname}.jar -a "${alias}" -f ${jarname/ant-/}
done

for mod in ant ant-bootstrap ant-launcher; do
    ln -sf %{name}/${mod}.jar $RPM_BUILD_ROOT%{_javadir}
done

#ant-parent pom
install -p -m 644 src/etc/poms/pom.xml $RPM_BUILD_ROOT%{_mavenpomdir}/JPP-%{name}-parent.pom
%add_maven_depmap JPP-%{name}-parent.pom

# scripts: remove dos and os/2 scripts
rm -f src/script/*.bat
rm -f src/script/*.cmd

# XSLs
cp -p src/etc/*.xsl $RPM_BUILD_ROOT%{ant_home}/etc

# install everything else
mkdir -p $RPM_BUILD_ROOT%{_bindir}
cp -p src/script/{ant,antRun} $RPM_BUILD_ROOT%{_bindir}
ln -sf %{_bindir}/ant $RPM_BUILD_ROOT%{ant_home}/bin/
ln -sf %{_bindir}/antRun $RPM_BUILD_ROOT%{ant_home}/bin/

# default ant.conf
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}
cp -p %{SOURCE2} $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.conf

# OPT_JAR_LIST fragments
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d
echo "ant/ant-jmf" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/jmf
echo "ant/ant-swing" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/swing
echo "antlr ant/ant-antlr" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/antlr
echo "rhino bsf ant/ant-apache-bsf" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/apache-bsf
echo "xml-commons-resolver ant/ant-apache-resolver" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/apache-resolver
echo "apache-commons-logging ant/ant-commons-logging" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/commons-logging
echo "apache-commons-net ant/ant-commons-net" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/commons-net
#echo "jai ant/ant-jai" > $RPM_BUILD_ROOT%%{_sysconfdir}/%%{name}.d/jai
echo "bcel ant/ant-apache-bcel" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/apache-bcel
echo "log4j ant/ant-apache-log4j" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/apache-log4j
echo "oro ant/ant-apache-oro" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/apache-oro
echo "regexp ant/ant-apache-regexp" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/apache-regexp
echo "xalan-j2 xalan-j2-serializer ant/ant-apache-xalan2" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/apache-xalan2
echo "javamail jaf ant/ant-javamail" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/javamail
echo "jdepend ant/ant-jdepend" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/jdepend
echo "jsch ant/ant-jsch" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/jsch
echo "junit hamcrest/core ant/ant-junit" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/junit
echo "junit hamcrest/core ant/ant-junit4" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/junit4
echo "testutil ant/ant-testutil" > $RPM_BUILD_ROOT%{_sysconfdir}/%{name}.d/testutil

%if %with javadoc
# javadoc
mkdir -p $RPM_BUILD_ROOT%{_javadocdir}/%{name}
cp -pr build/javadocs/* $RPM_BUILD_ROOT%{_javadocdir}/%{name}
%endif

# fix link between manual and javadoc
(cd manual; ln -sf %{_javadocdir}/%{name} api)
# multiple -f flags in %files: merging -f .mfiles-ant into -f .mfiles
cat .mfiles-ant >> .mfiles
# multiple -f flags in %files: merging -f .mfiles-launcher into -f .mfiles
cat .mfiles-launcher >> .mfiles
# multiple -f flags in %files: merging -f .mfiles-junit4 into -f .mfiles-junit
cat .mfiles-junit4 >> .mfiles-junit

%if %with tests
%check
%{ant} test
%endif

%files
%doc KEYS LICENSE NOTICE README WHATSNEW
%config(noreplace) %{_sysconfdir}/%{name}.conf
%attr(0755,root,root) %{_bindir}/ant
%attr(0755,root,root) %{_bindir}/antRun
%dir %{ant_home}
%dir %{ant_home}/bin
%{ant_home}/bin/ant
%{ant_home}/bin/antRun
%dir %{ant_home}/etc
%{ant_home}/etc/ant-update.xsl
%{ant_home}/etc/changelog.xsl
%{ant_home}/etc/coverage-frames.xsl
%{ant_home}/etc/mmetrics-frames.xsl
%{ant_home}/etc/log.xsl
%{ant_home}/etc/tagdiff.xsl
%{ant_home}/etc/junit-frames-xalan1.xsl
%{ant_home}/etc/common2master.xsl
%{ant_home}/etc/printFailingTests.xsl
%dir %{_sysconfdir}/%{name}.d

%files lib -f .mfiles  
%dir %{ant_home}/lib
%{_javadir}/%{name}.jar
%{_javadir}/%{name}-bootstrap.jar
%{_javadir}/%{name}-launcher.jar
%{_javadir}/%{name}/%{name}-bootstrap.jar
%{ant_home}/lib/%{name}.jar
%{ant_home}/lib/%{name}-launcher.jar
%{ant_home}/lib/%{name}-bootstrap.jar

%files jmf -f .mfiles-jmf
%{ant_home}/lib/%{name}-jmf.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/jmf

%files swing -f .mfiles-swing
%{ant_home}/lib/%{name}-swing.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/swing

%files antlr -f .mfiles-antlr
%{ant_home}/lib/%{name}-antlr.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/antlr

%files apache-bsf -f .mfiles-apache-bsf
%{ant_home}/lib/%{name}-apache-bsf.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/apache-bsf

%files apache-resolver -f .mfiles-apache-resolver
%{ant_home}/lib/%{name}-apache-resolver.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/apache-resolver

%files commons-logging -f .mfiles-commons-logging
%{ant_home}/lib/%{name}-commons-logging.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/commons-logging

%files commons-net -f .mfiles-commons-net
%{ant_home}/lib/%{name}-commons-net.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/commons-net

# Disable as we dont ship the dependencies
%if 0
%files jai -f .mfiles-jai
%{ant_home}/lib/%{name}-jai.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/jai
%endif

%files apache-bcel -f .mfiles-apache-bcel
%{ant_home}/lib/%{name}-apache-bcel.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/apache-bcel

%files apache-log4j -f .mfiles-apache-log4j
%{ant_home}/lib/%{name}-apache-log4j.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/apache-log4j

%files apache-oro -f .mfiles-apache-oro
%{ant_home}/lib/%{name}-apache-oro.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/apache-oro
%{ant_home}/etc/maudit-frames.xsl

%files apache-regexp -f .mfiles-apache-regexp
%{ant_home}/lib/%{name}-apache-regexp.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/apache-regexp

%files apache-xalan2 -f .mfiles-apache-xalan2
%{ant_home}/lib/%{name}-apache-xalan2.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/apache-xalan2

%files javamail -f .mfiles-javamail
%{ant_home}/lib/%{name}-javamail.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/javamail

%files jdepend -f .mfiles-jdepend
%{ant_home}/lib/%{name}-jdepend.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/jdepend
%{ant_home}/etc/jdepend.xsl
%{ant_home}/etc/jdepend-frames.xsl

%files jsch -f .mfiles-jsch
%{ant_home}/lib/%{name}-jsch.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/jsch

%files junit -f .mfiles-junit
%{ant_home}/lib/%{name}-junit.jar
%{ant_home}/lib/%{name}-junit4.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/junit
%config(noreplace) %{_sysconfdir}/%{name}.d/junit4
%{ant_home}/etc/junit-frames.xsl
%{ant_home}/etc/junit-noframes.xsl

%files testutil -f .mfiles-testutil
%{ant_home}/lib/%{name}-testutil.jar
%config(noreplace) %{_sysconfdir}/%{name}.d/testutil

%files manual
%doc LICENSE NOTICE
%doc --no-dereference manual/*

%if %with javadoc
%files javadoc
%doc LICENSE NOTICE
%{_javadocdir}/%{name}
%endif

# -----------------------------------------------------------------------------

%changelog
