Epoch: 1
Group: Development/Java
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
%define fedora 23
Name:           apache-commons-fileupload
Version:        1.3.1
Release:        alt1_7jpp8
Summary:        API to work with HTML file upload
License:        ASL 2.0
URL:            http://commons.apache.org/fileupload/
BuildArch:      noarch

Source0:        http://www.apache.org/dist/commons/fileupload/source/commons-fileupload-%{version}-src.tar.gz

BuildRequires:  maven-local
BuildRequires:  mvn(commons-io:commons-io)
BuildRequires:  mvn(javax.servlet:servlet-api)
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.apache.commons:commons-parent:pom:)
BuildRequires:  mvn(org.apache.maven.plugins:maven-assembly-plugin)
BuildRequires:  mvn(org.apache.maven.plugins:maven-release-plugin)
%if 0%{?fedora}
BuildRequires:  mvn(javax.portlet:portlet-api)
%endif
Source44: import.info
%define short_name commons-fileupload
Provides: %{short_name} = %{version}
Conflicts:	jakarta-%{short_name} < 1:%version

%description
The javax.servlet package lacks support for RFC-1867, HTML file
upload.  This package provides a simple to use API for working with
such data.  The scope of this package is to create a package of Java
utility classes to read multipart/form-data within a
javax.servlet.http.HttpServletRequest.

%package javadoc
Group: Development/Java
Summary:        API documentation for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

# -----------------------------------------------------------------------------

%prep
%setup -q -n commons-fileupload-%{version}-src
sed -i 's/\r//' LICENSE.txt
sed -i 's/\r//' NOTICE.txt

%if 0%{?fedora}
# fix gId
sed -i "s|<groupId>portlet-api</groupId>|<groupId>javax.portlet</groupId>|" pom.xml
%else
# Non-Fedora: remove portlet stuff
%pom_remove_dep portlet-api:portlet-api
%pom_xpath_remove pom:properties/pom:commons.osgi.import
%pom_xpath_remove pom:properties/pom:commons.osgi.dynamicImport
rm -r src/main/java/org/apache/commons/fileupload/portlet
rm src/test/java/org/apache/commons/fileupload/*Portlet*
%endif

# -----------------------------------------------------------------------------

%mvn_file ":{*}" %{name} @1
%mvn_alias : org.apache.commons:

%build
# fix build with generics support
# tests fail to compile because they use an obsolete version of servlet API (2.4)
%mvn_build -f

%install
%mvn_install

%files -f .mfiles
%doc LICENSE.txt NOTICE.txt

%files javadoc -f .mfiles-javadoc
%doc LICENSE.txt NOTICE.txt

# -----------------------------------------------------------------------------

%changelog
