%define php5_sapi apache-mod_php
%define so_file  libphp5.so

Name: apache-mod_php5
Version: %php5_version
Release: %php5_release

Summary: The PHP5 HTML-embedded scripting language for use with Apache
Group: System/Servers
License: PHP
Url: http://www.php.net/

Prereq: php5 = %php5_version
Prereq: php5 >= %php5_version-%php5_release
Prereq:	apache-base >= %apache_version-%apache_release

Conflicts: mod_php
Obsoletes: mod_php5
Provides: mod_php5
Provides: php-engine = %php5_version-%php5_release

Source0: %{name}-control.tar
Source1: %name-php.conf
Source3: php.ini
Source4: %name-browscap.ini

Patch1: php-alt-namespace.patch

BuildRequires(pre): rpm-build-php5 apache-devel
BuildRequires: php5-devel = %php5_version

# Automatically added by buildreq on Fri Jul 01 2005
BuildRequires: libmm-devel libxml2-devel zlib-devel 

%description
PHP is an HTML-embedded scripting language.  PHP attempts to make it
easy for developers to write dynamically generated web pages.  PHP
also offers built-in database integration for several commercial
and non-commercial database management systems, so writing a
database-enabled web page with PHP is fairly simple.  The most
common use of PHP coding is probably as a replacement for CGI
scripts.  The mod_php module enables the Apache web server to
understand and process the embedded PHP language in web pages.

This package contains PHP version 5. You'll also need to install the
Apache web server.

%package control
Summary: Control facility and profiles for %name
Group: System/Servers
Requires: %name = %version-%release
Requires: php-base >= 2.6

%description control
Control facility and profiles for %name to easily switch
between predefined php.ini profiles

%prep
%setup -c
%php5_sapi_prepare apache
%patch1 -p1 -b .fix1

%build
rm -f internal_functions.c

%apache_apxs \
  $(php-config --includes) \
  $(php-config --ldflags) %php5_optflags \
  $(php-config --libs) \
  -I. -I./include -I/usr/include/apache -Iext/date/lib -I/usr/include/libxml2 \
  -DUSE_TRANSFER_TABLES=1 \
  -Wl,-rpath=%_libdir/apache -L%_libdir/apache -lhttpd \
  -lphp-%_php5_version \
  -o %so_file -c *.c 

%install
mkdir -p \
	%buildroot/%_libdir/apache \
	%buildroot/%apache_modconfdir \
	%buildroot/%php5_sysconfdir/%php5_sapi/php.d \
	%buildroot/%php5_sysconfdir/%php5_sapi/control.d \
	%buildroot/%_sysconfdir/control.d/facilities \
	%buildroot/%_rpmlibdir

cat > %buildroot/%_rpmlibdir/%name.filetrigger << EOF
#!/bin/sh
LC_ALL=C egrep -qs '^%php5_sysconfdir/%php5_sapi|^%php5_extdir' || exit 0
%post_apacheconf
EOF
chmod 755 %buildroot/%_rpmlibdir/%name.filetrigger

install -m 644 %SOURCE1 %buildroot/%apache_modconfdir/%name.conf
install -m 644 %SOURCE3 %buildroot/%php5_sysconfdir/%php5_sapi/php.ini
install -m 644 %SOURCE4 %buildroot/%php5_sysconfdir/%php5_sapi/browscap.ini
install -m 755 php.control %buildroot/%_sysconfdir/control.d/facilities/%name
install -m 644 modes/* %buildroot/%php5_sysconfdir/%php5_sapi/control.d/

cp %so_file %buildroot/%_libdir/apache

for f in \
	%buildroot/%apache_modconfdir/%name.conf \
	%buildroot/%php5_sysconfdir/%php5_sapi/php.ini \
	%buildroot/%_sysconfdir/control.d/facilities/%name
do
  subst 's,@SAPI@,%php5_sapi,g' "$f"
  subst 's,@PHP_VERSION@,%_php5_version,g' "$f"
  subst 's,@PHP_MAJOR@,%_php5_major,g' "$f"
  subst 's,@PHP_LIBDIR@,%_libdir/php,g' "$f"
  subst 's,@HTDOCSDIR@,%apache_htdocsdir,g' "$f"
  subst 's,@PHP_BROWSCAP@,%php5_sysconfdir/%php5_sapi/browscap.ini,g' "$f"
  subst 's,@PHP_UPLOADDIR@,%apache_tmpdir/uploads,g' "$f"
  subst 's,@PHP_SESSIONDIR@,%apache_tmpdir/sessions,g' "$f"
  subst 's,@LIBDIR@,%_libdir,g' "$f"
done

%post
%php5_sapi_postin

%preun
%php5_sapi_preun

%postun
if [ $1 = 0 ]; then
	%post_apacheconf
fi

%files
%config(noreplace) %apache_modconfdir/%name.conf
%dir %php5_sysconfdir/%php5_sapi
%dir %php5_sysconfdir/%php5_sapi/php.d
%config(noreplace) %php5_sysconfdir/%php5_sapi/php.ini
%config(noreplace) %php5_sysconfdir/%php5_sapi/browscap.ini
%_libdir/apache/%so_file
%_rpmlibdir/%name.filetrigger
%doc apache
%doc CREDITS

%files control
%_sysconfdir/control.d/facilities/*
%php5_sysconfdir/%php5_sapi/control.d/

%changelog
