# vir: set ft=spec: -*- rpm-spec -*-
%define mmn 20120211
%define apache_configs_branch 2
%define apache_configs_dirs_name %apache2_name-configs-dirs%apache_configs_branch
%define apache_configs_dirs_version %apache_configs_branch.2.0
%define apache_configs_name %apache2_name-configs%apache_configs_branch
%define apache_configs_version %apache_configs_branch.3.2
%define apache_config_tool_branch 0
%define apache_config_tool_name %apache2_name-config-tools
%define apache_config_tool_version %apache_config_tool_branch.1.2
%define docdir %apache2_docdir_prefix-%version
%define macrosname %name-build

Name:    apache2
Version: 2.4.43
Release: alt1
Epoch: 1

License: %asl
Group: System/Servers
Url: http://httpd.apache.org/

Summary: The most widely used Web server on the Internet
Summary(ru_RU.UTF-8): Самый популярный веб-сервер Internet
Summary(uk_UA.UTF-8): Найбільш популярний веб-сервер Internet

Source0: httpd-%version.tar
Source1: apache2.watch

Source11: apache2-alt-configs-3.0.tar
Source12: README.ALT.ru_RU.KOI8-R
Source13: apache2-alt-alternatives-0.3.0.tar
Source14: README.ALT.ru_RU.UTF8
Source15: tmpfiles.conf
Source16: httpd.env.conf
Source17: htcacheclean.conf
Source18: htcacheclean-daemon-start.sh
Source19: htcacheclean.cron.daily

Source35: httpd2.init.Sisyphus
Source36: htcacheclean.init
Source37: httpd.service
Source38: htcacheclean.service

# scripts for control
Source40: cgi-bin_test-cgi.control.sh
Source41: cgi-bin_printenv.control.sh
Source42: htcacheclean-run.control.sh
Source43: htcacheclean-mode.control.sh

# RPM FileTrigger
Source50: 00-apache2-common.filetrigger
Source51: zz80-apache2-base.filetrigger
Source52: 90-apache2-base-a2chkconfig.filetrigger
Source53: 90-apache2-base-httpd.filetrigger
Source54: 90-apache2-htcacheclean.filetrigger
Source55: zz90-apache2-htcacheclean.filetrigger
Source56: zzzz-apache2-common.filetrigger

# scripts for condstopstart-web
Source60: server-condstop.sh
Source62: server-condstart.sh
Source63: server-condstart-rpm.sh

# scripts for SSL cert
Source70: apache2-cert-sh-functions.sh
Source71: apache2-cert-sh.sh

# ALT patches:
Patch1: apache2-2.4.28-alt-all-0.3.patch
Patch2: apache2-2.4.25-alt-apachectl.patch
Patch3: apache2-2.4.27-alt-httpd.conf.patch
Patch4: apache2-2.4.35-tlv1.2-default.patch

# Upstream patches:
Patch6: apache2-2.4.41-r1870095.patch

BuildRequires(pre): rpm-macros-apache2 >= 3.12
BuildRequires(pre): libssl-devel
BuildRequires(pre): rpm-macros-condstopstart
BuildRequires(pre): libaprutil1-devel 
BuildRequires(pre): rpm-build-licenses
BuildPreReq: rpm-macros-webserver-cgi-bin-control
BuildPreReq: rpm >= 4.0.4-alt100.62
# For use -z sed option
BuildPreReq: sed >= 1:4.2.2-alt1

Requires: %name-base = %EVR
Requires: %_bindir/ab2
Requires: %_bindir/htpasswd2
Requires: webserver-cgi-bin
Requires: webserver-html
Requires: webserver-icons

# Modules by default
Requires: %name-mod_cache_disk >= %EVR

BuildPreReq: webserver-common

# Automatically added by buildreq on Fri Mar 31 2006
BuildRequires: zlib-devel

BuildPreReq: rpm-macros-alternatives
BuildPreReq: pkg-config
BuildPreReq: libgdbm-devel
BuildPreReq: libexpat-devel
BuildPreReq: libpcre-devel
BuildPreReq: openldap libldap-devel
BuildPreReq: libsasl2-devel libsasl2-plugin-gssapi
BuildPreReq: openssl
#following is required by dbmmanage
BuildPreReq: perl-DBM perl-Digest-SHA1 zlib-devel

#Fix libtool use
BuildPreReq: libtool >= 3:2.2.6

%description
Apache is a powerful, full-featured, efficient and freely-available
Web server.

%description -l ru_RU.UTF-8
Apache - мощный, функциональный, высокопроизводительный и
свободно распространяемый веб-сервер.

%package base
Summary: The most widely used Web server on the Internet (base)
Summary(ru_RU.UTF-8): Самый популярный веб-сервер Internet (база)
Summary(uk_UA.UTF-8): Найбільш популярний веб-сервер Internet (база)
Group: System/Servers

Provides: webserver
Provides: httpd
Provides: %name-common = %EVR
Provides: %apache_configs_name = %apache_configs_version
Provides: %apache_configs_dirs_name = %apache_configs_dirs_version
Provides: %apache_config_tool_name = %apache_config_tool_version

Provides: %apache2_addonconfdir
Provides: %apache2_serverdatadir
Provides: %apache2_errordir
Provides: %apache2_errordir/include
Provides: %_var/lib/dav
Provides: %apache2_proxycachedir
Provides: %apache2_spooldir
Provides: %apache2_spooldir/tmp
Provides: %apache2_spooldir/sessions
Provides: %apache2_spooldir/uploads
Provides: %apache2_basedir
Provides: %apache2_moduledir
Provides: %apache2_modulelink
Provides: %apache2_confdir
Provides: %apache2_confdir_inc
Provides: %apache2_extra_available
Provides: %apache2_extra_enabled
Provides: %apache2_extra_start
Provides: %apache2_mods_available
Provides: %apache2_mods_enabled
Provides: %apache2_mods_start
Provides: %apache2_ports_available
Provides: %apache2_ports_enabled
Provides: %apache2_ports_start
Provides: %apache2_sites_available
Provides: %apache2_sites_enabled
Provides: %apache2_sites_start
Provides: %apache2_libdir
Provides: %apache2_logfiledir
Provides: %apache2_runtimedir
Provides: %apache2_lockdir
Provides: %docdir

Conflicts: apache-common <= 1.3.42rusPL30.24-alt9
Conflicts: apache <= 1.3.42rusPL30.24-alt9
Conflicts: apache-mod_perl < 1.3.42rusPL30.24-alt9
Conflicts: apache2-htcacheclean <= 2.2.22-alt11

Obsoletes: %name-init
Obsoletes: %name-common < %EVR
PreReq: webserver-common
Requires: %name-mods >= %version-%release
Requires: %apache_configs_dirs_name >= %apache_configs_branch
Requires: %apache_config_tool_name >= %apache_config_tool_branch
Requires: %_sbindir/%apache2_dname
Requires: %condstopstart_webdir
Requires: %condstopstart_webrundir

%description base
Apache is a powerful, full-featured, efficient and freely-available
Web server.

This package does not require a webserver-cgi-bin, webserver-html and
webserver-icons.

%description -l ru_RU.UTF-8 base
Apache - мощный, функциональный, высокопроизводительный и
свободно распространяемый веб-сервер.

Данный пакет не требует наличия webserver-cgi-bin, webserver-html и
webserver-icons.

%package full
Summary: The most widely used Web server on the Internet (full)
Summary(ru_RU.UTF-8): Самый популярный веб-сервер Internet (full)
Summary(uk_UA.UTF-8): Найбільш популярний веб-сервер Internet (full)
Group: System/Servers
BuildArch: noarch

Requires: %name = %EVR
Requires: %name-cgi-bin >= %EVR
Requires: %name-html >= %EVR
Requires: %name-icons >= %EVR

%description full
Apache is a powerful, full-featured, efficient and freely-available
Web server.

This package requires a %name-cgi-bin, %name-html and %name-icons.

%description -l ru_RU.UTF-8 full
Apache - мощный, функциональный, высокопроизводительный и
свободно распространяемый веб-сервер.

Данный пакет требует наличия %name-cgi-bin, %name-html и %name-icons.

%package mods
Summary: Modules for %name installations
Summary(ru_RU.UTF-8): Модули для инсталляции %name
Group: System/Servers
Conflicts: apache2 < 2.2.4-alt17
Conflicts: apache2-base <= 2.2.22-alt15
PreReq: %name-base = %EVR
Requires: %name-mmn = %mmn
Requires: %apache2_libaprutil_name >= %apache2_libaprutil_evr
Requires: %apache2_libapr_name >= %apache2_libapr_evr
Requires: %apache2_moduledir
Obsoletes: apache2-mod_macro

%description mods
This package contains modules for %name.

%description -l ru_RU.UTF-8 mods
В этом пакете находятся модули для %name.

%package configs-A1PROXIED
Summary: This is a hack to run proxified Apache2 in case Apache1 is running
Summary(ru_RU.UTF-8): Хак для поддержки проксирования Apache2 через Apache1, при его запуске
Group: System/Servers
BuildArch: noarch
Requires: %apache_configs_dirs_name >= %apache_configs_branch
Requires: %apache_config_tool_name >= %apache_config_tool_branch
Requires: %name-base = %EVR

%description configs-A1PROXIED
This is a hack to run proxified Apache2 in case Apache1 is running.

%description -l ru_RU.UTF-8 configs-A1PROXIED
Хак для поддержки проксирования Apache2 через Apache1, при его запуске.

%package httpd-worker
Summary: High speed threaded model for Apache HTTPD 2.1
Summary(ru_RU.UTF-8): Высокоскоростная нитевая модель для Apache HTTPD 2.1
Group: System/Servers
PreReq: %name-base = %EVR
PreReq: alternatives >= 0.4
Provides: %name-mmn = %mmn
Provides: %_sbindir/%apache2_dname
Provides: %name-httpd = %EVR

%description httpd-worker
The worker MPM provides a threaded implementation for Apache HTTPD 2.1. It is
considerably faster than the traditional model, and is the recommended MPM.

Worker generally is a good choice for high-traffic servers because it
has a smaller memory footprint than the prefork MPM.

%package httpd-prefork
Summary: Traditional model for Apache HTTPD 2.1
Summary(ru_RU.UTF-8): Традиционная модель для Apache HTTPD 2.1
Group: System/Servers
PreReq: %name-base = %EVR
PreReq: alternatives >= 0.4
Provides: %name-mmn = %mmn
Provides: %_sbindir/%apache2_dname
Provides: %name-httpd = %EVR
Provides: %name-httpd-prefork-like = %EVR

%description httpd-prefork
This Multi-Processing Module (MPM) implements a non-threaded,
pre-forking web server that handles requests in a manner similar to
Apache 1.3. It is appropriate for sites that need to avoid threading for
compatibility with non-thread-safe libraries. It is also the best MPM
for isolating each request, so that a problem with a single request will
not affect any other.

It is not as fast, but is considered to be more stable.

%package httpd-event
Summary: Event driven model for Apache HTTPD 2.1
Summary(ru_RU.UTF-8): Событийная модель для Apache HTTPD 2.1
Group: System/Servers
PreReq: %name-base = %EVR
PreReq: alternatives >= 0.4
Provides: %name-mmn = %mmn
Provides: %_sbindir/%apache2_dname
Provides: %name-httpd = %EVR

%description httpd-event
The event Multi-Processing Module (MPM) is designed to allow more
requests to be served simultaneously by passing off some processing
work to supporting threads, freeing up the main threads to work on
new requests.

This MPM is especially suitable for sites that see extensive KeepAlive traffic


%package -n rpm-build-%name
Summary: RPM helper to rebuild Web servers and apps packages
Summary(ru_RU.UTF-8): Набор утилит для автоматической Web серверов и приложений
Group: Development/Other

Requires: rpm-macros-apache2 >= %get_SVR rpm-macros-apache2

%description -n rpm-build-%name
These helper provide possibility to rebuild Web servers and applications
packages by some ALT Linux Web Packaging Policy.

%description -n rpm-build-%name -l ru_RU.UTF-8
Набор утилит для обеспечения сборки пакетов веб серверов и приложений
в соответствии с ALT Linux Web Packaging Policy.

%package devel
Summary: Module development tools for the Apache web server
Summary(ru_RU.UTF-8): Средства разработки модулей для веб-сервера Apache
Group: Development/C
Obsoletes: secureweb-devel
PreReq: %name-base = %EVR
Requires: %name-httpd = %EVR

Provides: %apache2_includedir
Provides: %apache2_installbuilddir

Obsoletes: %apache2_name-libapr %apache2_name-libapr-devel %apache2_name-libapr-devel %apache2_name-libaprutil %apache2_name-libaprutil-devel %apache2_name-libaprutil-devel
Requires: %apache2_libaprutil_name-devel >= %apache2_libaprutil_evr
Requires: %apache2_libapr_name-devel >= %apache2_libapr_evr
Requires: rpm-build-%name = %EVR

%description devel
The apache-devel package contains the source code for the Apache
Web server you'll need to build Dynamic
Shared Objects (DSOs) for Apache.

If you are installing the Apache Web server and
you want to be able to compile or develop additional modules
for Apache, you'll need to install this package.

%description -l ru_RU.UTF-8 devel
Пакет содержит заголовочные файлы из исходных текстов веб-сервера Apache,
необходимые для сборки динамически подключаемых модулей (DSO).

Если Вы устанавливаете веб-сервер Apache и собираетесь компилировать или
разрабатывать для него дополнительные модули, Вам нужно установить этот пакет.

%package docs
Summary: Apache Manual
Summary(ru_RU.UTF-8): Документация по Apache
Group: Books/Other
AutoReq: no
BuildArch: noarch
Requires: %docdir

Provides: %docdir/manual

%description docs
This package contains the Apache server documentation in HTML format.

%description -l ru_RU.UTF-8 docs
Этот пакет содержит документацию к веб-серверу Apache в формате HTML.

%package manual
Summary: Apache Manual for www
Summary(ru_RU.UTF-8): Документация по Apache для www
Group: Books/Other
PreReq: %name-base = %EVR
Requires: %docdir/manual
Requires: %apache_configs_dirs_name >= %apache_configs_branch
Requires: %apache_config_tool_name >= %apache_config_tool_branch
AutoReq: no
BuildArch: noarch

%description manual
This package contains the Apache server documentation in HTML format,
for www server using.

%description -l ru_RU.UTF-8 manual
Этот пакет содержит документацию к веб-серверу Apache в формате HTML,
для применения на www сервере.

%package manual-addons
Summary: manual-addons dir
Summary(ru_RU.UTF-8): Каталог manual-addons
Group: Books/Other
BuildArch: noarch
PreReq: webserver-common

%description manual-addons
This package contains the manual-addons dir for Apache server.

%description -l ru_RU.UTF-8 manual-addons
Этот пакет содержит каталог manual-addons для веб-сервера Apache.

%package datadirs
Summary: data dirs for Apache
Summary(ru_RU.UTF-8): каталоги данных для Apache
Group: System/Servers
BuildArch: noarch

Provides: %_datadir/%name
Provides: %_datadir/%name/cgi-bin

%description datadirs
This package contains the Apache server data dirs.

%description -l ru_RU.UTF-8 datadirs
Этот пакет содержит каталоги данных к веб-серверу Apache.

%package cgi-bin-test-cgi
Summary: cgi-bin/test-cgi for Apache
Summary(ru_RU.UTF-8): cgi-bin/test-cgi для Apache
Group: System/Servers
BuildArch: noarch
PreReq: webserver-common
PreReq: %_sysconfdir/control.d/webserver-cgi-bin-functions
Provides: webserver-cgi-bin-test-cgi
Conflicts: apache-cgi-bin-test-cgi
Conflicts: apache2-cgi-bin < 2.2.9-alt10
Conflicts: apache-common < 1.3.37rusPL30.23-alt1.1

Requires: %_datadir/%name/cgi-bin

%description cgi-bin-test-cgi
This package contains the Apache server test-cgi scripts.

%description -l ru_RU.UTF-8 cgi-bin-test-cgi
Этот пакет содержит test-cgi скрипт для веб-сервера Apache.

%package cgi-bin-printenv
Summary: cgi-bin/printenv for Apache
Summary(ru_RU.UTF-8): cgi-bin/printenv для Apac`he
Group: System/Servers
BuildArch: noarch
PreReq: webserver-common
PreReq: %_sysconfdir/control.d/webserver-cgi-bin-functions
Provides: webserver-cgi-bin-printenv
Conflicts: apache-cgi-bin-printenv
Conflicts: apache2-cgi-bin < 2.2.9-alt10
Conflicts: apache-common < 1.3.37rusPL30.23-alt1.1

Requires: %_datadir/%name/cgi-bin

%description cgi-bin-printenv
This package contains the Apache server printenv scripts.

%description -l ru_RU.UTF-8 cgi-bin-printenv
Этот пакет содержит printenv скрипт для веб-сервера Apache.

%package cgi-bin
Summary: cgi-bin for Apache
Summary(ru_RU.UTF-8): cgi-bin для Apache
Group: System/Servers
BuildArch: noarch
Provides: webserver-cgi-bin
Requires: %name-cgi-bin-test-cgi = %EVR
Requires: %name-cgi-bin-printenv = %EVR
Conflicts: apache-common <= 1.3.42rusPL30.24-alt9
Conflicts: apache-cgi-bin

%description cgi-bin
This package contains the Apache server cgi-bin dir and cgi scripts.

%description -l ru_RU.UTF-8 cgi-bin
Этот пакет содержит каталог cgi-bin с типовыми скриптами к веб-серверу Apache.

%package html
Summary: html for Apache
Summary(ru_RU.UTF-8): html для Apache
Group: System/Servers
BuildArch: noarch
PreReq: webserver-common
Provides: webserver-html
Conflicts: apache-common <= 1.3.42rusPL30.24-alt9
Conflicts: apache-html

%description html
This package contains the Apache server html dir.

%description -l ru_RU.UTF-8 html
Этот пакет содержит каталог html для веб-сервера Apache.

%package icons
Summary: icons for Apache
Summary(ru_RU.UTF-8): icons для Apache
Group: System/Servers
BuildArch: noarch
PreReq: webserver-common
Provides: webserver-icons
Conflicts: apache-common <= 1.3.42rusPL30.24-alt9
Conflicts: apache-icons

%description icons
This package contains the Apache server icons dir.

%package mod_ssl
Group: System/Servers
Summary: SSL/TLS module for the Apache HTTP server
PreReq: %name-base = %EVR
Requires: %name-mmn = %mmn
Requires: %apache_configs_dirs_name >= %apache_configs_branch
Requires: %apache_config_tool_name >= %apache_config_tool_branch
Requires: %apache2_libaprutil_name >= %apache2_libaprutil_evr
Requires: %apache2_libapr_name >= %apache2_libapr_evr

Conflicts: apache2-mod_ssl-compat <= 2.2.22-alt14

Provides: %apache2_proxycachedir/mod_ssl

%description mod_ssl
The mod_ssl module provides strong cryptography for the Apache Web
server via the Secure Sockets Layer (SSL) and Transport Layer
Security (TLS) protocols.

%package mod_ldap
Group: System/Servers
Summary: Modules LDAP support for the Apache HTTP server
PreReq: %name-base = %EVR
Requires: %name-mmn = %mmn
Requires: %apache2_libaprutil_name >= %apache2_libaprutil_evr
Requires: %apache2_libapr_name >= %apache2_libapr_evr
Provides: %name-mod_authnz_ldap = %EVR

%description mod_ldap
This package contains the modules:
mod_ldap -- LDAP connection pooling and result caching services for use by
    other LDAP modules.
mod_authnz_ldap -- Allows an LDAP directory to be used to store the database
    for HTTP Basic authentication.

%package mod_cache_disk
Group: System/Servers
Summary: Module supported content cache storage for the Apache HTTP server
PreReq: %name-base = %EVR
Requires: %name-mmn = %mmn
Requires: %apache2_libaprutil_name >= %apache2_libaprutil_evr
Requires: %apache2_libapr_name >= %apache2_libapr_evr
Requires: %_sbindir/%apache2_htcacheclean_dname
Provides: %apache2_htcacheclean_cachepath

Conflicts: apache2-common < 2.2.19-alt1.1
Obsoletes: apache2-mod_disk_cache


%description mod_cache_disk
This package contains the module mod_cache_disk (ex.mod_disk_cache)

%package htcacheclean-control
Summary: Control rules for htcacheclean
Group: System/Servers
BuildArch: noarch

%description htcacheclean-control
This package contains control rules for the htcacheclean.
See control(8) for details.

%package htcacheclean
Summary: Clean up the cache disk for Apache
Group: System/Servers
Requires: %apache2_htcacheclean_cachepath
Requires: %name-base = %EVR
Requires: %_controldir/htcacheclean-run
Requires: %_controldir/htcacheclean-mode

%description htcacheclean
Htcacheclean is used to keep the size of mod_cache_disk's storage within
a certain limit. This tool can run either manually or in daemon mode.

%package ab
Summary: Apache HTTP server benchmarking tool
Group: System/Servers
Conflicts: apache2-base < 2.2.22-alt9
Conflicts: apache-common <= 1.3.42rusPL30.24-alt9

%description ab
Ab is a tool for benchmarking your Apache Hypertext Transfer Protocol
(HTTP) server. It is designed to give you an impression of how your
current Apache installation performs. This especially shows you how many
requests per second your Apache installation is capable of serving.

%package htpasswd
Summary: Manage user files for basic authentication
Group: System/Servers
Conflicts: apache2-base < 2.2.22-alt9
Conflicts: apache-common <= 1.3.42rusPL30.24-alt9

%description htpasswd
Htpasswd is used to create and update the flat-files used to store
usernames and password for basic authentication of HTTP users.
If htpasswd cannot access a file, such as not being able to write to
the output file or not being able to read the file in order to update
it, it returns an error status and makes no changes.

%package suexec
Summary: Suexec binary for Apache
Summary(ru_RU.UTF-8): Программа suexec для Apache
Summary(uk_UA.UTF-8): Програма suexec для Apache
Group: System/Servers
PreReq: %name-base = %EVR
Requires: %name-mmn = %mmn
Requires: %apache2_libaprutil_name >= %apache2_libaprutil_evr
Requires: %apache2_libapr_name >= %apache2_libapr_evr
Requires: %apache_configs_dirs_name >= %apache_configs_branch
Requires: %apache_config_tool_name >= %apache_config_tool_branch

%description suexec
This package adds suexec to Apache. Suexec provides Apache users the ability
to run CGI and SSI programs under user IDs different from the user ID of the
calling web-server. Normally, when a CGI or SSI program executes, it runs as
the same user who is running the web server.

%description -l ru_RU.UTF-8 suexec
Этот пакет добавляет к Apache suexec. Эта программа позволяет запускать CGI-
и SSI-программы под идентификаторами пользователя, отличными от UID
веб-сервера.

%description -l uk_UA.UTF-8 suexec
Цей пакунок додає до Apache suexec. Ця програма дозволяє запускати CGI-
та SSI-програми під ідентифікаторами користувача, що відрізняються від
UID веб-серверу.

%package compat
Summary: Set DocumentRoot in %apache2_serverdatadir
Summary(ru_RU.UTF-8): Установка DocumentRoot в %apache2_serverdatadir
Group: System/Servers
BuildArch: noarch
Requires: %name-base = %EVR
Requires: %apache_configs_dirs_name >= %apache_configs_branch
Requires: %apache_config_tool_name >= 0.1.2

Provides: %apache2_compat_htdocsdir
Provides: %apache2_compat_cgibindir
Provides: %apache2_compat_iconsdir
Provides: %apache2_compat_iconssmalldir

%description compat
Set DocumentRoot in %apache2_serverdatadir to support the old configurations.

%description -l ru_RU.UTF-8 compat
Установка DocumentRoot в %apache2_serverdatadir для поддержки старых конфигураций.

%package mod_ssl-compat
Summary: Set DocumentRoot in %apache2_serverdatadir (for https)
Summary(ru_RU.UTF-8): Установка DocumentRoot в %apache2_serverdatadir (для https)
Group: System/Servers
BuildArch: noarch
Requires: %name-compat = %EVR
Requires: %name-mod_ssl = %EVR
Requires: %apache_configs_dirs_name >= %apache_configs_branch
Requires: %apache_config_tool_name >= %apache_config_tool_branch

%description mod_ssl-compat
Set DocumentRoot in %apache2_serverdatadir (for https) to support the old configurations.

%description -l ru_RU.UTF-8 mod_ssl-compat
Установка DocumentRoot в %apache2_serverdatadir для поддержки старых конфигураций (https).


%add_findprov_lib_path %apache2_libdir

%prep
%setup -q -n httpd-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1 -b .orig
%patch4 -p2
%patch6 -p1

# generate ALTLinux Apache layout
echo "
# ALT layout
<Layout ALTLinux>
    prefix:		%apache2_basedir
    exec_prefix:	%prefix
    bindir:		%_bindir
    sbindir:		%_sbindir
    libdir:		%apache2_libdir
    libexecdir:		%apache2_moduledir
    mandir:		%_mandir
    sysconfdir:		%apache2_confdir
    datadir:		%apache2_datadir
    iconsdir:		%apache2_iconsdir
    htdocsdir:		%apache2_htdocsdir
    manualdir:		%apache2_manualdir
    cgidir:		%apache2_cgibindir
    includedir:		%apache2_includedir
    localstatedir:	%_var
    runtimedir:		%apache2_runtimedir
    logfiledir:		%apache2_logfiledir
    proxycachedir:	%apache2_proxycachedir
    infodir:		%_infodir
    installbuilddir:	%apache2_installbuilddir
    errordir:		%apache2_errordir
</Layout>
" >> config.layout

# Safety check: prevent build if defined MMN does not equal upstream MMN.
vmmn=`echo MODULE_MAGIC_NUMBER_MAJOR | cpp -include $PWD/include/ap_mmn.h | grep -e '^[0-9]'`
if [ "$vmmn" != "%mmn" ]; then
   : Error: Upstream MMN is now ${vmmn}, packaged MMN is %mmn.
   : Update the mmn macro and rebuild.
   exit 1
fi

%build
function mpmbuild()
{
mpm=$1; shift
mkdir $mpm; pushd $mpm
cat > config.cache <<EOF
ac_cv_func_pthread_mutexattr_setpshared=no
ac_cv_func_sem_open=no
EOF
../configure -C \
	--enable-layout=ALTLinux \
	--with-pcre=%_usr/bin/pcre-config \
	--with-perl=/usr/bin/perl \
	--with-apr=%apache2_apr_config \
	--with-apr-util=%apache2_apu_config \
	--enable-suexec --with-suexec \
	--with-suexec-caller=%apache2_user \
	--with-suexec-docroot=%apache2_suexec_docroot \
	--with-suexec-logfile=%apache2_logfiledir/suexec.log \
	--with-suexec-bin=%_sbindir/suexec%apache2_branch \
	--with-suexec-uidmin=500 --with-suexec-gidmin=500 \
	--with-suexec-userdir=public_html \
	--enable-so \
	--with-mpm=$mpm \
        --with-devrandom \
        --with-ldap --enable-ldap --enable-auth-ldap --enable-authnz-ldap \
        --enable-cache --enable-disk-cache --enable-mem-cache \
	--enable-ssl --with-ssl \
	--enable-deflate --enable-cgid \
	--enable-proxy --enable-proxy-connect \
	--enable-proxy-http --enable-proxy-ftp \
	--enable-charset_lite=shared \
	--enable-unixd --enable-mods-static='unixd' \
	$*

%make_build
popd
}

ln -snf %_datadir/apr-1/build/PrintPath build/PrintPath
libtoolize --install
autoheader
autoconf -I %_datadir/apr-1

# Only bother enabling optional modules for main build.
mpmbuild prefork --enable-mods-shared=all --with-program-name=%apache2_dname

# To prevent most modules being built statically into httpd.worker,
# easiest way seems to be enable them shared.
mpmbuild worker --enable-mods-shared=all  --with-program-name=%apache2_dname

mpmbuild event --enable-mods-shared=all  --with-program-name=%apache2_dname

# Verify that the same modules were built into the two httpd binaries
./prefork/%apache2_dname -l | grep -v prefork > prefork.mods
./worker/%apache2_dname -l | grep -v worker > worker.mods
./event/%apache2_dname -l | grep -v event > event.mods
if ( ! diff -u prefork.mods worker.mods ) \
	|| ( ! diff -u prefork.mods event.mods ) \
#	|| ( ! diff -u prefork.mods itk.mods ) \
#	|| ( ! diff -u prefork.mods peruser.mods ) \
then
  : Different modules built into httpd binaries, will not proceed
  exit 1
fi

%install
# Install README.ALT
install -m 644 %SOURCE12 ./
install -m 644 %SOURCE14 ./

# Generate sed script for substitute the real paths in configs
echo '
s|@@Port@@|80|g
s|@@SSLPort@@|443|g
s|@@SSLCertificateFile@@|%apache2_sslcertificatefile|g
s|@@SSLCertificateFile-dsa@@|%apache2_sslcertsdir/%apache2_sslcertname-dsa.%apache2_sslcertext|g
s|@@SSLCertificateKeyFile@@|%apache2_sslcertificatekeyfile|g
s|@@SSLCertificateKeyFile-dsa@@|%apache2_sslkeysdir/%apache2_sslcertname-dsa.key|g
s|@@SSLCertificateChainFile@@|%apache2_sslcertsdir/ca-root.pem|g
s|@@SSLCACertificatePath@@|%apache2_sslcertsdir|g
s|@@SSLCACertificateFile@@|%apache2_sslcertsdir/ca-root.pem|g
s|@@SSLCARevocationPath@@|%apache2_sslcertsdir|g
s|@@SSLCARevocationFile@@|%apache2_sslcertsdir/ca-bundle.crl|g
s|@vhosts_dir@|%apache2_vhostdir|g
s|@htcacheclean_cachepath@|%apache2_htcacheclean_cachepath|g
s|@SERVER@|%apache2_dname|g
s|@LOCKFILE@|%apache2_httpdlockfile|g
s|@RPMTRIGGERDIR@|%apache2_rpmfiletriggerdir|g
s|@RPMTRIGGERSTARTFILE@|%apache2_rpmhttpdstartfile|g
s|@RUNDIR@|%condstopstart_webrundir|g
s|%%apache2_branch|%apache2_branch|g
s|%%apache2_sslcertshfunctions|%apache2_sslcertshfunctions|g
s|%%apache2_sslcertsh|%apache2_sslcertsh|g
' >> SetMacros.sed


pushd prefork
make DESTDIR=%buildroot install
popd
mv %buildroot%_sbindir/%apache2_dname %buildroot%_sbindir/%apache2_dname.prefork

# install worker binary
WDIR=worker
install -m 755 $WDIR/%apache2_dname %buildroot%_sbindir/%apache2_dname.worker

# install event binary
WDIR=event
install -m 755 $WDIR/%apache2_dname %buildroot%_sbindir/%apache2_dname.event

#-----------------------------------------------------------------------------------
# Tune up executibles to co-exist with apache-ru
#
pushd %buildroot%_sbindir
#fix attributes of suexec for rpm build
chmod 755 suexec
%if "%apache2_branch" != ""
#rename suexec binary to be named that apache is expect it to be
ln -s suexec suexec%apache2_branch
#
# compatability symlinks for tools in /usr/sbin
# Maybe it's better to push ru-apache-devel before installing devel package
rm envvars-std
for tool in apachectl checkgid envvars rotatelogs fcgistarter htcacheclean; do
    ln -s ${tool} ${tool}%apache2_branch
done
# compatability symlinks for tools in /usr/bin 
pushd %buildroot%_bindir
TOOLS="ab htdbm logresolve htpasswd apxs dbmmanage httxt2dbm htdigest check_forensic"
for tool in $TOOLS; do
    ln -s ${tool} %buildroot%_bindir/${tool}%apache2_branch
done
popd
%endif
popd
#
#-----------------------------------------------------------------------------------

pushd %buildroot%apache2_confdir
tar xvSf %SOURCE11
popd

mkdir -p %buildroot%_altdir
pushd %buildroot%_altdir
tar xvSf %SOURCE13
popd

# mod_ssl bits
for suffix in crl crt csr key prm; do
   mkdir %buildroot%apache2_confdir/ssl.${suffix}
done
# create a prototype server.{crt,key}
touch %buildroot%apache2_confdir/ssl.crt/server.crt
touch %buildroot%apache2_confdir/ssl.key/server.key

# for holding mod_dav lock database
mkdir -p %buildroot%_var/lib/dav

# create a prototype session cache
mkdir -p %buildroot%apache2_proxycachedir/mod_ssl
touch %buildroot%apache2_proxycachedir/mod_ssl/scache.{dir,pag,sem}

# create spools
install -d %buildroot%apache2_spooldir/{,tmp,sessions,uploads}

# create lock dir
install -d %buildroot%apache2_lockdir

# create dir for mod_cache_disk
install -d %buildroot%apache2_htcacheclean_cachepath

# Make the MMN accessible to module packages
echo %mmn > %buildroot%apache2_includedir/.mmn

# symlinks for /etc/httpd2
ln -snf $(relative %buildroot%apache2_logfiledir %buildroot%apache2_loglink) %buildroot%apache2_loglink
ln -snf $(relative %buildroot%apache2_runtimedir %buildroot%apache2_runtimelink) %buildroot%apache2_runtimelink
ln -snf $(relative %buildroot%apache2_moduledir %buildroot%apache2_modulelink) %buildroot%apache2_modulelink
ln -snf $(relative %buildroot%apache2_installbuilddir %buildroot%apache2_basedir/build) %buildroot%apache2_basedir/build
ln -snf $(relative %buildroot%apache2_spooldir/uploads %buildroot%apache2_uploadslink) %buildroot%apache2_uploadslink
ln -snf $(relative %buildroot%apache2_lockdir %buildroot%apache2_locklink) %buildroot%apache2_locklink

# create config dirs for additional modules and Virtual hosts
mkdir %buildroot%apache2_addonconfdir

#------------------------------------------------------------------------------------
# tune up configuration files

# Install conf/*-start.d/*.conf
for d in mods ports sites extra; do
	find docs/conf/$d-start.d/ -maxdepth 1 -name '*.conf' -type f -print0 | \
		xargs -r0 install -D -t %buildroot%apache2_confdir/$d-start.d/
done

pushd %buildroot%apache2_confdir

find -type f -print0 | \
	xargs -r0 sed -i -e 's/^\([[:space:]]*User\)[[:space:]]\+.*/\1 %apache2_user/
s/^\([[:space:]]*Group\)[[:space:]]\+.*/\1 %apache2_group/
s/^\([[:space:]]*ServerAdmin\)[[:space:]]\+you/\1 %apache2_webmaster/
' httpd*.conf

# create conf/*-enabled/* for %%ghost
for d in mods ports sites extra; do
	pushd $d-available/
	find -maxdepth 1 \( -name '*.conf' -o -name '*.load' \) -type f -print0 | \
		(cd ../$d-enabled/ && xargs -r0 touch)
	popd
done
pushd sites-available/
find -maxdepth 1 \( -name 'default*.conf' -o -name 'default*.load' \) -type f -print0 | \
	sed -zr 's@^(.*/)?default@\1000-default@' | \
	(cd ../sites-enabled/ && xargs -r0 touch)
popd
popd

#------------------------------------------------------------------------------------

#install ALT misc documentation and logos

# Move .../conf/original to %%docdir/original
install -d %buildroot%docdir/
mv %buildroot%apache2_confdir/original %buildroot%docdir/original
ln -snf $(relative %buildroot%docdir/original %buildroot%apache2_confdir/original) %buildroot%apache2_confdir/original

# docroot
# Move %%apache2_manualdir to %%docdir/manual
mv %buildroot%apache2_manualdir %buildroot%docdir/manual
ln -snf $(relative %buildroot%docdir/manual %buildroot%apache2_manualdir) %buildroot%apache2_manualdir

# install docs to %%docdir/
cp -r ABOUT_APACHE README CHANGES LICENSE README.ALT* %buildroot%docdir/

# install the daemon start script
install -pD -m755 %SOURCE18 \
	%buildroot%_sbindir/%apache2_htcacheclean_dname-daemon-start

# install the init scripts
install -pD -m755 %SOURCE35 \
	%buildroot%_initdir/%apache2_dname
install -pD -m755 %SOURCE36 \
	%buildroot%_initdir/%apache2_htcacheclean_dname
install -pD -m644 %SOURCE37 \
	%buildroot%_unitdir/%apache2_dname.service
install -pD -m644 %SOURCE38 \
	%buildroot%_unitdir/%apache2_htcacheclean_dname.service

# install sysconfig settings file
install -pD -m 600 %SOURCE16 %buildroot%apache2_envconf
install -pD -m 644 %SOURCE17 %buildroot%_sysconfdir/sysconfig/%apache2_htcacheclean_dname

# install the cron script
install -pD -m 755 %SOURCE19 \
	%buildroot%_sysconfdir/cron.daily/%apache2_htcacheclean_dname

# Generate logrotate file
mkdir -p %buildroot%_sysconfdir/logrotate.d
echo '%apache2_logfiledir/*log {
	missingok
	notifempty
	sharedscripts
	create 0644 root %apache2_group
	delaycompress
	postrotate
	/sbin/service %apache2_dname condreload >/dev/null
	endscript
}
'>%buildroot%_sysconfdir/logrotate.d/%apache2_name

# install addon documentation old root
mkdir -p %buildroot%apache2_compat_manualaddonsdir/

###
## now remove installed files we ain't gonna use
#
rm -f %buildroot%apache2_installbuilddir/config.nice \
	%buildroot%apache2_moduledir/httpd.exp \
	%buildroot%apache2_installbuilddir/mkdir.sh \
	%buildroot%apache2_errordir/README

# create old apache2 dirs
mkdir -p %buildroot%apache2_compat_htdocsdir/
mkdir -p %buildroot%apache2_compat_cgibindir/
mkdir -p %buildroot%apache2_compat_iconsdir/
mkdir -p %buildroot%apache2_compat_iconssmalldir/

# Install scripts for control
install -pD %SOURCE40 %buildroot%_controldir/cgi-bin_test-cgi
install -pD %SOURCE41 %buildroot%_controldir/cgi-bin_printenv
install -pD %SOURCE42 %buildroot%_controldir/htcacheclean-run
install -pD %SOURCE43 %buildroot%_controldir/htcacheclean-mode

# Create datadirs
install -d %buildroot%_datadir/%name/cgi-bin/

# Move cgi scripts to data dirs
mv %buildroot%apache2_cgibindir/* %buildroot%_datadir/%name/cgi-bin/

# Install RPM FileTrigger
install -pD %SOURCE50 %buildroot%_rpmlibdir/00-%apache2_name.filetrigger
install -pD %SOURCE51 %buildroot%_rpmlibdir/zz80-%apache2_name-base.filetrigger
install -pD %SOURCE52 %buildroot%_rpmlibdir/90-%apache2_name-base-a2chkconfig.filetrigger
install -pD %SOURCE53 %buildroot%_rpmlibdir/90-%apache2_name-base-httpd.filetrigger
install -pD %SOURCE54 %buildroot%_rpmlibdir/90-%apache2_name-htcacheclean.filetrigger
install -pD %SOURCE55 %buildroot%_rpmlibdir/zz90-%apache2_name-htcacheclean.filetrigger
install -pD %SOURCE56 %buildroot%_rpmlibdir/zzzz-%apache2_name.filetrigger

# Install scripts for condstopstart-web
install -pD %SOURCE60 %buildroot%condstopstart_webdir/%apache2_dname-condstop
ln -s %apache2_dname-condstop %buildroot%condstopstart_webdir/%apache2_dname-condstop-rpm
install -pD %SOURCE62 %buildroot%condstopstart_webdir/%apache2_dname-condstart
install -pD %SOURCE63 %buildroot%condstopstart_webdir/%apache2_dname-condstart-rpm

# Install config for tempfiles
install -pD -m 644 %SOURCE15 %buildroot%_tmpfilesdir/%name.conf

# Install scripts for SSL cert
install -pD -m 644 %SOURCE70 %buildroot%apache2_sslcertshfunctions
install -pD -m 755 %SOURCE71 %buildroot%apache2_sslcertsh

# Substitute the real paths in configs
find %buildroot%_sysconfdir original %buildroot%_rpmlibdir %buildroot%condstopstart_webdir %buildroot%_sbindir/apachectl* \
		%buildroot%_unitdir %buildroot%_sbindir/%apache2_htcacheclean_dname-daemon-start \
		%buildroot%{apache2_sslcertsh}* \
		-type f -print0 \
	| xargs -r0 sed -i -f SetMacros.sed

mkdir -p %buildroot%_rpmlibdir
cat <<\EOF >%buildroot%_rpmlibdir/%name-files.req.list
# %name dirlist for %_rpmlibdir/files.req
%apache2_addonconfdir/	%name-base
%apache2_serverdatadir/	%name-base
%apache2_errordir/	%name-base
%apache2_errordir/include/	%name-base
%_var/lib/dav	%name-base
%apache2_proxycachedir/	%name-base
%apache2_spooldir/	%name-base
%apache2_spooldir/tmp/	%name-base
%apache2_spooldir/sessions/	%name-base
%apache2_spooldir/uploads/	%name-base
%apache2_lockdir/	%name-base
%apache2_basedir/	%name-base
%apache2_confdir/	%name-base
%apache2_confdir_inc/	%name-base
%apache2_extra_available/	%name-base
%apache2_extra_enabled/	%name-base
%apache2_extra_start/	%name-base
%apache2_mods_available/	%name-base
%apache2_mods_enabled/	%name-base
%apache2_mods_start/	%name-base
%apache2_ports_available/	%name-base
%apache2_ports_enabled/	%name-base
%apache2_ports_start/	%name-base
%apache2_sites_available/	%name-base
%apache2_sites_enabled/	%name-base
%apache2_sites_start/	%name-base
%apache2_libdir/	%name-base
%apache2_moduledir/	%name-base
%apache2_modulelink/	%name-base
%apache2_logfiledir/	%name-base
%apache2_runtimedir/	%name-base
%_datadir/%name/	%name-datadirs
%_datadir/%name/cgi-bin/	%name-datadirs
%apache2_proxycachedir/mod_ssl/	%name-mod_ssl
%apache2_htcacheclean_cachepath/	%name-mod_cache_disk
%apache2_includedir/	%name-devel
%apache2_installbuilddir/	%name-devel
%apache2_compat_htdocsdir/	%name-compat
%apache2_compat_cgibindir/	%name-compat
%apache2_compat_iconsdir/	%name-compat
%apache2_compat_iconssmalldir/	%name-compat
EOF

mkdir -p %buildroot%_rpmmacrosdir
cat <<\EOF >%buildroot%_rpmmacrosdir/%macrosname
# Macros for build %name-mod_*
%%%{name}_mmn	%mmn
EOF

#============ S C R I P T S ==================================================
#
#
%pre base
# Create user and groups
%_sbindir/groupadd -r -f %apache2_group 2>/dev/null ||:
%_sbindir/groupadd -r -f %apache2_webmaster 2>/dev/null ||:
%_sbindir/useradd -g %apache2_group -c 'Apache2 WWW server' -d %apache2_datadir -s '/dev/null' \
	-G %webserver_group -r %apache2_user 2>/dev/null || :
if LANG=C %_bindir/id %apache2_user 2>/dev/null | \
		grep -qv "groups=[^[:space:]]*(%webserver_group)"; then
	echo 'Warning: User %apache2_user was not included in the group %webserver_group!'
	%_bindir/gpasswd -a %apache2_user %webserver_group
	echo '     Added user %apache2_user to group %webserver_group.'
fi
if [ $1 -eq 2 ]; then
	if [ -e %apache2_conf ] && \
			! (grep -qs -m1 '^[[:space:]]*[Ii][Nn][Cc][Ll][Uu][Dd][Ee][[:space:]]\+conf/ports-enabled' %apache2_conf && \
			grep -qs -m1 '^[[:space:]]*[Ii][Nn][Cc][Ll][Uu][Dd][Ee][[:space:]]\+conf/mods-enabled' %apache2_conf && \
			grep -qs -m1 '^[[:space:]]*[Ii][Nn][Cc][Ll][Uu][Dd][Ee][[:space:]]\+conf/sites-enabled' %apache2_conf && \
			grep -qs -m1 '^[[:space:]]*[Ii][Nn][Cc][Ll][Uu][Dd][Ee][[:space:]]\+conf/extra-enabled' %apache2_conf) ; then
		echo 'Warning: configuration files %apache2_conf is old!'
		echo '    Renamed old file %apache2_conf'
		echo '    to %apache2_conf.rpmsave'
		mv %apache2_conf %apache2_conf.rpmsave
	fi
	if [ -e %apache2_confdir/%apache2_dname.worker.conf ] && \
			[ ! -L %apache2_confdir/%apache2_dname.worker.conf ]; then
		echo 'Warning: original configuration files %apache2_confdir/%apache2_dname.worker.conf'
		echo '    saved as %apache2_confdir/%apache2_dname.worker.conf.rpmold'
		mv %apache2_confdir/%apache2_dname.worker.conf %apache2_confdir/%apache2_dname.worker.conf.rpmold
	fi
fi
exit 0

%preun base
if [ $1 -eq 0 ]; then
    %preun_service %apache2_dname
fi
exit 0

%post base
if [ ! -e %apache2_conf ] && \
		[ -e %apache2_conf.rpmnew ]; then
	mv %apache2_conf.rpmnew %apache2_conf
fi
if [ $1 -eq 1 ]; then
	%post_service %apache2_dname
fi
exit 0



%pre manual
if [ $1 -eq 2 ] && \
		[ -e %apache2_manualdir ] && \
		[ ! -L %apache2_manualdir ] ; then
	echo 'Warning: original %apache2_manualdir not symlink!'
	echo '    Saved as %apache2_manualdir.rpmold'
	mv %apache2_manualdir %apache2_manualdir.rpmold
fi
exit 0

%pre htcacheclean
%pre_control htcacheclean-run
%pre_control htcacheclean-mode
exit 0

%preun htcacheclean
if [ $1 -eq 0 ]; then
    %preun_service %apache2_htcacheclean_dname
fi
exit 0

%post htcacheclean
%post_apache2_rpmrenamevarinconfig %_sysconfdir/sysconfig/%apache2_htcacheclean_dname CACHEPATH HTCACHECLEAN_PATH
%post_apache2_rpmrenamevarinconfig %_sysconfdir/sysconfig/%apache2_htcacheclean_dname INTERVAL HTCACHECLEAN_DAEMON_INTERVAL
%post_apache2_rpmrenamevarinconfig %_sysconfdir/sysconfig/%apache2_htcacheclean_dname LIMIT HTCACHECLEAN_SIZE
%post_apache2_rpmrenamevarinconfig %_sysconfdir/sysconfig/%apache2_htcacheclean_dname OPTIONS HTCACHECLEAN_OPTIONS
%post_control -s auto htcacheclean-run
%post_control -s daemon htcacheclean-mode
if [ $1 -eq 1 ]; then
	%post_service %apache2_htcacheclean_dname
fi
exit 0

%pre cgi-bin-test-cgi
%pre_webserver_cgi_bin_control cgi-bin_test-cgi

%post cgi-bin-test-cgi
%post_webserver_cgi_bin_control -s symlink_root_noexec cgi-bin_test-cgi

%preun cgi-bin-test-cgi
%preun_webserver_cgi_bin_control cgi-bin_test-cgi

%postun cgi-bin-test-cgi
%postun_webserver_cgi_bin_control -s symlink_root_noexec cgi-bin_test-cgi

%triggerpostun cgi-bin-test-cgi -- apache-common < 1.3.37rusPL30.23-alt1.1, apache-cgi-bin < 1.3.41rusPL30.23-alt4.7.3, apache2-cgi-bin < 2.2.9-alt10, apache2-cgi-bin-test-cgi
%triggerpostun_webserver_cgi_bin_control -s symlink_root_noexec cgi-bin_test-cgi

%pre cgi-bin-printenv
%pre_webserver_cgi_bin_control cgi-bin_printenv

%post cgi-bin-printenv
%post_webserver_cgi_bin_control -s symlink_root_noexec cgi-bin_printenv

%preun cgi-bin-printenv
%preun_webserver_cgi_bin_control cgi-bin_printenv

%postun cgi-bin-printenv
%postun_webserver_cgi_bin_control -s symlink_root_noexec cgi-bin_printenv

%triggerpostun cgi-bin-printenv -- apache-common < 1.3.37rusPL30.23-alt1.1, apache-cgi-bin < 1.3.41rusPL30.23-alt4.7.3, apache2-cgi-bin < 2.2.9-alt10, apache2-cgi-bin-printenv
%triggerpostun_webserver_cgi_bin_control -s symlink_root_noexec cgi-bin_printenv


%files mods
%config(noreplace) %apache2_mods_available/*.load
%config(noreplace) %apache2_mods_available/*.conf
%ghost %apache2_mods_enabled/*.load
%ghost %apache2_mods_enabled/*.conf
%exclude %apache2_mods_available/ssl.load
%exclude %apache2_mods_available/ssl.conf
%exclude %apache2_mods_available/*ldap.load
%exclude %apache2_mods_available/cache_disk.*
%exclude %apache2_mods_enabled/ssl.load
%exclude %apache2_mods_enabled/ssl.conf

%doc %docdir/original/mods-available/*.load
%doc %docdir/original/mods-available/*.conf
%exclude %docdir/original/mods-available/ssl.load
%exclude %docdir/original/mods-available/ssl.conf
%exclude %docdir/original/mods-available/cache_disk.*

# everything but mod_ssl.so:
%apache2_moduledir/mod_*.so
%exclude %apache2_moduledir/mod_ssl.so
%exclude %apache2_moduledir/mod_*ldap.so
%exclude %apache2_moduledir/mod_suexec.so
%exclude %apache2_moduledir/mod_cache_disk.so

%files httpd-worker
%_sbindir/%apache2_dname.worker
%_altdir/%name-httpd-worker

%files httpd-prefork
%_sbindir/%apache2_dname.prefork
%_altdir/%name-httpd-prefork

%files httpd-event
%_sbindir/%apache2_dname.event
%_altdir/%name-httpd-event

%files

%files base
%doc %dir %docdir/
%doc %docdir/original
%exclude %docdir/original/mods-available/*
%doc %docdir/ABOUT_APACHE
%doc %docdir/README*
%doc %docdir/CHANGES
%doc %docdir/LICENSE

%config %_tmpfilesdir/*

%attr(2770,root,%apache2_group) %dir %apache2_proxycachedir/
%attr(750,root,%apache2_group) %dir %apache2_spooldir/
%attr(2770,root,%apache2_group) %dir %apache2_spooldir/tmp/
%attr(2770,root,%apache2_group) %dir %apache2_spooldir/sessions/
%attr(2770,root,%apache2_group) %dir %apache2_spooldir/uploads/
%attr(2770,root,%apache2_group) %dir %apache2_lockdir
%attr(0750,root,%apache2_group) %dir %apache2_logfiledir/
%attr(0750,root,%apache2_group) %dir %apache2_runtimedir/
%dir %apache2_libdir/
%dir %apache2_moduledir/

%dir %apache2_basedir/
%apache2_loglink
%apache2_runtimelink
%apache2_modulelink
%apache2_uploadslink
%apache2_locklink

%dir %apache2_confdir/
%dir %apache2_confdir_inc/
%dir %apache2_extra_available/
%dir %apache2_extra_enabled/
%dir %apache2_extra_start/
%dir %apache2_mods_available/
%dir %apache2_mods_enabled/
%dir %apache2_mods_start/
%dir %apache2_ports_available/
%dir %apache2_ports_enabled/
%dir %apache2_ports_start/
%dir %apache2_sites_available/
%dir %apache2_sites_enabled/
%dir %apache2_sites_start/

%apache2_confdir/original
%config(noreplace) %apache2_confdir/magic
%config(noreplace) %apache2_confdir/mime.types
%config(noreplace) %apache2_confdir_inc/*.conf

%config(noreplace) %apache2_conf
%config(noreplace) %apache2_mods_start/*.conf
%exclude %apache2_mods_start/*-manual*.conf
%config(noreplace) %apache2_ports_available/*.conf
%ghost %apache2_ports_enabled/*.conf
%config(noreplace) %apache2_ports_start/*.conf
%exclude %apache2_ports_available/http-A1PROXIED.conf
%exclude %apache2_ports_enabled/http-A1PROXIED.conf
%exclude %apache2_ports_start/020-A1PROXIED.conf
%config(noreplace) %apache2_sites_available/*.conf
%config(noreplace) %apache2_sites_start/*.conf
%exclude %apache2_sites_available/default-compat.conf
%exclude %apache2_sites_available/default_https-compat.conf
%exclude %apache2_sites_enabled/default_https.conf
%exclude %apache2_sites_enabled/000-default_https.conf
%exclude %apache2_sites_enabled/vhosts-A1PROXIED.conf
%exclude %apache2_sites_enabled/default-compat.conf
%exclude %apache2_sites_enabled/000-default-compat.conf
%exclude %apache2_sites_enabled/default_https-compat.conf
%exclude %apache2_sites_enabled/000-default_https-compat.conf
%exclude %apache2_sites_start/020-A1PROXIED.conf
%exclude %apache2_sites_start/*-default-compat.conf
%config(noreplace) %apache2_extra_available/*.conf
%ghost %apache2_extra_enabled/*.conf
%exclude %apache2_extra_available/httpd-manual*.conf
%exclude %apache2_extra_enabled/httpd-manual*.conf
%exclude %apache2_extra_enabled/httpd-*-compat.conf
%config(noreplace) %apache2_extra_start/*.conf
%exclude %apache2_extra_start/*-manual*.conf
%exclude %apache2_extra_start/*-default-compat.conf
%dir %apache2_addonconfdir/
%attr(0755,root,root) %apache2_sslcertsh
%config %_initdir/%apache2_dname
%_sbindir/a2*
%_sbindir/apachectl*
%attr(0600,root,root) %config(noreplace) %apache2_envconf
%_unitdir/%apache2_dname.service



%attr(0644,root,root) %config(noreplace) %_sysconfdir/logrotate.d/%apache2_name

%_bindir/ht*
%exclude %apache2_sslcertshfunctions
%exclude %_bindir/htpasswd*
%_bindir/logresolve*
%_sbindir/rotatelogs*
%exclude %_sbindir/htcacheclean*

%_sbindir/checkgid*
%_bindir/check_forensic*
%_bindir/dbmmanage*
%_sbindir/fcgistarter*

%_bindir/httxt2dbm*

%_rpmlibdir/*-%apache2_name.filetrigger
%_rpmlibdir/*-%apache2_name-base.filetrigger
%_rpmlibdir/*-%apache2_name-base-*.filetrigger

%condstopstart_webdir/%apache2_dname-cond*

%dir %apache2_serverdatadir/
%dir %apache2_errordir/
%dir %apache2_errordir/include/

%config(noreplace) %apache2_errordir/*.var
%config(noreplace) %apache2_errordir/include/*.html

%attr(0700,%apache2_user,%apache2_group) %dir %_var/lib/dav

%_mandir/man1/*
%exclude %_mandir/man1/htpasswd*
%exclude %_mandir/man1/ab*
%exclude %_mandir/man1/apxs*

%_mandir/man8/*
%exclude %_mandir/man8/htcacheclean*
%exclude %_mandir/man8/suexec*

%files full

%files configs-A1PROXIED
%config(noreplace) %apache2_ports_available/http-A1PROXIED.conf
%ghost %apache2_ports_enabled/http-A1PROXIED.conf
%config(noreplace) %apache2_ports_start/020-A1PROXIED.conf
%ghost %apache2_sites_enabled/vhosts-A1PROXIED.conf
%config(noreplace) %apache2_sites_start/020-A1PROXIED.conf

%files docs
%docdir/manual

%files manual
%apache2_manualdir
%config(noreplace) %apache2_mods_start/*-manual.conf
%config(noreplace) %apache2_extra_available/httpd-manual.conf
%ghost %apache2_extra_enabled/httpd-manual.conf
%config(noreplace) %apache2_extra_start/*-manual.conf

%files manual-addons
%config(noreplace) %apache2_mods_start/*-manual-addons.conf
%config(noreplace) %apache2_extra_available/httpd-manual-addons.conf
%ghost %apache2_extra_enabled/httpd-manual-addons.conf
%config(noreplace) %apache2_extra_start/*-manual-addons.conf

%files datadirs
%dir %_datadir/%name/
%dir %_datadir/%name/cgi-bin/

%files cgi-bin-test-cgi
%_controldir/cgi-bin_test-cgi
%attr(644,root,root) %_datadir/%name/cgi-bin/test-cgi

%files cgi-bin-printenv
%_controldir/cgi-bin_printenv
%attr(644,root,root) %_datadir/%name/cgi-bin/printenv

%files cgi-bin

%files html
%apache2_htdocsdir/*.html

%files icons
%defattr(644,root,%apache2_webmaster,2775)
%apache2_iconsdir/README
%apache2_iconsdir/README.html
%apache2_iconsdir/*.gif
%apache2_iconsdir/*.png
%apache2_iconsdir/*.svg
%apache2_iconsdir/small/*.gif
%apache2_iconsdir/small/*.png

%files mod_ssl
%attr(0644,root,root) %apache2_sslcertshfunctions
%apache2_moduledir/mod_ssl.so
%attr(0600,root,root) %config(noreplace) %apache2_mods_available/ssl.load
%ghost %apache2_sites_enabled/default_https.conf
%ghost %apache2_sites_enabled/000-default_https.conf
%ghost %apache2_confdir/ssl.crt/server.crt
%ghost %apache2_confdir/ssl.key/server.key
%attr(2770,root,%apache2_group) %dir %apache2_proxycachedir/mod_ssl/
%attr(0600,%apache2_user,%apache2_group) %ghost %apache2_proxycachedir/mod_ssl/scache.dir
%attr(0600,%apache2_user,%apache2_group) %ghost %apache2_proxycachedir/mod_ssl/scache.pag
%attr(0600,%apache2_user,%apache2_group) %ghost %apache2_proxycachedir/mod_ssl/scache.sem
%doc %docdir/original/mods-available/ssl.load

%files mod_ldap
%apache2_moduledir/mod_*ldap.so

%files mod_cache_disk
%apache2_moduledir/mod_cache_disk.so
%config(noreplace) %apache2_mods_available/cache_disk.*
%attr(2770,root,%apache2_group) %dir %apache2_htcacheclean_cachepath/
%doc %docdir/original/mods-available/cache_disk.*

%files htcacheclean-control
%_controldir/htcacheclean-*

%files htcacheclean
%_sbindir/htcacheclean*
%_mandir/man8/htcacheclean*
%attr(0644,root,root) %config(noreplace) %_sysconfdir/sysconfig/%apache2_htcacheclean_dname
%_unitdir/%apache2_htcacheclean_dname.service
%config %_initdir/%apache2_htcacheclean_dname
%config %_sysconfdir/cron.daily/%apache2_htcacheclean_dname

%_rpmlibdir/*-%apache2_name-htcacheclean.filetrigger

%files ab
%_bindir/ab*

%files htpasswd
%_bindir/htpasswd*
%_mandir/man1/htpasswd*

%files -n rpm-build-%name
%_rpmlibdir/%name-files.req.list
%_rpmmacrosdir/%macrosname

%files devel
%apache2_basedir/build
%dir %apache2_includedir/
%apache2_includedir/.mmn
%apache2_includedir/ap_*
%apache2_includedir/[hmoprsu]*
%apache2_includedir/apache_noprobes.h
%apache2_includedir/cache_common.h

%_bindir/apxs*
%dir %apache2_installbuilddir/
%apache2_installbuilddir/[clprs]*.mk
%apache2_installbuilddir/instdso.sh

%_sbindir/envvars*

%files suexec
%apache2_moduledir/mod_suexec.so
%attr(4510,root,%apache2_group) %_sbindir/suexec*
%_mandir/man8/suexec*

%files compat
%config(noreplace) %apache2_sites_available/default-compat.conf
%ghost %apache2_sites_enabled/default-compat.conf
%ghost %apache2_sites_enabled/000-default-compat.conf
%config(noreplace) %apache2_sites_start/*-default-compat.conf
%ghost %apache2_extra_enabled/httpd-*-compat.conf
%config(noreplace) %apache2_extra_start/*-default-compat.conf
%dir %apache2_compat_htdocsdir/
%dir %apache2_compat_cgibindir/
%dir %apache2_compat_iconssmalldir/
%dir %apache2_compat_manualaddonsdir/

%files mod_ssl-compat
%ghost %apache2_sites_enabled/default_https-compat.conf
%ghost %apache2_sites_enabled/000-default_https-compat.conf

%changelog
