# %%branch_switch set %%branch_release use
#%%define branch_switch Mxx

%def_disable static

# for libdb selected
%def_without libdb42
%def_without libdb43
%def_without libdb44
%def_without libdb46
%def_without libdb47
%def_without libdb48

# for set libdb default
%define libdb_name libdb
%define libdb_v1 4
%define libdb_v2 %nil

# set %%libdb_switch
%if_with libdb42
%define libdb_switch libdb4.2
%endif
%if_with libdb43
%define libdb_switch libdb4.3
%endif
%if_with libdb44
%define libdb_switch libdb4.4
%endif
%if_with libdb46
%define libdb_switch libdb4.6
%endif
%if_with libdb47
%define libdb_switch libdb4.7
%endif
%if_with libdb48
%define libdb_switch libdb4.8
%endif

# set %%release_libdb
%if "%{?libdb_switch}" != ""
%define release_libdb .%{?libdb_switch}
# reset %%libdb_*
%define libdb_name %(echo %{?libdb_switch} | sed -r 's/^([[:alpha:]]+)[0-9]+\\.[0-9]+$/\\1/')
%define libdb_v1 %(echo %{?libdb_switch} | sed -r 's/^[[:alpha:]]+([0-9]+)\\.[0-9]+$/\\1/')
%define libdb_v2 %(echo %{?libdb_switch} | sed -r 's/^[[:alpha:]]+[0-9]+(\\.[0-9]+)$/\\1/')
%else
%undefine release_libdb
%endif

# set %%libdb_devel_build (for BuildPreReq)
%if "%libdb_v2" == ""
%define libdb_devel_build %libdb_name%libdb_v1-devel
%else
%define libdb_devel_build %libdb_name%libdb_v1.%libdb_v2-devel
%endif

# set %%libdb_v2_req (for Requires)
%if "%libdb_v2" == ""
%define libdb_v2_req %(rpm -q --whatprovides %libdb_devel_build | sed -r 's/^%libdb_name%libdb_v1\\.([^-]+)-devel-.+$/\\1/')
%else
%define libdb_v2_req %libdb_v2
%endif

# set %%libdb_devel_req (for Requires)
%define libdb_devel_req %libdb_name%libdb_v1.%libdb_v2_req-devel

# Build aprutil with corresponding apr version always
%define aprver 1
%define dbm_type db%libdb_v1%libdb_v2_req
%define apudir %name-%version

Name: aprutil%aprver
Version: 1.5.4
Release: %{branch_release alt1}%{?release_libdb}

Summary: Apache Portable Runtime Utility shared library
Group: System/Libraries
License: %asl
Url: http://apr.apache.org/
Packager: Boris Savelev <boris@altlinux.org>

#Source url: http://archive.apache.org/dist/apr/apr-util-%version.tar.gz
Source: %name-%version.tar
# ALT patchs and:
# * FreeSWITCH patchs:
#   + commits de417e99f0c41421f701f86ee5e4e507868be81f
#     and 512201c21a406a91f17be5163fc087df5a511455 of
#     git://git.freeswitch.org/freeswitch.git
# * Debian patchs:
#   + apu_config_dont_list_indep_libs.patch
#   + avoid_ldap_by_defaut.patch
#   + avoid_db_by-default.patch
Patch1: %name-%version-alt-all-0.1.patch

BuildRequires(pre): rpm-macros-branch
BuildPreReq: rpm-build-licenses
%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

%if_disabled static
BuildPreReq: %libdb_devel_build
%else
BuildPreReq: %libdb_devel_build-static
%endif

# Automatically added by buildreq on Wed Sep 03 2008
#BuildRequires: libapr1-devel libdb4-devel libexpat-devel zlib-devel
BuildRequires: libapr1-devel libexpat-devel zlib-devel libuuid-devel

%package -n lib%name
Summary: Apache Portable Runtime Utility shared library
Group: System/Libraries
Provides: lib%name-libdb = %libdb_v1.%libdb_v2_req
Requires: libapr1 > 1.3.0
Conflicts: libaprutil
Conflicts: libsubversion < 1.4.4-alt2.3.1

%package -n lib%name-devel
Summary: Apache Portable Runtime Utility development files
Group: Development/C
Requires: lib%name = %version-%release, libapr%aprver-devel > 1.3.0
Requires: %libdb_devel_req
Requires: libldap-devel
Conflicts: libaprutil-devel

%if_enabled static
%package -n lib%name-devel-static
Summary: Apache Portable Runtime Utility static library
Group: Development/C
Requires: lib%name-devel = %version-%release , libapr%aprver-devel-static > 1.3.0
Requires: %libdb_devel_req-static
%endif

%description
The mission of the Apache Portable Runtime (APR) is to provide a free
library of C data structures and routines, forming a system portability
layer to as many operating systems as possible, including Unices,
MS Win32, BeOS and OS/2.

%description -n lib%name
The mission of the Apache Portable Runtime (APR) is to provide a free
library of C data structures and routines, forming a system portability
layer to as many operating systems as possible, including Unices,
MS Win32, BeOS and OS/2.
This package contains APU shared library.

%description -n lib%name-devel
The mission of the Apache Portable Runtime (APR) is to provide a free
library of C data structures and routines, forming a system portability
layer to as many operating systems as possible, including Unices,
MS Win32, BeOS and OS/2.
This package contains APU development files.

%if_enabled static
%description -n lib%name-devel-static
The mission of the Apache Portable Runtime (APR) is to provide a free
library of C data structures and routines, forming a system portability
layer to as many operating systems as possible, including Unices,
MS Win32, BeOS and OS/2.
This package contains APU static library.
%endif

%package -n lib%name-pgsql
Group: System/Libraries
Summary: APR utility library PostgreSQL DBD driver
BuildRequires: postgresql-devel
Requires: lib%name = %version-%release

%description -n lib%name-pgsql
This package provides the PostgreSQL driver for the apr-util
DBD (database abstraction) interface.

%package -n lib%name-mysql
Group: System/Libraries
Summary: APR utility library MySQL DBD driver
BuildRequires: libMySQL-devel
Requires: lib%name = %version-%release

%description -n lib%name-mysql
This package provides the MySQL driver for the apr-util DBD
(database abstraction) interface.

%package -n lib%name-sqlite2
Group: System/Libraries
Summary: APR utility library SQLite DBD driver
BuildRequires: libsqlite-devel >= 2.0.0
Requires: lib%name = %version-%release

%description -n lib%name-sqlite2
This package provides the SQLite driver for the apr-util DBD
(database abstraction) interface.

%package -n lib%name-sqlite3
Group: System/Libraries
Summary: APR utility library SQLite DBD driver
BuildRequires: libsqlite3-devel >= 3.0.0
Requires: lib%name = %version-%release

%description -n lib%name-sqlite3
This package provides the SQLite driver for the apr-util DBD
(database abstraction) interface.

%package -n lib%name-ldap
Group: System/Libraries
Summary: APR utility library LDAP DBD driver
BuildRequires: libldap-devel
Requires: lib%name = %version-%release

%description -n lib%name-ldap
This package provides the LDAP driver for the apr-util DBD
(database abstraction) interface.

%package -n lib%name-freetds
Group: System/Libraries
Summary: APR utility library FreeTDS DBD driver
BuildRequires: libfreetds-devel
Requires: lib%name = %version-%release

%description -n lib%name-freetds
This package provides the FreeTDS driver for the apr-util DBD
(database abstraction) interface.

%package -n lib%name-odbc
Group: System/Libraries
Summary: APR utility library ODBC DBD driver
BuildRequires: libunixODBC-devel
Requires: lib%name = %version-%release

%description -n lib%name-odbc
This package provides the ODBC driver for the apr-util DBD
(database abstraction) interface.

%prep
%setup

# GCC >= 4.6 too smart and warns about unused variable even with 'tmp=0;' line.
# With -Werror this produce a compilation error and makes this test
# (style of ldap_set_rebind_proc routine) permanently failed.
sed -e 's#tmp=0;#return tmp;#' -i build/apu-conf.m4

%build
autoheader && autoconf
%configure \
	--with-apr=%prefix \
	--with-installbuilddir=%_datadir/apr-%aprver/build \
	--includedir=%_includedir/apu-%aprver \
	--with-berkeley-db --with-dbm=%dbm_type \
	--with-sqlite3 --with-sqlite2 --with-mysql --with-pgsql \
	--enable-dbd-dso \
	--with-ldap \
	%{subst_enable static}

%make_build

%install
%makeinstall_std
find %buildroot%_bindir -type f -print0 |
	xargs -r0 grep -FZl "%_builddir/%apudir" -- |
	xargs -r0 sed -i "s,%_builddir/%apudir,%_datadir/apr-%aprver," --
find %buildroot%_datadir -type f -print0 |
	xargs -r0 grep -FZl "%_builddir/%apudir" -- |
	xargs -r0 sed -i "s,%_builddir/%apudir\(/build\)\?,%_datadir/apr-%aprver/build," --

%check
%make check

%files -n lib%name
%_libdir/lib*.so.*
%dir %_libdir/apr-util-%aprver
%_libdir/apr-util-%aprver/apr_dbm_*.so

%files -n lib%name-devel
%_bindir/*-config
%_libdir/lib*.so
%_libdir/*.exp
%_pkgconfigdir/apr-util-%aprver.pc
%_includedir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib*.a
%endif

%files -n lib%name-pgsql
%_libdir/apr-util-%aprver/apr_dbd_pgsql*.so

%files -n lib%name-mysql
%_libdir/apr-util-%aprver/apr_dbd_mysql*.so

%files -n lib%name-sqlite2
%_libdir/apr-util-%aprver/apr_dbd_sqlite2*.so

%files -n lib%name-sqlite3
%_libdir/apr-util-%aprver/apr_dbd_sqlite3*.so

%files -n lib%name-ldap
%_libdir/apr-util-%aprver/apr_ldap*.so

%files -n lib%name-freetds
%_libdir/apr-util-%aprver/apr_dbd_freetds*.so

%files -n lib%name-odbc
%_libdir/apr-util-%aprver/apr_dbd_odbc*.so

%changelog
