Name: apt
Version: 0.5.15lorg2
Release: alt53.M80P.4

Summary: Debian's Advanced Packaging Tool with RPM support
Summary(ru_RU.UTF-8): Debian APT - Усовершенствованное средство управления пакетами с поддержкой RPM
License: GPL
Group: System/Configuration/Packaging
URL: http://apt-rpm.org

Source0: %name-%version.tar
Source1: apt.conf
Source2: genbasedir
Source3: README.rsync
Source4: apt.ru.po
Source5: apt.be.po
Source6: ChangeLog-rpm.old

Patch: apt-%version-%release.patch

# Normally not applied, but useful.
# still useful?
Patch101: apt-0.5.4cnc9-alt-getsrc-debug.patch

Requires: libapt = %version-%release
Requires: rpm >= 4.0.4-alt28, /etc/apt/pkgpriorities, apt-conf
# We need (lib)rpm which finds pkgs by labels in N-E:V-R:D@T format:
Requires: RPMQ(EPOCH)
Requires: RPMQ(BUILDTIME)
Requires: RPMQ(DISTTAG)
# for methods.
Requires: gzip, bzip2, xz
Requires: gnupg, alt-gpgkeys

# Older versions of update-kernel misunderstood the @-postfix (with buildtime
# and disttag), which is now added by APT to verstrs and the names of
# allow-duplicated pkgs. (Epoch was also treated differently before, but that
# was not important until we added disttags, which are also separated by :.)
Conflicts: update-kernel < 0.9.14-alt1
# Older versions of apt-scripts-nvidia relied on a certain format of the APT ids
# of allow-duplicated packages, which changed (due to appending buildtime).
Conflicts: apt-scripts-nvidia < 0.5.0-alt1

# for autopoint.
BuildPreReq: cvs

# for apt-pipe.
BuildPreReq: setproctitle-devel

%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

# Automatically added by buildreq on Sun Mar 30 2008
BuildRequires: bzlib-devel cvs docbook-utils gcc-c++ liblua5-devel libreadline-devel librpm-devel setproctitle-devel zlib-devel
BuildRequires: libgnutls-devel

%package -n libapt
Summary: APT's core libraries
Group: System/Libraries
PreReq: librpm >= 4.0.4-alt28

%package -n libapt-devel
Summary: Development files and documentation for APT's core libs
Summary(ru_RU.UTF-8): Файлы и документация для разработчиков, использующих библиотеки APT
Group: Development/C
Requires: libapt = %version-%release, librpm-devel >= 4.0.4-alt28

%package -n libapt-devel-static
Summary: Development static library for APT's libs
Summary(ru_RU.UTF-8): Статическая библиотека APT для разработчиков, использующих библиотеки APT
Group: Development/C
Requires: libapt-devel = %version-%release, librpm-devel-static >= 4.0.4-alt28

%package utils
Summary: Utilities to create APT repositories (the indices)
Summary(ru_RU.UTF-8): Утилиты для построения APT-репозиториев (индексов)
Group: Development/Other
Requires: %name = %EVR, mktemp >= 1:1.3.1, getopt
Requires: gnupg, sed

%package rsync
Summary: rsync method support for APT
Summary(ru_RU.UTF-8): Поддержка метода rsync для APT
Group: Development/Other
Requires: %name = %EVR, rsync >= 2.5.5-alt3

%package https
Summary: https method support for APT
Summary(ru_RU.UTF-8): Поддержка метода https для APT
Group: Other
Requires: %name = %EVR

# {{{ descriptions 
%define risk_usage_en This package is still under development.

%description
A port of Debian's APT tools for RPM based distributions,
or at least for Conectiva. It provides the apt-get utility that
provides a simpler, safer way to install and upgrade packages.
APT features complete installation ordering, multiple source
capability and several other unique features.

%risk_usage_en

%define risk_usage Данный пакет пока еще находится в стадии разработки.

%description -l ru_RU.UTF-8
Перенесенные из Debian средства управления пакетами APT, включающие
в себя поддержку RPM, выполненную компанией Conectiva (Бразилия).
Этот пакет содержит утилиту apt-get для простой и надежной установки
и обновления пакетов. APT умеет автоматически разрешать зависимости
при установке, обеспечивает установку из нескольких источников и
целый ряд других уникальных возможностей.

%risk_usage

%description -n libapt
This package contains APT's package manipulation library,
modified for RPM.

%risk_usage_en

%description -n libapt-devel
This package contains the header files and libraries for developing with
APT's package manipulation library, modified for RPM.

%risk_usage_en

%description -n libapt-devel-static
This package contains static libraries for developing with APT's
package manipulation library, modified for RPM.

%risk_usage_en

%description utils
This package contains the utility programs that can prepare a repository of
RPMS binary and source packages for future access by APT (by generating
the indices): genbasedir, genpkglist, gensrclist.

It relates to 'apt' package analoguously to how 'rpm' relates to 'rpm-build' package.

%risk_usage_en

%description rsync
This package contains method 'rsync' for APT.

%risk_usage_en

%description https
This package contains method 'https' for APT.

%risk_usage_en

%description -n libapt -l ru_RU.UTF-8
В этом пакете находится библиотеки управления пакетами
из комплекта APT. В отличие от оригинальной версии для Debian, этот
пакет содержит поддержку для формата RPM.

%risk_usage

%description -n libapt-devel -l ru_RU.UTF-8
В этом пакете находятся заголовочные файлы и библиотеки для разработки
программ, использующих библиотеки управления пакетами
из комплекта APT. В отличие от оригинальной версии для Debian, этот
пакет содержит поддержку для формата RPM.

%risk_usage

%description -n libapt-devel-static -l ru_RU.UTF-8
В этом пакете находятся статические библиотеки для разработки программ,
использующих библиотеки управления пакетами из
комплекта APT. В отличие от оригинальной версии для Debian, этот пакет
содержит поддержку для формата RPM.

%risk_usage

%description utils -l ru_RU.UTF-8
В этом пакете находятся программы-утилиты, которые могут репозиторий
бинарных и исходных пакетов RPM приготовить для доступа с помощью APT
(сгенерировать индексы): genbasedir, genpkglist, gensrclist.

Он относится к пакету 'apt' аналогично тому, как 'rpm'к 'rpm-build'.

%risk_usage

%description rsync -l ru_RU.UTF-8
В этом пакете находится метод 'rsync' для APT

%risk_usage

%description https -l ru_RU.UTF-8
В этом пакете находится метод 'https' для APT

%risk_usage

# }}}

%prep
%setup
%patch -p1

find -type f -name \*.orig -delete

# Ensure system-wide lua5 in use.
rm -rf lua

# Turn it on only if you want to see the debugging messages:
#%%patch101 -p1 -b .getsrc-debug

install -pm644 %SOURCE3 %SOURCE6 .
install -pm644 %SOURCE4 po/ru.po
install -pm644 %SOURCE5 po/be.po
sed -i 's|^\(.\+\)$|\1 be|' po/LINGUAS

# Drop obsolete m4/*.m4 files.
rm m4/*.m4

%build
# Fix url.
sed -i 's,/usr/share/common-licenses/GPL,/usr/share/license/GPL,' COPYING

# Unhide potential cc/c++ errors.
sed -i 's, > /dev/null 2>&1,,' buildlib/tools.m4

# Add trivial arch translation.
printf '%_target_cpu\t%_target_cpu' >> buildlib/archtable

%autoreconf
%add_optflags -std=c++11
%add_optflags -DAPTRPM_ID=\\\"%name-%{?epoch:%epoch:}%version-%release%{?disttag::%disttag}.%_target_cpu\\\"
%configure --includedir=%_includedir/apt-pkg %{subst_enable static}

# Probably this obsolete now?
find -type f -print0 |
	xargs -r0 grep -EZl '/var(/lib)?/state/apt' -- |
	xargs -r0 %__subst -p 's,/var\(/lib\)\?/state/apt,%_localstatedir/%name,g' --
%make_build

%install
mkdir -p %buildroot%_sysconfdir/%name/{%name.conf,sources.list,vendors.list,preferences}.d
mkdir -p %buildroot%_libdir/%name/scripts
mkdir -p %buildroot%_localstatedir/%name/{lists/partial,prefetch}
mkdir -p %buildroot%_cachedir/%name/{archives/partial,gen{pkg,src}list}

%makeinstall includedir=%buildroot%_includedir/apt-pkg

install -pm755 %SOURCE2 %buildroot%_bindir/
install -pm644 %SOURCE1 %buildroot%_sysconfdir/%name/

# This is still needed.
ln -sf rsh %buildroot%_libdir/%name/methods/ssh
ln -sf gzip %buildroot%_libdir/%name/methods/bzip2
ln -sf gzip %buildroot%_libdir/%name/methods/xz

# Cleanup
find %buildroot%_includedir -type f -name rpmshowprogress.h -delete -print
rm %buildroot%_libdir/*.la

bzip2 -9fk ChangeLog-rpm.old

find %buildroot%_includedir -type f -name '*.h' |while read f; do
	cat >>"$f" <<EOF

#include <stdint.h>
#if __WORDSIZE == 32 && !defined(__USE_FILE_OFFSET64)
# error "<${f#%buildroot%_includedir/}> cannot be used without -D_FILE_OFFSET_BITS==64"
#endif
EOF
done

%find_lang %name

unset RPM_PYTHON

%set_verify_elf_method strict

%files -f %name.lang
%_bindir/apt-*
%_libdir/%name
%exclude %_libdir/%name/methods/rsync
%exclude %_libdir/%name/methods/https
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/%name.conf
%dir %_sysconfdir/%name/*.d
%_mandir/man?/*
%doc README* TODO COPYING AUTHORS* ChangeLog-rpm.old.bz2 doc/examples contrib

%defattr(2770,root,rpm,2770)
%_cachedir/%name/archives

%files -n libapt
%_libdir/*.so.*
%_localstatedir/%name

%defattr(2770,root,rpm,2770)
%dir %_cachedir/%name

%files -n libapt-devel
%_libdir/*.so
%_includedir/*

%if_enabled static
%files -n libapt-devel-static
%_libdir/*.a
%endif

%files rsync
%dir %_libdir/%name
%dir %_libdir/%name/methods
%_libdir/%name/methods/rsync
# Probably %%doc with README.rsync?

%files https
%dir %_libdir/%name
%dir %_libdir/%name/methods
%_libdir/%name/methods/https

%changelog
