Name: apt-indicator
Version: 0.3.11
Release: alt2.M80P.2

Summary: Applet for indication that newer packages are available
License: GPL
Group: System/Configuration/Packaging
Url: http://apt-indicator.sourceforge.net/
Packager: Sergey V Turchin <zerg@altlinux.org>

Source: %name-%version.tar

Provides: egg = %version-%release, alt-update = %version-%release
Obsoletes: egg < %version-%release, alt-update < %version-%release
Requires: /usr/bin/xdg-su /usr/sbin/synaptic

BuildRequires: gcc-c++ libstdc++-devel qt5-base-devel qt5-tools
BuildRequires: docbook-dtds docbook-style-xsl help2man libapt-devel
BuildRequires: xml-common xsltproc
#BuildRequires: libdb4.4-devel

%description
This package contains simple applet both for Gnome and KDE which
made notifications for users that newer packages are available.


%prep
%setup -q -n %name-%version
%ifarch %e2k
%remove_optflags -Wno-error
%endif
%qmake_qt5 "CONFIG += release"

%build
%make
%make -C doc
lrelease-qt5 checker/checker.pro
lrelease-qt5 agent/agent.pro
help2man --output=apt-indicator.1 --no-info apt-indicator ||:

%install
%make INSTALL_ROOT=%buildroot install

mkdir -p %buildroot/%_datadir/%name/translations/
install -m644 translations/apt_indicator_*.qm %buildroot/%_datadir/%name/translations/
mkdir -p %buildroot/%_man1dir/
[ -f %{name}.1 ] \
    && install -m644 %{name}.1 %buildroot/%_man1dir/
mkdir -p %buildroot/%_datadir/applications/
install -m644 %name.desktop %buildroot/%_datadir/applications/%name.desktop

for d in %_sysconfdir/xdg/autostart
do
mkdir -p %buildroot/$d/
install -m644 %name.desktop %buildroot/$d/%name.desktop
sed -i 's|\(^Exec=.*\)|\1 --autostarted|' %buildroot/$d/%name.desktop
done

# docs
ln -sf %_docdir/%name-%version/html %buildroot/%_datadir/%name/doc
mkdir -p %buildroot/%_datadir/%name/pixmaps


%files
%doc doc/html doc/images NEWS TODO README
%_bindir/*
#%_man1dir/*
%_datadir/%name
%_datadir/applications/%name.desktop
%_sysconfdir/xdg/autostart/apt-indicator.desktop


%changelog
